/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.searchandreplace;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.searchandreplace.Parameters;

@UsingParameters(value=Parameters.class)
public class SearchAndReplaceStep
extends BasePipelineStep {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Parameters params = new Parameters();
    private Matcher matcher;
    private Pattern[] patterns;
    private URI outputURI;
    private LocaleId targetLocale;
    private String[] search;
    private String[] replace;
    private boolean firstEventDone = false;

    @Override
    public void destroy() {
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getDescription() {
        return "Performs search and replace on the entire file or the text units. Expects raw document or filter events. Sends back: raw document or filter events.";
    }

    @Override
    public String getName() {
        return "Search and Replace";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        int i;
        if (this.params.regEx) {
            int flags = 0;
            this.patterns = new Pattern[this.params.rules.size()];
            if (this.params.dotAll) {
                flags |= 0x20;
            }
            if (this.params.ignoreCase) {
                flags |= 2;
            }
            if (this.params.multiLine) {
                flags |= 8;
            }
            for (int i2 = 0; i2 < this.params.rules.size(); ++i2) {
                String[] s = this.params.rules.get(i2);
                if (!this.params.regEx) continue;
                this.patterns[i2] = Pattern.compile(s[1], flags);
            }
        } else {
            this.search = new String[this.params.rules.size()];
            for (i = 0; i < this.params.rules.size(); ++i) {
                this.search[i] = this.unescape(this.params.rules.get(i)[1], false);
            }
        }
        this.replace = new String[this.params.rules.size()];
        for (i = 0; i < this.params.rules.size(); ++i) {
            this.replace[i] = this.unescape(this.params.rules.get(i)[2], this.params.regEx);
        }
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        if (!this.firstEventDone) {
            this.firstEventDone = true;
        }
        String encoding = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        String result = null;
        StringBuilder assembled = new StringBuilder();
        try {
            File outFile;
            RawDocument rawDoc = (RawDocument)event.getResource();
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(rawDoc.getStream(), rawDoc.getEncoding());
            detector.detectAndRemoveBom();
            encoding = detector.getEncoding();
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                assembled.append(buf, 0, numRead);
            }
            reader.close();
            result = assembled.toString();
            assembled = null;
            if (this.isLastOutputStep()) {
                outFile = new File(this.outputURI);
                Util.createDirectories(outFile.getAbsolutePath());
            } else {
                try {
                    outFile = File.createTempFile("okp-snr_", ".tmp");
                }
                catch (Throwable e) {
                    throw new OkapiIOException("Cannot create temporary output.", e);
                }
                outFile.deleteOnExit();
            }
            result = this.searchAndReplace(result);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding));
            Util.writeBOMIfNeeded(writer, detector.hasUtf8Bom(), encoding);
            writer.write(result);
            writer.close();
            event.setResource(new RawDocument(outFile.toURI(), encoding, rawDoc.getSourceLocale(), rawDoc.getTargetLocale()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return event;
    }

    private String unescape(String s, boolean isRegex) {
        int i = 0;
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        block7: while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < len) {
                c = s.charAt(i++);
                switch (c) {
                    case 'u': {
                        c = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                        sb.append(c);
                        i += 4;
                        continue block7;
                    }
                    case 'N': {
                        sb.append(System.getProperty("line.separator"));
                        continue block7;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block7;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block7;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    default: {
                        if (!isRegex) break;
                        sb.append('\\');
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    protected Event handleTextUnit(Event event) {
        TextUnit tu;
        if (!this.firstEventDone) {
            this.firstEventDone = true;
        }
        if (!(tu = (TextUnit)event.getResource()).isTranslatable()) {
            return event;
        }
        String tmp = null;
        try {
            TextContainer tc;
            if (this.params.source) {
                tc = tu.getSource();
                for (Segment seg : tc.getSegments()) {
                    tmp = this.searchAndReplace(seg.text.toString());
                    seg.text.setCodedText(tmp);
                }
            }
            if (this.params.target && (tc = tu.getTarget(this.targetLocale)) != null) {
                for (Segment seg : tc.getSegments()) {
                    tmp = this.searchAndReplace(seg.text.toString());
                    seg.text.setCodedText(tmp);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, String.format("Error when updating content: '%s'.\n" + e.getMessage(), tmp), e);
        }
        return event;
    }

    private String searchAndReplace(String result) {
        if (this.params.regEx) {
            for (int i = 0; i < this.params.rules.size(); ++i) {
                String[] s = this.params.rules.get(i);
                if (!s[0].equals("true")) continue;
                this.matcher = this.patterns[i].matcher(result);
                result = this.matcher.replaceAll(this.replace[i]);
            }
        } else {
            for (int i = 0; i < this.params.rules.size(); ++i) {
                if (!this.params.rules.get(i)[0].equals("true")) continue;
                result = result.replace(this.search[i], this.replace[i]);
            }
        }
        return result;
    }

    public static enum ProcType {
        UNSPECIFIED,
        PLAINTEXT,
        FILTER;

    }
}

