/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.segmentation;

import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.steps.segmentation.Parameters;

@UsingParameters(value=Parameters.class)
public class SegmentationStep
extends BasePipelineStep {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Parameters params = new Parameters();
    private ISegmenter srcSeg = null;
    private ISegmenter trgSeg;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean initDone;
    private String rootDir;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getName() {
        return "Segmentation";
    }

    @Override
    public String getDescription() {
        return "Apply SRX segmentation to the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.initDone = false;
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        if (this.initDone) {
            return event;
        }
        SRXDocument srxDoc = new SRXDocument();
        String src = null;
        if (this.params.segmentSource) {
            src = Util.fillRootDirectoryVariable(this.params.getSourceSrxPath(), this.rootDir);
            srxDoc.loadRules(src);
            if (srxDoc.hasWarning()) {
                this.logger.warning(srxDoc.getWarning());
            }
            if (this.params.trimSrcLeadingWS != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimLeadingWhitespaces(this.params.trimSrcLeadingWS == Parameters.TRIM_YES);
            }
            if (this.params.trimSrcTrailingWS != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimTrailingWhitespaces(this.params.trimSrcTrailingWS == Parameters.TRIM_YES);
            }
            this.srcSeg = srxDoc.compileLanguageRules(this.sourceLocale, null);
        }
        if (this.params.segmentTarget) {
            String trg = Util.fillRootDirectoryVariable(this.params.getTargetSrxPath(), this.rootDir);
            if (Util.isEmpty(src) || !src.equals(trg)) {
                srxDoc.loadRules(trg);
                if (srxDoc.hasWarning()) {
                    this.logger.warning(srxDoc.getWarning());
                }
                if (srxDoc.hasWarning()) {
                    this.logger.warning(srxDoc.getWarning());
                }
            }
            if (this.params.trimTrgLeadingWS != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimLeadingWhitespaces(this.params.trimTrgLeadingWS == Parameters.TRIM_YES);
            }
            if (this.params.trimTrgTrailingWS != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimTrailingWhitespaces(this.params.trimTrgTrailingWS == Parameters.TRIM_YES);
            }
            this.trgSeg = srxDoc.compileLanguageRules(this.targetLocale, null);
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        IParameters prm;
        if (this.params.getForcesegmentedOutput() && (prm = event.getStartDocument().getFilterParameters()) != null) {
            prm.setInteger("outputSegmentationType", 3);
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        TextUnit tu = (TextUnit)event.getResource();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (this.params.segmentSource && (this.params.getOverwriteSegmentation() || !tu.getSource().hasBeenSegmented())) {
            tu.createSourceSegmentation(this.srcSeg);
        }
        TextContainer trgCont = tu.getTarget(this.targetLocale);
        if (this.params.segmentTarget && trgCont != null && (this.params.getOverwriteSegmentation() || !trgCont.hasBeenSegmented())) {
            this.trgSeg.computeSegments(trgCont);
            trgCont.getSegments().create(this.trgSeg.getRanges());
        }
        if (this.params.copySource) {
            trgCont = tu.createTarget(this.targetLocale, false, 7);
        }
        if (this.params.checkSegments && trgCont != null) {
            if (trgCont.getSegments().count() != tu.getSource().getSegments().count()) {
                this.logger.warning(String.format("Text unit id='%s': Source and target do not have the same number of segments.", tu.getId()));
            } else {
                ISegments trgSegs = trgCont.getSegments();
                for (Segment seg : tu.getSource().getSegments()) {
                    if (trgSegs.get(seg.id) != null) continue;
                    this.logger.warning(String.format("Text unit id='%s': No target match found for source segment id='%s'", tu.getId(), seg.id));
                }
            }
        }
        return event;
    }
}

