/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.tokenization.Tokenizer;
import net.sf.okapi.steps.tokenization.tokens.Tokens;
import net.sf.okapi.steps.wordcount.common.BaseCounter;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;
import net.sf.okapi.steps.wordcount.common.StructureParameters;

public class WordCounter
extends BaseCounter {
    private static StructureParameters params;

    protected static void loadParameters() {
        if (params != null) {
            return;
        }
        params = new StructureParameters();
        if (params == null) {
            return;
        }
        params.loadFromResource("word_counter.tprm");
    }

    @Override
    protected long doCount(String text, LocaleId language) {
        Tokens tokens = Tokenizer.tokenize(text, language, WordCounter.getTokenName());
        if (tokens == null) {
            return 0L;
        }
        return tokens.size();
    }

    public static long count(TextUnit textUnit, LocaleId language) {
        return WordCounter.count(WordCounter.class, textUnit, language);
    }

    public static long count(TextContainer textContainer, LocaleId language) {
        return WordCounter.count(WordCounter.class, textContainer, language);
    }

    public static long count(Segment segment, LocaleId language) {
        return WordCounter.count(WordCounter.class, segment, language);
    }

    public static long count(TextFragment textFragment, LocaleId language) {
        return WordCounter.count(WordCounter.class, textFragment, language);
    }

    public static long count(String string, LocaleId language) {
        return WordCounter.count(WordCounter.class, string, language);
    }

    public static long getCount(IResource res) {
        return BaseCounter.getCount(res, "TotalWordCount");
    }

    public static long getCount(TextUnit tu) {
        return BaseCounter.getCount(tu, "TotalWordCount");
    }

    public static long getCount(TextContainer tc) {
        return BaseCounter.getCount(tc, "TotalWordCount");
    }

    public static long getCount(TextUnit tu, int segIndex) {
        ISegments segments = tu.getSource().getSegments();
        return WordCounter.getCount(segments.get(segIndex));
    }

    public static long getCount(Segment segment) {
        return BaseCounter.getCount(segment, "TotalWordCount");
    }

    public static String getTokenName() {
        WordCounter.loadParameters();
        if (params == null) {
            return "";
        }
        return params.getTokenName();
    }

    public static void setCount(IResource res, long count) {
        MetricsAnnotation ma = res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation(ma);
        }
        Metrics m = ma.getMetrics();
        m.setMetric("TotalWordCount", count);
    }
}

