/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public abstract class BaseCounter {
    private static BaseCounter counter = null;
    private static Logger logger = null;

    protected abstract long doCount(String var1, LocaleId var2);

    protected static long count(Class<? extends BaseCounter> classRef, Object text, LocaleId language) {
        if (text == null) {
            return 0L;
        }
        if (Util.isNullOrEmpty(language)) {
            return 0L;
        }
        if (text instanceof TextUnit) {
            TextUnit tu = (TextUnit)text;
            return BaseCounter.count(classRef, tu.getSource(), language);
        }
        if (text instanceof Segment) {
            Segment seg = (Segment)text;
            return BaseCounter.count(classRef, seg.getContent(), language);
        }
        if (text instanceof TextContainer) {
            TextContainer tc = (TextContainer)text;
            long res = 0L;
            for (Segment seg : tc.getSegments()) {
                res += BaseCounter.count(classRef, seg, language);
            }
            return res;
        }
        if (text instanceof TextFragment) {
            TextFragment tf = (TextFragment)text;
            return BaseCounter.count(classRef, TextUnitUtil.getText(tf), language);
        }
        if (text instanceof String) {
            BaseCounter.instantiateCounter(classRef);
            if (counter == null) {
                return 0L;
            }
            return counter.doCount((String)text, language);
        }
        return 0L;
    }

    protected static void instantiateCounter(Class<? extends BaseCounter> classRef) {
        if (counter != null) {
            return;
        }
        try {
            counter = classRef.newInstance();
        }
        catch (InstantiationException e) {
            BaseCounter.logMessage(classRef, Level.FINE, "Counter instantiation failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            BaseCounter.logMessage(classRef, Level.FINE, "Counter instantiation failed: " + e.getMessage());
        }
    }

    protected static void logMessage(Class<? extends BaseCounter> classRef, Level level, String text) {
        if (logger == null) {
            logger = Logger.getLogger(ClassUtil.getClassName(classRef));
        }
        if (logger != null) {
            logger.log(level, text);
        }
    }

    private static long getValue(MetricsAnnotation ma, String metricName) {
        if (ma == null) {
            return 0L;
        }
        Metrics m = ma.getMetrics();
        if (m == null) {
            return 0L;
        }
        return m.getMetric(metricName);
    }

    public static long getCount(Segment segment, String metricName) {
        return BaseCounter.getValue(segment.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public static long getCount(TextContainer tc, String metricName) {
        return BaseCounter.getValue(tc.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public static long getCount(IResource res, String metricName) {
        return BaseCounter.getValue(res.getAnnotation(MetricsAnnotation.class), metricName);
    }
}

