/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.reader;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    static final String GENERATE_TARGETS = "generateTargets";
    static final String USE_APPROVED_ONLY = "useApprovedOnly";
    static final String UPDATE_APPROVED_FLAG = "updateApprovedFlag";
    private boolean generateTargets;
    private boolean useApprovedOnly;
    private boolean updateApprovedFlag;

    public Parameters() {
        this.reset();
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.generateTargets = this.buffer.getBoolean(GENERATE_TARGETS, this.generateTargets);
        this.useApprovedOnly = this.buffer.getBoolean(USE_APPROVED_ONLY, this.useApprovedOnly);
        this.updateApprovedFlag = this.buffer.getBoolean(UPDATE_APPROVED_FLAG, this.updateApprovedFlag);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(GENERATE_TARGETS, this.generateTargets);
        this.buffer.setParameter(USE_APPROVED_ONLY, this.useApprovedOnly);
        this.buffer.setParameter(UPDATE_APPROVED_FLAG, this.updateApprovedFlag);
        return this.buffer.toString();
    }

    @Override
    public void reset() {
        this.generateTargets = true;
        this.useApprovedOnly = false;
        this.updateApprovedFlag = true;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GENERATE_TARGETS, "Generate target files in the output directory", "Generate targets");
        desc.add(USE_APPROVED_ONLY, "Update target only if translation was approved", "Use only approved translation");
        desc.add(UPDATE_APPROVED_FLAG, "Update the approved flag if translation was approved", "Update approved flag");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("XLIFF Kit Reader Options", true, false);
        desc.addCheckboxPart(parametersDescription.get(GENERATE_TARGETS));
        desc.addCheckboxPart(parametersDescription.get(USE_APPROVED_ONLY));
        desc.addCheckboxPart(parametersDescription.get(UPDATE_APPROVED_FLAG));
        return desc;
    }

    public void setGenerateTargets(boolean generateTargets) {
        this.generateTargets = generateTargets;
    }

    public boolean isGenerateTargets() {
        return this.generateTargets;
    }

    public void setUseApprovedOnly(boolean useApprovedOnly) {
        this.useApprovedOnly = useApprovedOnly;
    }

    public boolean isUseApprovedOnly() {
        return this.useApprovedOnly;
    }

    public void setUpdateApprovedFlag(boolean updateApprovedFlag) {
        this.updateApprovedFlag = updateApprovedFlag;
    }

    public boolean isUpdateApprovedFlag() {
        return this.updateApprovedFlag;
    }
}

