/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.writer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.persistence.PersistenceSession;
import net.sf.okapi.steps.xliffkit.writer.Parameters;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.StreamHelper;
import org.apache.poi.openxml4j.opc.TargetMode;

@UsingParameters(value=Parameters.class)
public class XLIFFKitWriterStep
extends BasePipelineStep {
    private XLIFFWriter writer;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String docMimeType;
    private String docName;
    private String inputEncoding;
    private String configId;
    private Parameters params;
    private URI outputURI;
    private String resourcesFileExt = ".json";
    private String originalFileName;
    private String sourceFileName;
    private String xliffFileName;
    private String skeletonFileName;
    private String resourcesFileName;
    private String originalPartName;
    private String sourcePartName;
    private String xliffPartName;
    private String skeletonPartName;
    private String resourcesPartName;
    private String filterWriterClassName;
    private OPCPackage pack;
    private File tempXliff;
    private File tempResources;
    private PersistenceSession session;
    private List<String> sources = new ArrayList<String>();
    private List<String> originals = new ArrayList<String>();

    public XLIFFKitWriterStep() {
        this.params = new Parameters();
        this.session = new OkapiJsonSession();
        this.writer = new XLIFFWriter();
    }

    @Override
    public String getDescription() {
        return "Generate an XLIFF translation kit. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "XLIFF Kit Writer";
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case NO_OP: {
                return event;
            }
            case START_BATCH: {
                this.processStartBatch();
                break;
            }
            case END_BATCH: {
                this.processEndBatch();
                break;
            }
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case END_DOCUMENT: {
                this.session.serialize(event);
                this.processEndDocument();
                this.close();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case START_GROUP: {
                this.processStartGroup((StartGroup)event.getResource());
                break;
            }
            case END_GROUP: {
                this.processEndGroup((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: {
                TextUnit tu = (TextUnit)event.getResource();
                this.processTextUnit(tu);
                Event ev = new Event(EventType.TEXT_UNIT, tu.clone());
                tu.removeTarget(this.trgLoc);
                this.session.serialize(event);
                return ev;
            }
        }
        this.session.serialize(event);
        return event;
    }

    private void processStartBatch() {
        try {
            if (this.outputURI == null && this.params != null) {
                this.outputURI = new URI(this.params.getOutputURI());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        File outFile = new File(this.outputURI);
        if (outFile.exists()) {
            outFile.delete();
        }
        Util.createDirectories(outFile.getAbsolutePath());
        try {
            this.pack = OPCPackage.openOrCreate(outFile);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        this.writer.setCopySource(this.params.isCopySource());
        this.writer.setPlaceholderMode(this.params.isPlaceholderMode());
        this.session.setDescription(this.params.getMessage());
    }

    private void processEndBatch() {
        this.sources.clear();
        this.originals.clear();
        try {
            this.pack.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processStartDocument(StartDocument resource) {
        this.close();
        this.srcLoc = resource.getLocale();
        this.docMimeType = resource.getMimeType();
        this.docName = resource.getName();
        this.inputEncoding = resource.getEncoding();
        IParameters fparams = resource.getFilterParameters();
        this.configId = fparams == null ? null : fparams.getPath();
        this.originalFileName = Util.getFilename(this.docName, true);
        this.sourceFileName = Util.getFilename(this.docName, true);
        this.xliffFileName = this.originalFileName + ".xlf";
        this.resourcesFileName = this.originalFileName + this.resourcesFileExt;
        this.skeletonFileName = String.format("resources/%s/%s", this.sourceFileName, this.resourcesFileName);
        this.filterWriterClassName = resource.getFilterWriter().getClass().getName();
        try {
            this.tempXliff = File.createTempFile(this.xliffFileName, null);
            this.tempXliff.deleteOnExit();
            this.tempResources = File.createTempFile(this.resourcesFileName, null);
            this.tempResources.deleteOnExit();
            this.writer.create(this.tempXliff.getAbsolutePath(), this.skeletonFileName, resource.getLocale(), this.trgLoc, resource.getMimeType(), this.sourceFileName, this.params.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.session.start(new FileOutputStream(this.tempResources));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private PackagePart createPart(OPCPackage pack, PackagePart corePart, String name, File file, String contentType, String relationshipType) {
        PackagePart part = null;
        try {
            PackagePartName partName = PackagingURIHelper.createPartName("/" + name);
            if (pack.containPart(partName)) {
                return null;
            }
            part = pack.createPart(partName, contentType);
            if (corePart != null) {
                corePart.addRelationship(partName, TargetMode.INTERNAL, relationshipType);
            } else {
                pack.addRelationship(partName, TargetMode.INTERNAL, relationshipType);
            }
            try {
                FileInputStream is = new FileInputStream(file);
                OutputStream os = part.getOutputStream();
                StreamHelper.copyStream(is, os);
                try {
                    ((InputStream)is).close();
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        return part;
    }

    private void processEndDocument() {
        this.session.end();
        this.writer.close();
        this.originalPartName = String.format("content/original/%s/%s", this.srcLoc.toString(), this.originalFileName);
        this.sourcePartName = String.format("content/source/%s/%s", this.srcLoc.toString(), this.sourceFileName);
        this.xliffPartName = String.format("content/target/%s.%s/%s", this.srcLoc.toString(), this.trgLoc.toString(), this.xliffFileName);
        this.resourcesPartName = String.format("content/target/%s.%s/resources/%s/%s", this.srcLoc.toString(), this.trgLoc.toString(), this.sourceFileName, this.resourcesFileName);
        PackagePart corePart = this.createPart(this.pack, null, this.xliffPartName, this.tempXliff, "application/x-xliff+xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        this.createPart(this.pack, corePart, this.resourcesPartName, this.tempResources, this.session.getMimeType(), "http://schemas.okapi.org/2010/relationships/resources");
        if (this.params.isIncludeSource() && !this.sources.contains(this.docName)) {
            this.createPart(this.pack, corePart, this.sourcePartName, new File(this.docName), this.docMimeType, "http://schemas.okapi.org/2010/relationships/source");
            this.sources.add(this.docName);
        }
        if (this.params.isIncludeOriginal() && !this.originals.contains(this.docName)) {
            this.createPart(this.pack, corePart, this.originalPartName, new File(this.docName), this.docMimeType, "http://schemas.okapi.org/2010/relationships/original");
            this.originals.add(this.docName);
        }
    }

    private void processStartSubDocument(StartSubDocument resource) {
        this.writer.writeStartFile(resource.getName(), resource.getMimeType(), this.skeletonFileName);
    }

    private void processEndSubDocument(Ending resource) {
        this.writer.writeEndFile();
    }

    private void processStartGroup(StartGroup resource) {
        this.writer.writeStartGroup(resource.getId(), resource.getName(), resource.getType());
    }

    private void processEndGroup(Ending resource) {
        this.writer.writeEndGroup();
    }

    private void processTextUnit(TextUnit tu) {
        this.writer.writeTextUnit(tu);
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    public PersistenceSession getSession() {
        return this.session;
    }

    public void setSession(PersistenceSession session) {
        this.session = session;
    }

    public String getResourcesFileExt() {
        return this.resourcesFileExt;
    }

    public void setResourcesFileExt(String resourcesFileExt) {
        this.resourcesFileExt = resourcesFileExt;
    }
}

