/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.simpletm;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.translation.QueryResult;

public class Database {
    public static final String TBLNAME = "Source";
    public static final int KEY = 0;
    public static final String NKEY = "Key";
    public static final int NAME = 1;
    public static final String NNAME = "Name";
    public static final int TYPE = 2;
    public static final String NTYPE = "Type";
    public static final int SRCTEXT = 3;
    public static final String NSRCTEXT = "SrcText";
    public static final int SRCCODES = 4;
    public static final String NSRCCODES = "SrcCodes";
    public static final int TRGTEXT = 5;
    public static final String NTRGTEXT = "TrgText";
    public static final int TRGCODES = 6;
    public static final String NTRGCODES = "TrgCodes";
    public static final int GRPNAME = 7;
    public static final String NGRPNAME = "GroupName";
    public static final int FILENAME = 8;
    public static final String NFILENAME = "FileName";
    public static final String DATAFILE_EXT = ".h2.db";
    private Connection conn = null;
    private PreparedStatement qstm = null;
    private LocaleId trgLoc;
    private boolean penalizeSourceWithDifferentCodes = true;
    private boolean penalizeTargetWithDifferentCodes = true;
    private MatchType exactMatchType;
    private MatchType fuzzyMatchType;
    private String origin;

    public Database() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            if (this.qstm != null) {
                this.qstm.close();
                this.qstm = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPenalizeSourceWithDifferentCodes(boolean penalizeSourceWithDifferentCodes) {
        this.penalizeSourceWithDifferentCodes = penalizeSourceWithDifferentCodes;
    }

    public void setPenalizeTargetWithDifferentCodes(boolean penalizeTargetWithDifferentCodes) {
        this.penalizeTargetWithDifferentCodes = penalizeTargetWithDifferentCodes;
    }

    private void deleteFiles(String pathAndPattern) {
        File[] list;
        String dir = Util.getDirectoryName(pathAndPattern);
        File d = new File(dir);
        class WildcharFilenameFilter
        implements FilenameFilter {
            WildcharFilenameFilter() {
            }

            @Override
            public boolean accept(File dir, String name) {
                return Pattern.matches(".*?\\..*?\\.db", name);
            }
        }
        for (File f : list = d.listFiles(new WildcharFilenameFilter())) {
            f.delete();
        }
    }

    public void create(String path, boolean deleteExistingDB, LocaleId targetLocale) {
        Statement stm = null;
        try {
            this.close();
            String pathNoExt = path;
            if (pathNoExt.endsWith(DATAFILE_EXT)) {
                pathNoExt = pathNoExt.substring(0, pathNoExt.length() - DATAFILE_EXT.length());
            }
            if (new File(pathNoExt + DATAFILE_EXT).exists()) {
                if (!deleteExistingDB) {
                    return;
                }
                this.deleteFiles(pathNoExt + ".*");
            } else {
                Util.createDirectories(pathNoExt);
            }
            this.conn = DriverManager.getConnection("jdbc:h2:" + pathNoExt, "sa", "");
            this.origin = Util.getFilename(path, true);
            stm = this.conn.createStatement();
            stm.execute("CREATE TABLE Source (Key INTEGER IDENTITY PRIMARY KEY,Name VARCHAR,Type VARCHAR,SrcText VARCHAR,SrcCodes VARCHAR,TrgText VARCHAR,TrgCodes VARCHAR,GroupName VARCHAR,FileName VARCHAR,)");
            this.trgLoc = targetLocale;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void open(String path) {
        try {
            this.close();
            String pathNoExt = path;
            if (pathNoExt.endsWith(DATAFILE_EXT)) {
                pathNoExt = pathNoExt.substring(0, pathNoExt.length() - DATAFILE_EXT.length());
            }
            if (!new File(pathNoExt + DATAFILE_EXT).exists()) {
                return;
            }
            this.conn = DriverManager.getConnection("jdbc:h2:" + pathNoExt, "sa", "");
            this.origin = Util.getFilename(path, true);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getEntryCount() {
        Statement stm = null;
        try {
            stm = this.conn.createStatement();
            ResultSet result = stm.executeQuery("SELECT COUNT(Key) FROM Source");
            if (!result.first()) {
                int n = 0;
                return n;
            }
            int n = result.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int addEntry(TextUnit tu, String grpName, String fileName) {
        int count = 0;
        Statement pstm = null;
        try {
            if (!tu.hasTarget(this.trgLoc)) {
                int n = 0;
                return n;
            }
            TextContainer srcCont = tu.getSource();
            TextContainer trgCont = tu.getTarget(this.trgLoc);
            if (srcCont.hasBeenSegmented() && trgCont.hasBeenSegmented()) {
                pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s,%s) VALUES(?,?,?,?,?,?,?);", TBLNAME, NTYPE, NSRCTEXT, NSRCCODES, NTRGTEXT, NTRGCODES, NGRPNAME, NFILENAME));
                pstm.setString(1, tu.getType());
                pstm.setString(6, grpName);
                pstm.setString(7, fileName);
                int segIndex = 0;
                ISegments trgSegs = trgCont.getSegments();
                for (Segment srcSeg : srcCont.getSegments()) {
                    pstm.setString(2, srcSeg.text.getCodedText());
                    pstm.setString(3, Code.codesToString(srcSeg.text.getCodes(), true));
                    Segment trgSeg = trgSegs.get(srcSeg.id);
                    if (trgSeg == null) continue;
                    pstm.setString(4, trgSeg.text.getCodedText());
                    pstm.setString(5, Code.codesToString(trgSeg.text.getCodes(), true));
                    pstm.execute();
                    ++count;
                    ++segIndex;
                }
            } else {
                pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s,%s,%s) VALUES(?,?,?,?,?,?,?,?);", TBLNAME, NNAME, NTYPE, NSRCTEXT, NSRCCODES, NTRGTEXT, NTRGCODES, NGRPNAME, NFILENAME));
                pstm.setString(1, tu.getName());
                pstm.setString(2, tu.getType());
                pstm.setString(3, srcCont.getCodedText());
                pstm.setString(4, Code.codesToString(srcCont.getFirstContent().getCodes(), true));
                pstm.setString(5, trgCont.getCodedText());
                pstm.setString(6, Code.codesToString(trgCont.getFirstContent().getCodes(), true));
                pstm.setString(7, grpName);
                pstm.setString(8, fileName);
                pstm.execute();
                ++count;
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void clearAttributes() {
        this.createStatement(null);
    }

    public void createStatement(LinkedHashMap<String, String> attributes) {
        try {
            this.exactMatchType = MatchType.EXACT;
            this.fuzzyMatchType = MatchType.FUZZY;
            if (attributes == null) {
                this.qstm = this.conn.prepareStatement(String.format("SELECT %s,%s,%s,%s FROM %s WHERE %s=?", NSRCTEXT, NSRCCODES, NTRGTEXT, NTRGCODES, TBLNAME, NSRCTEXT));
            } else {
                StringBuilder tmp = new StringBuilder();
                tmp.append(String.format("SELECT %s,%s,%s,%s FROM %s WHERE %s=?", NSRCTEXT, NSRCCODES, NTRGTEXT, NTRGCODES, TBLNAME, NSRCTEXT));
                for (String name : attributes.keySet()) {
                    tmp.append(" AND ").append(name).append("=?");
                    if (!name.equals(NGRPNAME)) continue;
                    this.exactMatchType = MatchType.EXACT_UNIQUE_ID;
                    this.fuzzyMatchType = MatchType.FUZZY_UNIQUE_ID;
                }
                this.qstm = this.conn.prepareStatement(tmp.toString());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<QueryResult> query(TextFragment query, LinkedHashMap<String, String> attributes, int maxCount, int threshold) {
        try {
            if (this.qstm == null) {
                this.createStatement(attributes);
            }
            if (attributes != null) {
                int i = 2;
                for (String name : attributes.keySet()) {
                    this.qstm.setString(i, attributes.get(name));
                    ++i;
                }
            }
            this.qstm.setString(1, query.getCodedText());
            ResultSet result = this.qstm.executeQuery();
            if (!result.first()) {
                return null;
            }
            ArrayList<QueryResult> list = new ArrayList<QueryResult>();
            String queryCodes = query.getCodes().toString();
            do {
                QueryResult qr = new QueryResult();
                qr.origin = this.origin;
                qr.source = new TextFragment();
                qr.source.setCodedText(result.getString(1), Code.stringToCodes(result.getString(2)), false);
                qr.target = new TextFragment();
                qr.target.setCodedText(result.getString(3), Code.stringToCodes(result.getString(4)), false);
                qr.score = 100;
                qr.matchType = this.exactMatchType;
                if (this.penalizeSourceWithDifferentCodes && !queryCodes.equals(qr.source.getCodes().toString())) {
                    --qr.score;
                    qr.matchType = this.fuzzyMatchType;
                }
                if (this.penalizeTargetWithDifferentCodes && !queryCodes.equals(qr.target.getCodes().toString())) {
                    --qr.score;
                    qr.matchType = this.fuzzyMatchType;
                }
                if (qr.score < threshold) continue;
                list.add(qr);
            } while (result.next() && list.size() < maxCount);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportToTMX(String outputPath, LocaleId sourceLocale, LocaleId targetLocale) {
        Statement stm = null;
        TMXWriter writer = null;
        try {
            writer = new TMXWriter(outputPath);
            writer.writeStartDocument(sourceLocale, targetLocale, null, null, "sentence", "simpleTM", null);
            stm = this.conn.createStatement();
            ResultSet result = stm.executeQuery(String.format("SELECT %s,%s,%s,%s,%s,%s,%s FROM Source", NNAME, NGRPNAME, NFILENAME, NSRCTEXT, NSRCCODES, NTRGTEXT, NTRGCODES));
            if (result.first()) {
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                do {
                    TextUnit tu = new TextUnit("0");
                    TextFragment tf = new TextFragment();
                    tf.setCodedText(result.getString(4), Code.stringToCodes(result.getString(5)), false);
                    tu.setSourceContent(tf);
                    tf = new TextFragment();
                    tf.setCodedText(result.getString(6), Code.stringToCodes(result.getString(7)), false);
                    tu.setTargetContent(targetLocale, tf);
                    tu.setName(result.getString(1));
                    attributes.put(NGRPNAME, result.getString(2));
                    attributes.put(NFILENAME, result.getString(3));
                    writer.writeItem(tu, attributes);
                } while (result.next());
            }
            writer.writeEndDocument();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

