/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.its.IProcessor;
import org.w3c.its.ITSException;
import org.w3c.its.ITSRule;
import org.w3c.its.ITSTrace;
import org.w3c.its.ITraversal;
import org.w3c.its.NSContextManager;
import org.xml.sax.SAXException;

public class ITSEngine
implements IProcessor,
ITraversal {
    public static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String ITS_NS_URI = "http://www.w3.org/2005/11/its";
    public static final String ITS_NS_PREFIX = "its";
    public static final String ITSX_NS_URI = "http://www.w3.org/2008/12/its-extensions";
    public static final String ITSX_NS_PREFIX = "itsx";
    public static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    public static final String XLINK_NS_PREFIX = "xlink";
    private static final String FLAGNAME = "\u00ff";
    private static final String FLAGSEP = "\u001c";
    private static final String FLAGDEFAULTDATA = "???????\u001c\u001c\u001c\u001c\u001c\u001c";
    private static final int FP_TRANSLATE = 0;
    private static final int FP_DIRECTIONALITY = 1;
    private static final int FP_WITHINTEXT = 2;
    private static final int FP_TERMINOLOGY = 3;
    private static final int FP_LOCNOTE = 4;
    private static final int FP_PRESERVEWS = 5;
    private static final int FP_LANGINFO = 6;
    private static final int FP_TERMINOLOGY_DATA = 0;
    private static final int FP_LOCNOTE_DATA = 1;
    private static final int FP_LANGINFO_DATA = 2;
    private static final int FP_TRGPOINTER_DATA = 3;
    private static final int FP_IDVALUE_DATA = 4;
    private static final int TERMINFOTYPE_POINTER = 1;
    private static final int TERMINFOTYPE_REF = 2;
    private static final int TERMINFOTYPE_REFPOINTER = 3;
    private static final int LOCNOTETYPE_TEXT = 1;
    private static final int LOCNOTETYPE_POINTER = 2;
    private static final int LOCNOTETYPE_REF = 3;
    private static final int LOCNOTETYPE_REFPOINTER = 4;
    private static final int TRANSLATE_TRGPOINTER = 1;
    private DocumentBuilderFactory fact;
    private Document doc;
    private URI docURI;
    private NSContextManager nsContext;
    private XPathFactory xpFact;
    private XPath xpath;
    private ArrayList<ITSRule> rules;
    private Node node;
    private boolean startTraversal;
    private Stack<ITSTrace> trace;
    private boolean backTracking;
    private boolean translatableAttributeRuleTriggered;

    public ITSEngine(Document doc, URI docURI) {
        this.doc = doc;
        this.docURI = docURI;
        this.node = null;
        this.rules = new ArrayList();
        this.nsContext = new NSContextManager();
        this.nsContext.addNamespace(ITS_NS_PREFIX, ITS_NS_URI);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.xpFact = XPathFactory.newInstance();
        this.xpath = this.xpFact.newXPath();
        this.xpath.setNamespaceContext(this.nsContext);
    }

    public boolean getTranslatableAttributeRuleTriggered() {
        return this.translatableAttributeRuleTriggered;
    }

    @Override
    public void addExternalRules(URI docURI) {
        try {
            if (this.fact == null) {
                this.fact = DocumentBuilderFactory.newInstance();
                this.fact.setNamespaceAware(true);
                this.fact.setValidating(false);
            }
            Document rulesDoc = this.fact.newDocumentBuilder().parse(docURI.toString());
            this.addExternalRules(rulesDoc, docURI);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addExternalRules(Document rulesDoc, URI docURI) {
        this.compileRules(rulesDoc, docURI, false);
    }

    private void compileRules(Document rulesDoc, URI docURI, boolean isInternal) {
        try {
            XPathExpression expr = this.xpath.compile("//*[@selector]//namespace::*");
            NodeList nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                String prefix = nl.item(i).getLocalName();
                if (XML_NS_PREFIX.equals(prefix)) continue;
                String uri = nl.item(i).getNodeValue();
                this.nsContext.addNamespace(prefix, uri);
            }
            expr = this.xpath.compile("//its:rules");
            nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                NodeList nl2;
                Element rulesElem = (Element)nl.item(i);
                String href = rulesElem.getAttributeNS(XLINK_NS_URI, "href");
                if (href.length() > 0) {
                    int n = href.lastIndexOf(35);
                    if (n > -1) {
                        href = href.substring(0, n);
                    }
                    String baseFolder = "";
                    if (docURI != null) {
                        baseFolder = this.getPartBeforeFile(docURI);
                    }
                    for (Node node = rulesElem; node != null; node = node.getParentNode()) {
                        String xmlBase;
                        if (node.getNodeType() != 1 || (xmlBase = node.getAttribute("xml:base")).length() <= 0) continue;
                        if (xmlBase.endsWith("/")) {
                            xmlBase = xmlBase.substring(0, xmlBase.length() - 1);
                        }
                        baseFolder = !baseFolder.startsWith("/") ? xmlBase + "/" + baseFolder : xmlBase + baseFolder;
                    }
                    if (baseFolder.length() > 0) {
                        if (baseFolder.endsWith("/")) {
                            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
                        }
                        href = !href.startsWith("/") ? baseFolder + "/" + href : baseFolder + href;
                    }
                    URI linkedDoc = new URI(href);
                    this.loadLinkedRules(linkedDoc, isInternal);
                }
                if ((nl2 = (NodeList)(expr = this.xpath.compile("//its:*")).evaluate(rulesElem, XPathConstants.NODESET)).getLength() != 0) {
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        Element ruleElem = (Element)nl2.item(j);
                        if ("translateRule".equals(ruleElem.getLocalName())) {
                            this.compileTranslateRule(ruleElem, isInternal);
                        } else if ("withinTextRule".equals(ruleElem.getLocalName())) {
                            this.compileWithinTextRule(ruleElem, isInternal);
                        }
                        if ("langRule".equals(ruleElem.getLocalName())) {
                            this.compileLangRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("dirRule".equals(ruleElem.getLocalName())) {
                            this.compileDirRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locNoteRule".equals(ruleElem.getLocalName())) {
                            this.compileLocNoteRule(ruleElem, isInternal);
                            continue;
                        }
                        if (!"termRule".equals(ruleElem.getLocalName())) continue;
                        this.compileTermRule(ruleElem, isInternal);
                    }
                    continue;
                }
                break;
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPartBeforeFile(URI uri) {
        String tmp = uri.toString();
        int n = tmp.lastIndexOf(47);
        if (n == -1) {
            return uri.toString();
        }
        return tmp.substring(0, n + 1);
    }

    private void loadLinkedRules(URI docURI, boolean isInternal) {
        try {
            if (this.fact == null) {
                this.fact = DocumentBuilderFactory.newInstance();
                this.fact.setNamespaceAware(true);
                this.fact.setValidating(false);
            }
            Document rulesDoc = this.fact.newDocumentBuilder().parse(docURI.toString());
            this.compileRules(rulesDoc, docURI, isInternal);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void compileTranslateRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("translate");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'translate'.");
        }
        value = elem.getAttributeNS(ITSX_NS_URI, "targetPointer");
        if (value.length() > 0) {
            rule.info = value;
            rule.infoType = 1;
        }
        if ((value = elem.getAttributeNS(ITSX_NS_URI, "idValue")).length() > 0) {
            rule.idValue = value;
        }
        if ((value = elem.getAttributeNS(ITSX_NS_URI, "whiteSpaces")).length() > 0) {
            if ("preserve".equals(value)) {
                rule.preserveWS = true;
            } else if ("default".equals(value)) {
                rule.preserveWS = false;
            } else {
                throw new ITSException("Invalid value for 'witheSpaces'.");
            }
        }
        this.rules.add(rule);
    }

    private void compileDirRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(32);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("dir");
        if ("ltr".equals(value)) {
            rule.value = 1;
        } else if ("rtl".equals(value)) {
            rule.value = 0;
        } else if ("lro".equals(value)) {
            rule.value = 3;
        } else if ("rlo".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'dir'.");
        }
        this.rules.add(rule);
    }

    private void compileWithinTextRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("withinText");
        if ("yes".equals(value)) {
            rule.value = 1;
        } else if ("no".equals(value)) {
            rule.value = 0;
        } else if ("nested".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'withinText'.");
        }
        this.rules.add(rule);
    }

    private void compileTermRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("term");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'term'.");
        }
        value = elem.getAttribute("termInfoPointer");
        String value2 = elem.getAttribute("termInfoRef");
        String value3 = elem.getAttribute("termInfoRefPointer");
        if (value.length() > 0) {
            rule.infoType = 1;
            rule.info = value;
            if (value2.length() > 0 || value3.length() > 0) {
                throw new ITSException("Too many termInfoXXX attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 2;
            rule.info = value2;
            if (value3.length() > 0) {
                throw new ITSException("Too many termInfoXXX attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 3;
            rule.info = value3;
        }
        this.rules.add(rule);
    }

    private void compileLocNoteRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String type = elem.getAttribute("locNoteType");
        if (type.length() == 0) {
            throw new ITSException("locNoteType attribute missing.");
        }
        String value1 = "";
        NodeList list = elem.getElementsByTagNameNS(ITS_NS_URI, "locNote");
        if (list.getLength() > 0) {
            value1 = ITSEngine.getTextContent(list.item(0));
        }
        String value2 = elem.getAttribute("locNotePointer");
        String value3 = elem.getAttribute("locNoteRef");
        String value4 = elem.getAttribute("locNoteRefPointer");
        if (value1.length() > 0) {
            rule.infoType = 1;
            rule.info = value1;
            if (value2.length() > 0 || value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNoteXXX attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 2;
            rule.info = value2;
            if (value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNoteXXX attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 3;
            rule.info = value3;
            if (value4.length() > 0) {
                throw new ITSException("Too many locNoteXXX attributes specified");
            }
        } else if (value4.length() > 0) {
            rule.infoType = 4;
            rule.info = value4;
        }
        this.rules.add(rule);
    }

    private void compileLangRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = elem.getAttribute("langPointer");
        if (rule.info.length() == 0) {
            throw new ITSException("langPointer attribute missing.");
        }
        this.rules.add(rule);
    }

    @Override
    public void applyRules(int dataCategories) {
        this.translatableAttributeRuleTriggered = false;
        this.processGlobalRules(dataCategories);
        this.processLocalRules(dataCategories);
    }

    private void removeFlag(Node node) {
        if (node == null) {
            return;
        }
        node.setUserData(FLAGNAME, null, null);
        if (node.hasChildNodes()) {
            this.removeFlag(node.getFirstChild());
        }
        if (node.getNextSibling() != null) {
            this.removeFlag(node.getNextSibling());
        }
    }

    @Override
    public void disapplyRules() {
        this.removeFlag(this.doc.getDocumentElement());
        this.translatableAttributeRuleTriggered = false;
    }

    @Override
    public boolean backTracking() {
        return this.backTracking;
    }

    @Override
    public Node nextNode() {
        if (this.startTraversal) {
            this.startTraversal = false;
            ITSTrace startTrace = new ITSTrace();
            startTrace.translate = true;
            startTrace.isChildDone = true;
            this.trace.push(startTrace);
            this.node = this.doc.getFirstChild();
            this.trace.push(new ITSTrace(this.trace.peek(), false));
            this.updateTraceData(this.node);
            return this.node;
        }
        if (this.node != null) {
            this.backTracking = false;
            if (!this.trace.peek().isChildDone && this.node.hasChildNodes()) {
                ITSTrace tmp = new ITSTrace(this.trace.peek(), true);
                this.trace.pop();
                this.trace.push(tmp);
                this.node = this.node.getFirstChild();
                this.trace.push(new ITSTrace(this.trace.peek(), false));
            } else {
                Node TmpNode = this.node.getNextSibling();
                if (TmpNode == null) {
                    this.node = this.node.getParentNode();
                    this.trace.pop();
                    this.backTracking = true;
                } else {
                    this.node = TmpNode;
                    this.trace.pop();
                    this.trace.push(new ITSTrace(this.trace.peek(), false));
                }
            }
        }
        this.updateTraceData(this.node);
        return this.node;
    }

    private void updateTraceData(Node newNode) {
        if (newNode == null) {
            return;
        }
        String data = (String)newNode.getUserData(FLAGNAME);
        if (data == null) {
            return;
        }
        if (data.charAt(0) != '?') {
            this.trace.peek().translate = data.charAt(0) == 'y';
            this.trace.peek().targetPointer = this.getFlagData(data, 3);
        }
        this.trace.peek().idValue = this.getFlagData(data, 4);
        if (data.charAt(1) != '?') {
            switch (data.charAt(1)) {
                case '0': {
                    this.trace.peek().dir = 1;
                    break;
                }
                case '1': {
                    this.trace.peek().dir = 0;
                    break;
                }
                case '2': {
                    this.trace.peek().dir = 3;
                    break;
                }
                case '3': {
                    this.trace.peek().dir = 3;
                }
            }
        }
        if (data.charAt(2) != '?') {
            switch (data.charAt(2)) {
                case '0': {
                    this.trace.peek().withinText = 0;
                    break;
                }
                case '1': {
                    this.trace.peek().withinText = 1;
                    break;
                }
                case '2': {
                    this.trace.peek().withinText = 2;
                }
            }
        }
        if (data.charAt(3) != '?') {
            this.trace.peek().term = data.charAt(3) == 'y';
            this.trace.peek().termInfo = this.getFlagData(data, 0);
        }
        if (data.charAt(4) != '?') {
            this.trace.peek().locNote = this.getFlagData(data, 1);
        }
        if (data.charAt(5) != '?') {
            boolean bl = this.trace.peek().preserveWS = data.charAt(5) == 'y';
        }
        if (data.charAt(6) != '?') {
            this.trace.peek().language = this.getFlagData(data, 2);
        }
    }

    @Override
    public void startTraversal() {
        this.node = null;
        this.trace = new Stack();
        this.startTraversal = true;
    }

    private void clearInternalGlobalRules() {
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!this.rules.get((int)i).isInternal) continue;
            this.rules.remove(i);
            --i;
        }
    }

    private void processGlobalRules(int dataCategories) {
        try {
            this.clearInternalGlobalRules();
            this.compileRules(this.doc, this.docURI, true);
            for (ITSRule rule : this.rules) {
                if ((dataCategories & rule.ruleType) == 0) continue;
                XPathExpression expr = this.xpath.compile(rule.selector);
                NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                block22: for (int i = 0; i < NL.getLength(); ++i) {
                    switch (rule.ruleType) {
                        case 2: {
                            this.setFlag(NL.item(i), 0, rule.flag ? (char)'y' : 'n', true);
                            if (NL.item(i).getNodeType() == 2 && rule.flag) {
                                this.translatableAttributeRuleTriggered = true;
                            }
                            if (rule.infoType == 1) {
                                this.setFlag(NL.item(i), 3, rule.info, true);
                            }
                            if (rule.idValue != null) {
                                this.setFlag(NL.item(i), 4, this.resolveExpression(NL.item(i), rule.idValue), true);
                            }
                            this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                            continue block22;
                        }
                        case 32: {
                            this.setFlag(NL.item(i), 1, String.valueOf(rule.value).charAt(0), true);
                            continue block22;
                        }
                        case 4: {
                            this.setFlag(NL.item(i), 2, String.valueOf(rule.value).charAt(0), true);
                            continue block22;
                        }
                        case 16: {
                            this.setFlag(NL.item(i), 3, rule.flag ? (char)'y' : 'n', true);
                            switch (rule.infoType) {
                                case 1: {
                                    this.setFlag(NL.item(i), 0, this.resolvePointer(NL.item(i), rule.info), true);
                                    break;
                                }
                                case 2: {
                                    this.setFlag(NL.item(i), 0, "REF:" + rule.info, true);
                                    break;
                                }
                                case 3: {
                                    this.setFlag(NL.item(i), 0, "REF:" + this.resolvePointer(NL.item(i), rule.info), true);
                                }
                            }
                            continue block22;
                        }
                        case 8: {
                            this.setFlag(NL.item(i), 4, 'y', true);
                            switch (rule.infoType) {
                                case 1: {
                                    this.setFlag(NL.item(i), 1, rule.info, true);
                                    break;
                                }
                                case 2: {
                                    this.setFlag(NL.item(i), 1, this.resolvePointer(NL.item(i), rule.info), true);
                                    break;
                                }
                                case 3: {
                                    this.setFlag(NL.item(i), 1, "REF:" + rule.info, true);
                                    break;
                                }
                                case 4: {
                                    this.setFlag(NL.item(i), 1, "REF:" + this.resolvePointer(NL.item(i), rule.info), true);
                                }
                            }
                            continue block22;
                        }
                        case 1: {
                            this.setFlag(NL.item(i), 6, 'y', true);
                            this.setFlag(NL.item(i), 2, this.resolvePointer(NL.item(i), rule.info), true);
                        }
                    }
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private void processLocalRules(int dataCategories) {
        try {
            Attr attr;
            int i;
            NodeList NL;
            XPathExpression expr;
            if ((dataCategories & 2) > 0) {
                expr = this.xpath.compile("//*/@its:translate|//its:span/@translate");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "translateRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value = attr.getValue();
                    if (!"yes".equals(value) && !"no".equals(value)) {
                        throw new ITSException("Invalid value for 'translate'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 0, value.charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x20) > 0) {
                expr = this.xpath.compile("//*/@its:dir|//its:span/@dir");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "dirRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    int n = 1;
                    if ("rtl".equals(attr.getValue())) {
                        n = 1;
                    } else if ("ltr".equals(attr.getValue())) {
                        n = 0;
                    } else if ("rlo".equals(attr.getValue())) {
                        n = 2;
                    } else if ("lro".equals(attr.getValue())) {
                        n = 3;
                    } else {
                        throw new ITSException("Invalid value for 'dir'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 1, String.format("%d", n).charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x10) > 0) {
                expr = this.xpath.compile("//*/@its:term|//its:span/@term//*/@its:termInfoRef|//its:span/@termInfoRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i2 = 0; i2 < NL.getLength(); ++i2) {
                    attr = (Attr)NL.item(i2);
                    String localName = attr.getLocalName();
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "termRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    if (localName.equals("term")) {
                        String value = attr.getValue();
                        if (!"yes".equals(value) && !"no".equals(value)) {
                            throw new ITSException("Invalid value for 'term'.");
                        }
                        this.setFlag((Node)attr.getOwnerElement(), 3, value.charAt(0), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("termInfoPointer")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 0, "REF:" + this.resolvePointer(attr.getOwnerElement(), attr.getValue()), attr.getSpecified());
                }
            }
            if ((dataCategories & 8) > 0) {
                expr = this.xpath.compile("//*/@its:locNote|//its:span/@locNote//*/@its:locNoteRef|//its:span/@locNoteRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i3 = 0; i3 < NL.getLength(); ++i3) {
                    attr = (Attr)NL.item(i3);
                    String localName = attr.getLocalName();
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "locNoteRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 4, 'y', attr.getSpecified());
                    if (localName.equals("locNote")) {
                        this.setFlag((Node)attr.getOwnerElement(), 1, attr.getValue(), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("termInfoPointer")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 1, "REF:" + this.resolvePointer(attr.getOwnerElement(), attr.getValue()), attr.getSpecified());
                }
            }
            if ((dataCategories & 1) > 0) {
                expr = this.xpath.compile("//*/@xml:lang");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    this.setFlag((Node)attr.getOwnerElement(), 6, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 2, attr.getValue(), attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:space");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value = attr.getValue();
                if (!"preserve".equals(value) && !"default".equals(value)) {
                    throw new ITSException("Invalid value for 'xml:space'.");
                }
                this.setFlag((Node)attr.getOwnerElement(), 5, "preserve".equals(value) ? (char)'y' : '?', attr.getSpecified());
            }
            expr = this.xpath.compile("//*/@xml:id");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value = attr.getValue();
                if (value == null || value.length() <= 0) continue;
                this.setFlag((Node)attr.getOwnerElement(), 4, value, attr.getSpecified());
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTextContent(Node node) {
        Node tmp = node.getFirstChild();
        while (tmp != null) {
            if (tmp.getNodeType() == 3) {
                return tmp.getNodeValue();
            }
            tmp = tmp.getNextSibling();
        }
        return "";
    }

    private String resolvePointer(Node node, String pointer) {
        try {
            XPathExpression expr = this.xpath.compile(pointer);
            NodeList list = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            if (list == null || list.getLength() == 0) {
                return "";
            }
            switch (list.item(0).getNodeType()) {
                case 1: {
                    return ITSEngine.getTextContent(list.item(0));
                }
                case 2: {
                    return list.item(0).getNodeValue();
                }
            }
        }
        catch (XPathExpressionException e) {
            return "Bab XPath expression in pointer \"" + pointer + "\".";
        }
        return "pointer(" + pointer + ")";
    }

    private String resolveExpression(Node node, String expression) {
        String res = "";
        try {
            XPathExpression expr = this.xpath.compile(expression);
            res = (String)expr.evaluate(node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            return "Bab XPath expression \"" + expression + "\".";
        }
        return res;
    }

    private void setFlag(Node node, int position, char value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        if (override || data.charAt(position) != '?') {
            data.setCharAt(position, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private void setFlag(Node node, int position, String value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (override || n2 > n1 + 1) {
            data.replace(n1 + 1, n2, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private String getFlagData(String data, int position) {
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (n2 > n1 + 1) {
            return data.substring(n1 + 1, n2);
        }
        return "";
    }

    @Override
    public boolean translate() {
        return this.trace.peek().translate;
    }

    @Override
    public boolean translate(Attr attribute) {
        if (attribute == null) {
            return false;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(0) == 'y';
    }

    @Override
    public String getTargetPointer() {
        return this.trace.peek().targetPointer;
    }

    @Override
    public String getIdValue() {
        return this.trace.peek().idValue;
    }

    @Override
    public int getDirectionality() {
        return this.trace.peek().dir;
    }

    @Override
    public int getDirectionality(Attr attribute) {
        if (attribute == null) {
            return 1;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return 1;
        }
        return tmp.charAt(1);
    }

    @Override
    public int getWithinText() {
        return this.trace.peek().withinText;
    }

    @Override
    public boolean isTerm() {
        return this.trace.peek().term;
    }

    @Override
    public boolean isTerm(Attr attribute) {
        if (attribute == null) {
            return false;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(3) == 'y';
    }

    @Override
    public String getNote() {
        return this.trace.peek().locNote;
    }

    @Override
    public String getNote(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(4) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 1);
    }

    @Override
    public boolean preserveWS() {
        return this.trace.peek().preserveWS;
    }

    @Override
    public String getLanguage() {
        return this.trace.peek().language;
    }
}

