/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FilenameFilter;
import net.sf.okapi.common.Util;

public class DefaultFilenameFilter
implements FilenameFilter {
    private String extension;
    private String prefix;

    public DefaultFilenameFilter(String extension) {
        this.extension = extension;
    }

    public DefaultFilenameFilter(String prefix, String extension) {
        this.prefix = prefix;
        this.extension = extension;
    }

    @Override
    public boolean accept(File directory, String fileName) {
        boolean bOK = true;
        if (fileName != null) {
            if (this.extension != null) {
                bOK &= this.extension.equalsIgnoreCase(Util.getExtension(fileName));
            }
            if (this.prefix != null) {
                bOK &= fileName.startsWith(this.prefix);
            }
        }
        return bOK;
    }
}

