/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMAwareInputStream;

public final class FileUtil {
    public static File[] getFilteredFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = FileUtil.getFilteredFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> getFilteredFiles(File directory, FilenameFilter filter, boolean recurse) {
        LinkedList<File> files = new LinkedList<File>();
        File[] entries = directory.listFiles();
        if (entries == null) {
            return files;
        }
        for (File entry : entries) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(FileUtil.getFilteredFiles(entry, filter, recurse));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> guessLanguages(String path) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String encoding = Charset.defaultCharset().name();
            BOMAwareInputStream bis = new BOMAwareInputStream(new FileInputStream(path), encoding);
            encoding = bis.detectEncoding();
            reader = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
            String trgValue = null;
            Pattern pattern = Pattern.compile("\\s(srclang|source-?language|xml:lang|lang|(target-?)?language)\\s*?=\\s*?['\"](.*?)['\"]", 2);
            int scanned = 0;
            do {
                String line;
                if ((line = reader.readLine()) == null) {
                    ArrayList<String> arrayList = list;
                    return arrayList;
                }
                scanned += line.length();
                Matcher m = pattern.matcher(line);
                int pos = 0;
                while (m.find(pos)) {
                    String lang = m.group(3).toLowerCase();
                    if (lang.isEmpty()) {
                        pos = m.end();
                        continue;
                    }
                    String name = m.group(1).toLowerCase();
                    if ((name.equalsIgnoreCase("language") || name.startsWith("target")) && list.isEmpty()) {
                        trgValue = lang;
                        pos = m.end();
                        continue;
                    }
                    if (!list.contains(lang)) {
                        list.add(lang);
                    }
                    if (trgValue != null) {
                        list.add(trgValue);
                        trgValue = null;
                    }
                    pos = m.end();
                }
                if (scanned > 10240) return list;
            } while (list.size() <= 1);
            return list;
        }
        catch (Throwable e) {
            new RuntimeException("Error while trying to guess language information.\n" + e.getLocalizedMessage());
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

