/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.FileCompare;

public class ZipFileCompare {
    private FileCompare fc = new FileCompare();

    public boolean compareFiles(String type, String out, String gold, String encoding, boolean ignoreEmtpyLines) {
        ZipEntry ze;
        ZipFile goldZipFile;
        ZipFile outZipFile;
        Enumeration<? extends ZipEntry> outEntries = null;
        Enumeration<? extends ZipEntry> goldEntries = null;
        HashMap<String, ZipEntry> outZipMap = new HashMap<String, ZipEntry>();
        HashMap<String, ZipEntry> goldZipMap = new HashMap<String, ZipEntry>();
        try {
            File outZip = new File(out);
            outZipFile = new ZipFile(outZip);
            outEntries = outZipFile.entries();
        }
        catch (Exception e) {
            System.err.println("ZipCompare:  Output file " + out + " not found.\n");
            return false;
        }
        try {
            File goldZip = new File(gold);
            goldZipFile = new ZipFile(goldZip);
            goldEntries = goldZipFile.entries();
        }
        catch (Exception e) {
            System.err.println("ZipCompare:  Gold file " + gold + " not found.\n");
            return false;
        }
        while (outEntries.hasMoreElements()) {
            ze = outEntries.nextElement();
            outZipMap.put(ze.getName(), ze);
        }
        while (goldEntries.hasMoreElements()) {
            ze = goldEntries.nextElement();
            goldZipMap.put(ze.getName(), ze);
        }
        if (outZipMap.keySet().size() != goldZipMap.keySet().size()) {
            System.err.println("Difference in number of files:");
            System.err.println(" out: " + outZipMap.keySet().size());
            System.err.println("gold: " + goldZipMap.keySet().size() + "\n");
            return false;
        }
        if (!((Object)outZipMap.keySet()).equals(goldZipMap.keySet())) {
            System.err.println("Filenames do not match between the zipfiles\n");
            return false;
        }
        boolean failure = false;
        int identicals = 0;
        try {
            for (String filename : outZipMap.keySet()) {
                ZipEntry oze = (ZipEntry)outZipMap.get(filename);
                ZipEntry gze = (ZipEntry)goldZipMap.get(filename);
                System.out.println("Comparing file: " + filename);
                InputStream ois = outZipFile.getInputStream(oze);
                InputStream gis = goldZipFile.getInputStream(gze);
                boolean same = type.equals("PerLine") ? this.fc.compareFilesPerLines(ois, gis, "UTF-8") : (type.equals("PerLineIgnoreEmpty") ? this.fc.compareFilesPerLines(ois, gis, "UTF-8", ignoreEmtpyLines) : this.fc.filesExactlyTheSame(ois, gis));
                if (same) {
                    ++identicals;
                    continue;
                }
                System.err.println("Output and Gold Entry " + filename + " differ\n");
                if (failure) continue;
                failure = true;
            }
        }
        catch (Exception e) {
            System.err.println("Error opening/reading file\n");
            return false;
        }
        if (!failure) {
            System.out.println("\nAll " + identicals + " pass comparison.\n");
            return true;
        }
        return false;
    }

    public boolean compareFilesPerLines(String out, String gold, String encoding) {
        return this.compareFiles("PerLine", out, gold, encoding, false);
    }

    public boolean compareFilesPerLines(String out, String gold, String encoding, boolean ignoreEmtpyLines) {
        return this.compareFiles("PerLineIgnoreEmpty", out, gold, encoding, ignoreEmtpyLines);
    }

    public boolean filesExactlyTheSame(String out, String gold) {
        return this.compareFiles("ExactlyTheSame", out, gold, null, false);
    }
}

