/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.filterwriter.TMXContent;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TMXContentTest {
    private TMXContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new TMXContent();
    }

    @Test
    public void testSimple_Default() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        Assert.assertEquals((Object)"t1<bpt i=\"1\">&lt;b1&gt;</bpt><bpt i=\"2\">&lt;b2&gt;</bpt><ph x=\"3\">{\\x1\\}</ph>t2<ept i=\"2\">&lt;/b2&gt;</ept><ept i=\"1\">&lt;/b1&gt;</ept>t3", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testSimple_OmegaT() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setLetterCodedMode(true);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<bpt i=\"1\">&lt;g0&gt;</bpt><bpt i=\"2\">&lt;g1&gt;</bpt><ph x=\"3\">&lt;x2/&gt;</ph>t2<ept i=\"2\">&lt;/g1&gt;</ept><ept i=\"1\">&lt;/g0&gt;</ept>t3", (Object)this.fmt.toString());
    }

    @Test
    public void testSimple_OmegaTUsingCodeMode() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setCodeMode(3);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<bpt i=\"1\">&lt;g0&gt;</bpt><bpt i=\"2\">&lt;g1&gt;</bpt><ph x=\"3\">&lt;x2/&gt;</ph>t2<ept i=\"2\">&lt;/g1&gt;</ept><ept i=\"1\">&lt;/g0&gt;</ept>t3", (Object)this.fmt.toString());
    }

    @Test
    public void testSimple_EmptyCodes() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setCodeMode(1);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<bpt i=\"1\"></bpt><bpt i=\"2\"></bpt><ph x=\"3\"></ph>t2<ept i=\"2\"></ept><ept i=\"1\"></ept>t3", (Object)this.fmt.toString());
    }

    @Test
    public void testSimple_GenericCodes() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setCodeMode(2);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<bpt i=\"1\">&lt;0&gt;</bpt><bpt i=\"2\">&lt;1&gt;</bpt><ph x=\"3\">&lt;2/&gt;</ph>t2<ept i=\"2\">&lt;/1&gt;</ept><ept i=\"1\">&lt;/0&gt;</ept>t3", (Object)this.fmt.toString());
    }

    @Test
    public void testSimple_OriginalCodes() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setCodeMode(0);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<bpt i=\"1\">&lt;b1&gt;</bpt><bpt i=\"2\">&lt;b2&gt;</bpt><ph x=\"3\">{\\x1\\}</ph>t2<ept i=\"2\">&lt;/b2&gt;</ept><ept i=\"1\">&lt;/b1&gt;</ept>t3", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testSimple_Trados() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setTradosWorkarounds(true);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<bpt i=\"1\">&lt;b1&gt;</bpt><bpt i=\"2\">&lt;b2&gt;</bpt><ut>{\\cs6\\f1\\cf6\\lang1024 </ut>{\\x1\\}<ut>}</ut>t2<ept i=\"2\">&lt;/b2&gt;</ept><ept i=\"1\">&lt;/b1&gt;</ept>t3", (Object)this.fmt.toString());
    }

    private TextFragment createTextUnit() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "{\\x1\\}");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t3");
        return tf;
    }
}

