/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.observer.BaseObservable;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.PipelineReturnValue;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.RawDocument;

public class Pipeline
implements IPipeline,
IObservable,
IObserver {
    public static final String DEFAULT_ID = "DEFAULT ID";
    private LinkedList<IPipelineStep> steps;
    private LinkedList<IPipelineStep> finishedSteps;
    private volatile PipelineReturnValue state;
    private String id = "DEFAULT ID";
    private boolean notifiedObserver;
    private IObservable delegatedObservable = new BaseObservable(this);

    public Pipeline() {
        this.steps = new LinkedList();
        this.finishedSteps = new LinkedList();
        this.state = PipelineReturnValue.PAUSED;
    }

    private void initialize() {
        for (IPipelineStep step : this.finishedSteps) {
            this.steps.add(step);
        }
        this.finishedSteps.clear();
    }

    @Override
    public void startBatch() {
        this.state = PipelineReturnValue.RUNNING;
        this.initialize();
        Event event = new Event(EventType.START_BATCH);
        for (IPipelineStep step : this.steps) {
            step.handleEvent(event);
        }
        this.notifyObservers(event);
    }

    @Override
    public void endBatch() {
        Event event = Event.END_BATCH_EVENT;
        for (IPipelineStep step : this.finishedSteps) {
            step.handleEvent(Event.END_BATCH_EVENT);
        }
        this.notifyObservers(event);
        this.state = PipelineReturnValue.SUCCEDED;
    }

    @Override
    public void addStep(IPipelineStep step) {
        this.steps.add(step);
    }

    @Override
    public List<IPipelineStep> getSteps() {
        return new LinkedList<IPipelineStep>(this.steps);
    }

    @Override
    public void cancel() {
        this.state = PipelineReturnValue.CANCELLED;
    }

    private Event execute(Event event) {
        this.notifiedObserver = false;
        this.state = PipelineReturnValue.RUNNING;
        while (!this.steps.isEmpty() && this.state != PipelineReturnValue.CANCELLED) {
            do {
                this.notifiedObserver = false;
                for (IPipelineStep step : this.steps) {
                    event = step.handleEvent(event);
                    event = this.expandEvent(event, step);
                }
                if (!this.notifiedObserver && !event.isNoop()) {
                    this.notifyObservers(event);
                }
                if (this.steps.getFirst().isDone()) continue;
                event = Event.NOOP_EVENT;
            } while (!this.steps.getFirst().isDone() && this.state != PipelineReturnValue.CANCELLED);
            try {
                while (this.steps.getFirst().isDone()) {
                    this.finishedSteps.add(this.steps.remove());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        return event;
    }

    private Event expandEvent(Event event, IPipelineStep currentStep) {
        if (event.getEventType() == EventType.MULTI_EVENT && !((MultiEvent)event.getResource()).isPropagateAsSingleEvent()) {
            List remainingSteps = this.steps.subList(this.steps.indexOf(currentStep) + 1, this.steps.size());
            Iterator<Event> i$ = ((MultiEvent)event.getResource()).iterator();
            while (i$.hasNext()) {
                Event me;
                event = me = i$.next();
                for (IPipelineStep remainingStep : remainingSteps) {
                    event = remainingStep.handleEvent(event);
                    event = this.expandEvent(event, remainingStep);
                }
                if (event.isNoop()) continue;
                this.notifyObservers(event);
                this.notifiedObserver = true;
            }
        }
        return event;
    }

    @Override
    public PipelineReturnValue getState() {
        return this.state;
    }

    @Override
    public void process(RawDocument input) {
        this.process(new Event(EventType.RAW_DOCUMENT, input));
    }

    @Override
    public void process(Event input) {
        this.state = PipelineReturnValue.RUNNING;
        this.initialize();
        Event e = new Event(EventType.START_BATCH_ITEM);
        for (IPipelineStep step : this.steps) {
            step.handleEvent(e);
        }
        this.notifyObservers(e);
        if (input.getEventType() == EventType.MULTI_EVENT && !((MultiEvent)input.getResource()).isPropagateAsSingleEvent()) {
            for (Event me : (MultiEvent)input.getResource()) {
                this.execute(me);
                for (IPipelineStep step : this.steps) {
                    this.finishedSteps.add(step);
                }
                this.steps.clear();
                this.initialize();
            }
        } else {
            this.execute(input);
        }
        for (IPipelineStep step : this.steps) {
            this.finishedSteps.add(step);
        }
        this.steps.clear();
        e = new Event(EventType.END_BATCH_ITEM);
        for (IPipelineStep step : this.finishedSteps) {
            step.handleEvent(e);
        }
        this.notifyObservers(e);
    }

    @Override
    public void destroy() {
        for (IPipelineStep step : this.finishedSteps) {
            step.destroy();
        }
        this.state = PipelineReturnValue.DESTROYED;
    }

    @Override
    public void clearSteps() {
        this.destroy();
        this.steps.clear();
        this.finishedSteps.clear();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void update(IObservable o, Object arg) {
        this.notifyObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<IObserver> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

