/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Collections;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class Segment
extends TextPart {
    public static final String REF_MARKER = "$segment$";
    protected Annotations annotations;
    public String id;

    public Segment() {
        super(new TextFragment());
    }

    public Segment(String id) {
        super(new TextFragment());
        this.id = id;
    }

    public Segment(String id, TextFragment text) {
        super(text);
        this.id = id;
    }

    @Override
    public Segment clone() {
        Segment newSeg = new Segment(this.id, this.text.clone());
        if (this.annotations != null) {
            newSeg.annotations = this.annotations.clone();
        }
        return newSeg;
    }

    @Override
    public boolean isSegment() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    public Iterable<IAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    public static String makeRefMarker(String segId) {
        return TextFragment.makeRefMarker(segId, REF_MARKER);
    }
}

