/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.AlignedSegments;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IVariantSources;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.VariantSources;

public class TextUnit
implements ITextUnit {
    private static final int TARGETS_INITCAP = 2;
    private String id;
    private int refCount;
    private String name;
    private String type;
    private boolean isTranslatable = true;
    private boolean preserveWS;
    private ISkeleton skeleton;
    private LinkedHashMap<String, Property> properties;
    private Annotations annotations;
    private String mimeType;
    private TextContainer defaultSource;
    private VariantSources variantSources;
    private ConcurrentHashMap<LocaleId, TextContainer> targets;
    private AlignedSegments myAlignedSegments;

    public TextUnit(String id) {
        this.create(id, null, false, null);
    }

    public TextUnit(String id, String sourceText) {
        this.create(id, sourceText, false, null);
    }

    public TextUnit(String id, String sourceText, boolean isReferent) {
        this.create(id, sourceText, isReferent, null);
    }

    public TextUnit(String id, String sourceText, boolean isReferent, String mimeType) {
        this.create(id, sourceText, isReferent, mimeType);
    }

    private void create(String id, String sourceText, boolean isReferent, String mimeType) {
        this.targets = new ConcurrentHashMap(2);
        this.id = id;
        this.refCount = isReferent ? 1 : 0;
        this.mimeType = mimeType;
        this.setDefaultSource(new TextContainer(sourceText));
    }

    @Override
    public boolean isEmpty() {
        return this.getSource().isEmpty();
    }

    @Override
    public TextContainer getSource() {
        return this.defaultSource;
    }

    private TextContainer getSource(LocaleId targetLocale) {
        if (this.variantSources == null || targetLocale == null) {
            return this.defaultSource;
        }
        return this.variantSources.get(targetLocale);
    }

    @Override
    public TextContainer setSource(TextContainer textContainer) {
        this.setDefaultSource(textContainer);
        return this.defaultSource;
    }

    @Override
    public boolean hasVariantSources() {
        return this.variantSources == null ? false : !this.variantSources.isEmpty();
    }

    @Override
    public IVariantSources getVariantSources() {
        if (this.variantSources == null) {
            this.variantSources = new VariantSources(this.defaultSource);
        }
        return this.variantSources;
    }

    @Override
    public TextFragment setSourceContent(TextFragment content) {
        this.getSource().setContent(content);
        return this.getSource().getFirstContent();
    }

    @Override
    public TextContainer createTarget(LocaleId targetLocale, boolean overwriteExisting, int creationOptions) {
        TextContainer trgCont = this.targets.get(targetLocale);
        if (trgCont == null || overwriteExisting) {
            trgCont = this.getSource(targetLocale).clone((creationOptions & 2) == 2);
            if ((creationOptions & 4) != 4) {
                trgCont.joinAll();
            }
            if ((creationOptions & 1) != 1) {
                for (Segment seg : trgCont.getSegments()) {
                    seg.text.clear();
                }
            }
            this.targets.put(targetLocale, trgCont);
        }
        return trgCont;
    }

    @Override
    public TextContainer getTarget(LocaleId locId) {
        return this.targets.get(locId);
    }

    @Override
    public TextContainer setTarget(LocaleId locId, TextContainer text) {
        this.targets.put(locId, text);
        return text;
    }

    @Override
    public void removeTarget(LocaleId locId) {
        if (this.hasTarget(locId)) {
            this.targets.remove(locId);
        }
    }

    @Override
    public boolean hasTarget(LocaleId locId) {
        return this.targets.containsKey(locId);
    }

    @Override
    public TextFragment setTargetContent(LocaleId locId, TextFragment content) {
        TextContainer tc = this.createTarget(locId, false, 0);
        tc.setContent(content);
        return tc.getSegments().getFirstContent();
    }

    @Override
    public IAlignedSegments getAlignedSegments() {
        return this.getMyAlignedSegments();
    }

    private AlignedSegments getMyAlignedSegments() {
        if (this.myAlignedSegments == null) {
            this.myAlignedSegments = new AlignedSegments(this);
        }
        return this.myAlignedSegments;
    }

    @Override
    public ISegments getSourceSegments() {
        return this.getSource().getSegments();
    }

    @Override
    public Segment getSourceSegment(String segId, boolean createIfNeeded) {
        Segment seg = this.getSource().getSegments().get(segId);
        if (seg == null && createIfNeeded) {
            seg = new Segment(segId);
            this.getSource().getSegments().append(seg);
        }
        return seg;
    }

    @Override
    public ISegments getTargetSegments(LocaleId trgLoc) {
        return this.createTarget(trgLoc, false, 4).getSegments();
    }

    @Override
    public Segment getTargetSegment(LocaleId trgLoc, String segId, boolean createIfNeeded) {
        Segment seg = this.createTarget(trgLoc, false, 4).getSegments().get(segId);
        if (seg == null && createIfNeeded) {
            seg = new Segment(segId);
            this.getTarget(trgLoc).getSegments().append(seg);
        }
        return seg;
    }

    @Override
    public Set<LocaleId> getTargetLocales() {
        return this.targets.keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String value) {
        this.type = value;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    @Override
    public void setIsTranslatable(boolean value) {
        this.isTranslatable = value;
    }

    @Override
    public boolean preserveWhitespaces() {
        return this.preserveWS;
    }

    @Override
    public void setPreserveWhitespaces(boolean value) {
        this.preserveWS = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public ISkeleton getSkeleton() {
        return this.skeleton;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        this.skeleton = skeleton;
    }

    @Override
    public boolean isReferent() {
        return this.refCount > 0;
    }

    @Override
    public void setIsReferent(boolean value) {
        this.refCount = value ? 1 : 0;
    }

    @Override
    public int getReferenceCount() {
        return this.refCount;
    }

    @Override
    public void setReferenceCount(int value) {
        this.refCount = value;
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties.keySet();
    }

    @Override
    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public Property setProperty(Property property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(property.getName(), property);
        return property;
    }

    @Override
    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public Iterable<IAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    @Override
    public Property getSourceProperty(String name) {
        return this.getSource().getProperty(name);
    }

    @Override
    public Property setSourceProperty(Property property) {
        return this.getSource().setProperty(property);
    }

    @Override
    public void removeSourceProperty(String name) {
        this.getSource().removeProperty(name);
    }

    @Override
    public Set<String> getSourcePropertyNames() {
        return this.getSource().getPropertyNames();
    }

    @Override
    public boolean hasSourceProperty(String name) {
        return this.getSource().hasProperty(name);
    }

    @Override
    public Property getTargetProperty(LocaleId locId, String name) {
        if (!this.hasTarget(locId)) {
            return null;
        }
        return this.getTarget(locId).getProperty(name);
    }

    @Override
    public Property setTargetProperty(LocaleId locId, Property property) {
        return this.createTarget(locId, false, 4).setProperty(property);
    }

    @Override
    public void removeTargetProperty(LocaleId locId, String name) {
        if (this.hasTarget(locId)) {
            this.getTarget(locId).removeProperty(name);
        }
    }

    @Override
    public Set<String> getTargetPropertyNames(LocaleId locId) {
        if (this.hasTarget(locId)) {
            return this.getTarget(locId).getPropertyNames();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasTargetProperty(LocaleId locId, String name) {
        TextContainer tc = this.getTarget(locId);
        if (tc == null) {
            return false;
        }
        return tc.getProperty(name) != null;
    }

    @Override
    public Property createTargetProperty(LocaleId locId, String name, boolean overwriteExisting, int creationOptions) {
        TextContainer tc = this.createTarget(locId, false, 0);
        Property prop = tc.getProperty(name);
        if (prop == null || overwriteExisting) {
            prop = this.getSource(locId).getProperty(name);
            if (prop == null) {
                return tc.setProperty(new Property(name, "", false));
            }
            if (creationOptions == 0) {
                return tc.setProperty(new Property(name, "", prop.isReadOnly()));
            }
            return tc.setProperty(prop.clone());
        }
        return prop;
    }

    public String toString() {
        return this.getSource().toString();
    }

    @Override
    public TextUnit clone() {
        TextUnit tu = new TextUnit(this.getId());
        if (this.annotations != null) {
            tu.setAnnotations(this.annotations.clone());
        }
        tu.setIsReferent(this.isReferent());
        tu.setIsTranslatable(this.isTranslatable);
        tu.setMimeType(this.getMimeType());
        tu.setName(this.getName());
        tu.setPreserveWhitespaces(this.preserveWS);
        tu.setReferenceCount(this.getReferenceCount());
        tu.setSkeleton(this.getSkeleton());
        tu.setSource(this.getSource().clone());
        tu.setType(this.getType());
        if (this.hasVariantSources()) {
            tu.variantSources = this.variantSources.clone();
            tu.variantSources.setDefaultSource(tu.getSource());
        }
        if (this.properties != null) {
            for (Property property : this.properties.values()) {
                tu.setProperty(property.clone());
            }
        }
        for (Map.Entry entry : this.targets.entrySet()) {
            tu.setTarget((LocaleId)entry.getKey(), ((TextContainer)entry.getValue()).clone());
        }
        return tu;
    }

    @Override
    public void removeAllSegmentations() {
        if (this.getSource().hasBeenSegmented()) {
            this.getSource().joinAll();
        }
        for (Map.Entry<LocaleId, TextContainer> entry : this.targets.entrySet()) {
            if (!entry.getValue().hasBeenSegmented()) continue;
            entry.getValue().joinAll();
        }
        if (this.hasVariantSources()) {
            Set<LocaleId> set = this.getVariantSources().getLocales();
            for (LocaleId loc : set) {
                this.getVariantSources().remove(loc);
            }
        }
    }

    @Override
    public void createSourceSegmentation(ISegmenter segmenter) {
        segmenter.computeSegments(this.getSource());
        this.getSource().getSegments().create(segmenter.getRanges());
    }

    @Override
    public void createTargetSegmentation(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer tc = this.getTarget(targetLocale);
        if (tc == null) {
            throw new RuntimeException(String.format("There is no target content for '%s'", targetLocale.toString()));
        }
        segmenter.computeSegments(tc);
        tc.getSegments().create(segmenter.getRanges());
    }

    protected void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    private void setDefaultSource(TextContainer newDefaultSource) {
        this.defaultSource = newDefaultSource;
        if (this.variantSources != null) {
            this.variantSources.setDefaultSource(this.defaultSource);
        }
    }
}

