/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.SkeletonUtil;

public class TextUnitUtil {
    private static final Logger LOGGER = Logger.getLogger(TextUnitUtil.class.getName());
    private static final String SEG_START = "$seg_start$";
    private static final String SEG_END = "$seg_end$";
    private static final String TP_START = "$tp_start$";
    private static final String TP_END = "$tp_end$";
    private static final Pattern SEG_REGEX = Pattern.compile("\\[#\\$(.+?)\\@\\%\\$seg_start\\$\\](.*?)\\[#\\$(\\1)\\@\\%\\$seg_end\\$\\]");
    private static final Pattern SEG_START_REGEX = Pattern.compile("\\[#\\$(.+?)\\@\\%\\$seg_start\\$\\]");
    private static final Pattern SEG_END_REGEX = Pattern.compile("\\[#\\$(.+?)\\@\\%\\$seg_end\\$\\]");
    private static final Pattern TP_REGEX = Pattern.compile("\\$tp_start\\$(.*?)\\$tp_end\\$");
    private static final Pattern TP_START_REGEX = Pattern.compile("\\$tp_start\\$");
    private static final Pattern TP_END_REGEX = Pattern.compile("\\$tp_end\\$");
    private static final Pattern ANY_SEG_TP_REGEX = Pattern.compile("\\[#\\$(.+?)\\@\\%\\$seg_start\\$\\]|\\[#\\$(.+?)\\@\\%\\$seg_end\\$\\]|\\$tp_start\\$|\\$tp_end\\$");
    private static final char FOO = '\u0001';
    private static final Pattern PLAIN_TEXT_REGEX = Pattern.compile(String.format("[^%s]+", Character.valueOf('\u0001')));
    private static String testMarkersSt;

    public static void trimLeading(TextFragment textFragment) {
        TextUnitUtil.trimLeading(textFragment, null);
    }

    public static TextFragment adjustTargetCodes(TextFragment oriSrc, TextFragment newTrg, boolean alwaysCopyCodes, boolean addMissingCodes, TextFragment newSrc, ITextUnit parent) {
        int i;
        List<Code> newCodes = newTrg.getCodes();
        List<Code> oriCodes = oriSrc.getCodes();
        boolean needAdjustment = false;
        if (!alwaysCopyCodes) {
            for (Code code : newCodes) {
                if (code.hasData()) continue;
                needAdjustment = true;
                break;
            }
            if (!needAdjustment) {
                for (Code code : oriCodes) {
                    if (!code.hasReference()) continue;
                    needAdjustment = true;
                    break;
                }
            }
            if (!needAdjustment) {
                return newTrg;
            }
        }
        if (!newTrg.hasCode() && !oriSrc.hasCode()) {
            return newTrg;
        }
        if (newSrc != null && !needAdjustment && oriCodes.toString().equals(newSrc.getCodes().toString())) {
            return newTrg;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i2 = 0; i2 < oriIndices.length; ++i2) {
            oriIndices[i2] = i2;
        }
        int done = 0;
        for (i = 0; i < newCodes.size(); ++i) {
            Code newCode = newCodes.get(i);
            newCode.setOuterData(null);
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriCodes.get(j).getId() != newCode.getId() || oriCodes.get(j).getTagType() != newCode.getTagType()) continue;
                if (oriIndices[j] == -1 && !oriCodes.get(j).isCloneable()) {
                    String place = null;
                    if (parent != null) {
                        place = String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                    }
                    LOGGER.warning(String.format("The extra code id='%d' cannot be cloned.", newCode.getId()) + (place == null ? "" : place));
                }
                oriCode = oriCodes.get(j);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (newCode.getData() != null && newCode.getData().length() != 0) continue;
                String place = null;
                if (parent != null) {
                    place = String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                }
                LOGGER.warning(String.format("The extra target code id='%d' does not have corresponding data.", newCode.getId()) + (place == null ? "" : place));
                continue;
            }
            newCode.setData(oriCode.getData());
            newCode.setOuterData(oriCode.getOuterData());
            newCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            for (i = 0; i < oriIndices.length; ++i) {
                if (oriIndices[i] == -1) continue;
                Code code = oriCodes.get(oriIndices[i]);
                if (!addMissingCodes) continue;
                newTrg.append(code.clone());
            }
        }
        return newTrg;
    }

    public static void trimLeading(TextFragment textFragment, GenericSkeleton skel) {
        TextFragment skelTF;
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfFirstNonWhitespace(st, 0, -1, false, false, false, true);
        if (pos == -1) {
            skelTF = new TextFragment(st);
            textFragment.setCodedText("");
        } else {
            skelTF = textFragment.subSequence(0, pos);
            textFragment.setCodedText(st.substring(pos));
        }
        if (skel == null) {
            return;
        }
        if (skelTF == null) {
            return;
        }
        st = skelTF.toText();
        if (!Util.isEmpty(st)) {
            skel.append(st);
        }
    }

    public static void trimTrailing(TextFragment textFragment) {
        TextUnitUtil.trimTrailing(textFragment, null);
    }

    public static void trimTrailing(TextFragment textFragment, GenericSkeleton skel) {
        TextFragment skelTF;
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, false, false, false, true);
        if (pos == -1) {
            skelTF = new TextFragment(st);
            textFragment.setCodedText("");
        } else {
            skelTF = textFragment.subSequence(pos + 1, st.length());
            textFragment.setCodedText(st.substring(0, pos + 1));
        }
        if (skel == null) {
            return;
        }
        if (skelTF == null) {
            return;
        }
        st = skelTF.toText();
        if (!Util.isEmpty(st)) {
            skel.append(st);
        }
    }

    public static boolean endsWith(TextFragment textFragment, String substr) {
        if (textFragment == null) {
            return false;
        }
        if (Util.isEmpty(substr)) {
            return false;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return false;
        }
        return st.lastIndexOf(substr) == pos - substr.length() + 1;
    }

    public static boolean isEmpty(ITextUnit textUnit) {
        return textUnit == null || textUnit.getSource().isEmpty();
    }

    public static boolean hasSource(ITextUnit textUnit) {
        return !TextUnitUtil.isEmpty(textUnit, true);
    }

    public static boolean isEmpty(ITextUnit textUnit, boolean ignoreWS) {
        return textUnit == null || Util.isEmpty(TextUnitUtil.getSourceText(textUnit), ignoreWS);
    }

    public static String getSourceText(ITextUnit textUnit) {
        return textUnit.getSource().getFirstContent().getCodedText();
    }

    public static String getSourceText(ITextUnit textUnit, boolean removeCodes) {
        if (textUnit == null) {
            return "";
        }
        if (removeCodes) {
            return TextUnitUtil.getText(textUnit.getSource().getFirstContent());
        }
        return textUnit.getSource().getFirstContent().getCodedText();
    }

    public static String getTargetText(ITextUnit textUnit, LocaleId locId) {
        if (textUnit == null) {
            return "";
        }
        if (Util.isNullOrEmpty(locId)) {
            return "";
        }
        return TextUnitUtil.getCodedText(textUnit.getTarget(locId).getFirstContent());
    }

    public static String getCodedText(TextFragment textFragment) {
        if (textFragment == null) {
            return "";
        }
        return textFragment.getCodedText();
    }

    public static String getText(TextFragment textFragment, List<Integer> markerPositions) {
        if (textFragment == null) {
            return "";
        }
        String res = textFragment.getCodedText();
        if (markerPositions != null) {
            markerPositions.clear();
        }
        if (!textFragment.hasCode()) {
            return res;
        }
        StringBuilder sb = new StringBuilder();
        int startPos = -1;
        block3: for (int i = 0; i < res.length(); ++i) {
            switch (res.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    if (markerPositions != null) {
                        markerPositions.add(i);
                    }
                    if (i > startPos && startPos >= 0) {
                        sb.append(res.substring(startPos, i));
                    }
                    ++i;
                    startPos = -1;
                    continue block3;
                }
                default: {
                    if (startPos >= 0) continue block3;
                    startPos = i;
                }
            }
        }
        if (startPos < 0 && sb.length() == 0) {
            startPos = 0;
        } else if (startPos > -1 && startPos < res.length()) {
            sb.append(res.substring(startPos));
        }
        return sb.toString();
    }

    public static String getText(TextFragment textFragment) {
        return TextUnitUtil.getText(textFragment, null);
    }

    public static char getLastChar(TextFragment textFragment) {
        if (textFragment == null) {
            return '\u0000';
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return '\u0000';
        }
        return st.charAt(pos);
    }

    public static void deleteLastChar(TextFragment textFragment) {
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return;
        }
        textFragment.remove(pos, pos + 1);
    }

    public static int lastIndexOf(TextFragment textFragment, String findWhat) {
        if (textFragment == null) {
            return -1;
        }
        if (Util.isEmpty(findWhat)) {
            return -1;
        }
        if (Util.isEmpty(textFragment.getCodedText())) {
            return -1;
        }
        return textFragment.getCodedText().lastIndexOf(findWhat);
    }

    public static boolean isEmpty(TextFragment textFragment) {
        return textFragment == null || textFragment != null && textFragment.isEmpty();
    }

    public static ITextUnit buildTU(TextContainer source) {
        return TextUnitUtil.buildTU(null, "", source, null, LocaleId.EMPTY, "");
    }

    public static ITextUnit buildTU(String source) {
        return TextUnitUtil.buildTU(new TextContainer(source));
    }

    public static ITextUnit buildTU(String srcPart, String skelPart) {
        ITextUnit res = TextUnitUtil.buildTU(srcPart);
        if (res == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)res.getSkeleton();
        if (skel == null) {
            return null;
        }
        skel.addContentPlaceholder(res);
        skel.append(skelPart);
        return res;
    }

    public static ITextUnit buildTU(ITextUnit textUnit, String name, TextContainer source, TextContainer target, LocaleId locId, String comment) {
        if (textUnit == null) {
            textUnit = new TextUnit("");
        }
        if (textUnit.getSkeleton() == null) {
            GenericSkeleton skel = new GenericSkeleton();
            textUnit.setSkeleton(skel);
        }
        if (!Util.isEmpty(name)) {
            textUnit.setName(name);
        }
        if (source != null) {
            textUnit.setSource(source);
        }
        if (target != null && !Util.isNullOrEmpty(locId)) {
            textUnit.setTarget(locId, target);
        }
        if (!Util.isEmpty(comment)) {
            textUnit.setProperty(new Property("note", comment));
        }
        return textUnit;
    }

    public static GenericSkeleton forceSkeleton(ITextUnit tu) {
        if (tu == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tu.setSkeleton(skel);
        }
        if (!SkeletonUtil.hasTuRef(skel)) {
            skel.addContentPlaceholder(tu);
        }
        return skel;
    }

    public static GenericSkeleton convertToSkeleton(ITextUnit textUnit) {
        if (textUnit == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)textUnit.getSkeleton();
        if (skel == null) {
            return new GenericSkeleton(textUnit.toString());
        }
        List<GenericSkeletonPart> list = skel.getParts();
        if (list.size() == 0) {
            return new GenericSkeleton(textUnit.toString());
        }
        String tuRef = TextFragment.makeRefMarker("$self$");
        GenericSkeleton res = new GenericSkeleton();
        List<GenericSkeletonPart> list2 = res.getParts();
        for (GenericSkeletonPart part : list) {
            String st = part.toString();
            if (Util.isEmpty(st)) continue;
            if (st.equalsIgnoreCase(tuRef)) {
                LocaleId locId = part.getLocale();
                if (Util.isNullOrEmpty(locId)) {
                    res.add(TextUnitUtil.getSourceText(textUnit));
                    continue;
                }
                res.add(TextUnitUtil.getTargetText(textUnit, locId));
                continue;
            }
            list2.add(part);
        }
        return res;
    }

    public static <A extends IAnnotation> A getSourceAnnotation(ITextUnit textUnit, Class<A> type) {
        if (textUnit == null) {
            return null;
        }
        if (textUnit.getSource() == null) {
            return null;
        }
        return textUnit.getSource().getAnnotation(type);
    }

    public static void setSourceAnnotation(ITextUnit textUnit, IAnnotation annotation) {
        if (textUnit == null) {
            return;
        }
        if (textUnit.getSource() == null) {
            return;
        }
        textUnit.getSource().setAnnotation(annotation);
    }

    public static <A extends IAnnotation> A getTargetAnnotation(ITextUnit textUnit, LocaleId locId, Class<A> type) {
        if (textUnit == null) {
            return null;
        }
        if (Util.isNullOrEmpty(locId)) {
            return null;
        }
        if (textUnit.getTarget(locId) == null) {
            return null;
        }
        return textUnit.getTarget(locId).getAnnotation(type);
    }

    public static void setTargetAnnotation(ITextUnit textUnit, LocaleId locId, IAnnotation annotation) {
        if (textUnit == null) {
            return;
        }
        if (Util.isNullOrEmpty(locId)) {
            return;
        }
        if (textUnit.getTarget(locId) == null) {
            return;
        }
        textUnit.getTarget(locId).setAnnotation(annotation);
    }

    public static void setSourceText(ITextUnit textUnit, String text) {
        TextFragment source = textUnit.getSource().getFirstContent();
        source.setCodedText(text);
    }

    public static void setTargetText(ITextUnit textUnit, LocaleId locId, String text) {
        TextFragment target = textUnit.getTarget(locId).getFirstContent();
        target.setCodedText(text);
    }

    public static void trimTU(ITextUnit textUnit, boolean trimLeading, boolean trimTrailing) {
        int index;
        if (textUnit == null) {
            return;
        }
        if (!trimLeading && !trimTrailing) {
            return;
        }
        TextContainer source = textUnit.getSource();
        GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
        GenericSkeleton skel = new GenericSkeleton();
        if (trimLeading) {
            TextUnitUtil.trimLeading(source.getFirstContent(), skel);
        }
        skel.addContentPlaceholder(textUnit);
        if (trimTrailing) {
            TextUnitUtil.trimTrailing(source.getFirstContent(), skel);
        }
        if ((index = SkeletonUtil.findTuRefInSkeleton(tuSkel)) != -1) {
            SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
        } else {
            tuSkel.add(skel);
        }
    }

    public static void removeQualifiers(ITextUnit textUnit, String startQualifier, String endQualifier) {
        if (textUnit == null) {
            return;
        }
        if (Util.isEmpty(startQualifier)) {
            return;
        }
        if (Util.isEmpty(endQualifier)) {
            return;
        }
        String st = TextUnitUtil.getSourceText(textUnit);
        if (st == null) {
            return;
        }
        int startQualifierLen = startQualifier.length();
        int endQualifierLen = endQualifier.length();
        if (st.startsWith(startQualifier) && st.endsWith(endQualifier)) {
            GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
            GenericSkeleton skel = new GenericSkeleton();
            skel.add(startQualifier);
            skel.addContentPlaceholder(textUnit);
            skel.add(endQualifier);
            TextUnitUtil.setSourceText(textUnit, st.substring(startQualifierLen, Util.getLength(st) - endQualifierLen));
            int index = SkeletonUtil.findTuRefInSkeleton(tuSkel);
            if (index != -1) {
                SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
            } else {
                tuSkel.add(skel);
            }
        }
    }

    public static void simplifyCodes(ITextUnit textUnit, boolean removeLeadingTrailingCodes) {
        if (textUnit == null) {
            LOGGER.warning("Text unit is null.");
            return;
        }
        if (textUnit.getTargetLocales().size() > 0) {
            LOGGER.warning(String.format("Text unit %s has one or more targets, desinchronization of codes in source and targets is possible.", textUnit.getId()));
        }
        TextContainer tc = textUnit.getSource();
        String[] res = null;
        if (textUnit.getSource().hasBeenSegmented()) {
            res = TextUnitUtil.simplifyCodes(tc, removeLeadingTrailingCodes);
        } else {
            TextFragment tf = tc.getUnSegmentedContentCopy();
            res = TextUnitUtil.simplifyCodes(tf, removeLeadingTrailingCodes);
            textUnit.setSourceContent(tf);
        }
        if (removeLeadingTrailingCodes && res != null) {
            GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
            GenericSkeleton skel = new GenericSkeleton();
            skel.add(res[0]);
            skel.addContentPlaceholder(textUnit);
            skel.add(res[1]);
            int index = SkeletonUtil.findTuRefInSkeleton(tuSkel);
            if (index != -1) {
                SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
            } else {
                tuSkel.add(skel);
            }
        }
    }

    public static String[] simplifyCodes(TextFragment tf, boolean removeLeadingTrailingCodes) {
        CodeSimplifier simplifier = new CodeSimplifier();
        return simplifier.simplifyAll(tf, removeLeadingTrailingCodes);
    }

    public static String[] simplifyCodes(TextContainer tc, boolean removeLeadingTrailingCodes) {
        CodeSimplifier simplifier = new CodeSimplifier();
        String[] res = simplifier.simplifyAll(tc, removeLeadingTrailingCodes);
        TextUnitUtil.trimSegments(tc);
        return res;
    }

    public static void removeQualifiers(ITextUnit textUnit, String qualifier) {
        TextUnitUtil.removeQualifiers(textUnit, qualifier, qualifier);
    }

    public static AltTranslationsAnnotation addAltTranslation(TextContainer targetContainer, AltTranslation alt) {
        AltTranslationsAnnotation altTrans = targetContainer.getAnnotation(AltTranslationsAnnotation.class);
        if (altTrans == null) {
            altTrans = new AltTranslationsAnnotation();
            targetContainer.setAnnotation(altTrans);
        }
        altTrans.add(alt);
        return altTrans;
    }

    public static AltTranslationsAnnotation addAltTranslation(Segment seg, AltTranslation alt) {
        AltTranslationsAnnotation altTrans = seg.getAnnotation(AltTranslationsAnnotation.class);
        if (altTrans == null) {
            altTrans = new AltTranslationsAnnotation();
            seg.setAnnotation(altTrans);
        }
        altTrans.add(alt);
        return altTrans;
    }

    public static TextFragment storeSegmentation(TextContainer tc) {
        TextFragment tf = new TextFragment();
        for (TextPart part : tc) {
            Segment seg = null;
            if (part.isSegment()) {
                seg = (Segment)part;
                tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "seg", TextFragment.makeRefMarker(seg.getId(), SEG_START)));
            } else {
                tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_START));
            }
            tf.append(part.getContent());
            if (part.isSegment()) {
                tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "seg", TextFragment.makeRefMarker(seg.getId(), SEG_END)));
                continue;
            }
            tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_END));
        }
        return tf;
    }

    public static void trimSegments(TextContainer tc, boolean trimLeading, boolean trimTrailing) {
        if (!trimLeading && !trimTrailing) {
            return;
        }
        for (int index = 0; index < tc.count(); ++index) {
            TextPart part = tc.get(index);
            if (!part.isSegment()) continue;
            TextFragment tf = part.getContent();
            if (trimLeading) {
                GenericSkeleton skel1 = new GenericSkeleton();
                TextUnitUtil.trimLeading(tf, skel1);
                if (!skel1.isEmpty()) {
                    tc.insert(index, new TextPart(skel1.toString()));
                    ++index;
                }
            }
            if (!trimTrailing) continue;
            GenericSkeleton skel2 = new GenericSkeleton();
            TextUnitUtil.trimTrailing(tf, skel2);
            if (skel2.isEmpty()) continue;
            tc.insert(index + 1, new TextPart(skel2.toString()));
            ++index;
        }
    }

    public static void trimSegments(TextContainer tc) {
        TextUnitUtil.trimSegments(tc, true, true);
    }

    public static String extractSegMarkers(TextFragment tf, String original, boolean removeFromOriginal) {
        if (tf == null) {
            LOGGER.warning("Text fragment is null, no codes are added");
        }
        if (original == null) {
            LOGGER.warning("Original string is null, no processing was performed");
            return "";
        }
        Matcher matcher = ANY_SEG_TP_REGEX.matcher(original);
        while (tf != null && matcher.find()) {
            tf.append(new Code(TextFragment.TagType.PLACEHOLDER, null, matcher.group()));
        }
        return removeFromOriginal ? matcher.replaceAll("") : original;
    }

    public static String restoreSegmentation(TextContainer tc, TextFragment segStorage) {
        tc.clear();
        TextFragment tf = segStorage;
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < ctext.length(); ++i) {
            if (!TextFragment.isMarker(ctext.charAt(i))) continue;
            int codeIndex = TextFragment.toIndex(ctext.charAt(i + 1));
            Code code = codes.get(codeIndex);
            String data = code.getData();
            ArrayList<Token> tokens = new ArrayList<Token>();
            Matcher matcher = SEG_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.SEG, new Range(matcher.start(), matcher.end()), new Range(matcher.start(2), matcher.end(2)), matcher.group(1), matcher.group()));
            }
            matcher = TP_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP, new Range(matcher.start(), matcher.end()), new Range(matcher.start(1), matcher.end(1)), null, matcher.group()));
            }
            for (Token token : tokens) {
                data = StringUtil.padString(data, token.range.start, token.range.end, '\u0001');
            }
            matcher = SEG_START_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.SEG_START, new Range(matcher.start(), matcher.end()), null, matcher.group(1), matcher.group()));
            }
            matcher = SEG_END_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.SEG_END, new Range(matcher.start(), matcher.end()), null, matcher.group(1), matcher.group()));
            }
            matcher = TP_START_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP_START, new Range(matcher.start(), matcher.end()), null, null, matcher.group()));
            }
            matcher = TP_END_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP_END, new Range(matcher.start(), matcher.end()), null, null, matcher.group()));
            }
            if (tokens.size() == 0) {
                ++i;
                continue;
            }
            for (Token token : tokens) {
                data = StringUtil.padString(data, token.range.start, token.range.end, '\u0001');
            }
            matcher = PLAIN_TEXT_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP, new Range(matcher.start(), matcher.end()), new Range(matcher.start(), matcher.end()), null, matcher.group()));
            }
            Collections.sort(tokens, new Comparator<Token>(){

                @Override
                public int compare(Token t1, Token t2) {
                    if (t1.type == TokenType.SEG_END && t2.type == TokenType.TP) {
                        return -1;
                    }
                    if (t1.type == TokenType.SEG_START && t2.type == TokenType.TP) {
                        return 1;
                    }
                    if (t1.textRange.start < t2.textRange.start) {
                        return -1;
                    }
                    if (t1.textRange.start > t2.textRange.start) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (Token token : tokens) {
                switch (token.type) {
                    case SEG: {
                        markers.add(new Marker(MarkerType.M_SEG_START, token.id, i, token.textRange.start, code));
                        markers.add(new Marker(MarkerType.M_SEG_END, token.id, i, token.textRange.end, code));
                        break;
                    }
                    case TP: {
                        markers.add(new Marker(MarkerType.M_TP_START, i, token.textRange.start, code));
                        markers.add(new Marker(MarkerType.M_TP_END, i, token.textRange.end, code));
                        break;
                    }
                    case SEG_START: {
                        markers.add(new Marker(MarkerType.M_SEG_START, token.id, i + 2, 0, null));
                        break;
                    }
                    case SEG_END: {
                        markers.add(new Marker(MarkerType.M_SEG_END, token.id, i, 0, null));
                        break;
                    }
                    case TP_START: {
                        markers.add(new Marker(MarkerType.M_TP_START, i + 2, 0, null));
                        break;
                    }
                    case TP_END: {
                        markers.add(new Marker(MarkerType.M_TP_END, i, 0, null));
                    }
                }
            }
            ++i;
        }
        Collections.sort(markers, new Comparator<Marker>(){

            @Override
            public int compare(Marker m1, Marker m2) {
                if (m1.position < m2.position) {
                    return -1;
                }
                if (m1.position > m2.position) {
                    return 1;
                }
                if (m1.context != null && m2.context != null) {
                    if (m1.relPos < m2.relPos) {
                        return -1;
                    }
                    if (m1.relPos > m2.relPos) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        StringBuilder markersSb = new StringBuilder();
        ArrayList<TextPart> list = new ArrayList<TextPart>();
        int start = -1;
        for (Marker d : markers) {
            switch (d.type) {
                case M_SEG_START: {
                    int n = start = d.context == null ? d.position : d.relPos;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s %s) ", d.position, "seg_start", d.id));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s %s) ", d.position, d.relPos, "seg_start", d.id));
                    break;
                }
                case M_SEG_END: {
                    if (start > -1) {
                        if (d.context == null) {
                            if (start <= d.position) {
                                list.add(new Segment(d.id, tf.subSequence(start, d.position)));
                            } else {
                                LOGGER.warning(String.format("Cannot create the segment %s - incorrect range: (%d - %d)", d.id, start, d.position));
                            }
                        } else if (start <= d.relPos) {
                            list.add(new Segment(d.id, new TextFragment(d.context.getData().substring(start, d.relPos))));
                        } else {
                            LOGGER.warning(String.format("Cannot create the segment %s - incorrect range: (%d - %d)", d.id, start, d.relPos));
                        }
                    }
                    start = -1;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s %s) ", d.position, "seg_end", d.id));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s %s) ", d.position, d.relPos, "seg_end", d.id));
                    break;
                }
                case M_TP_START: {
                    int n = start = d.context == null ? d.position : d.relPos;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s) ", d.position, "tp_start"));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s) ", d.position, d.relPos, "tp_start"));
                    break;
                }
                case M_TP_END: {
                    if (start > -1) {
                        if (d.context == null) {
                            if (start <= d.position) {
                                list.add(new TextPart(tf.subSequence(start, d.position)));
                            } else {
                                LOGGER.warning(String.format("Cannot create a text part - incorrect range: (%d - %d)", start, d.position));
                            }
                        } else if (start <= d.relPos) {
                            list.add(new TextPart(new TextFragment(d.context.getData().substring(start, d.relPos))));
                        } else {
                            LOGGER.warning(String.format("Cannot create a text part - incorrect range: (%d - %d)", start, d.relPos));
                        }
                    }
                    start = -1;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s) ", d.position, "tp_end"));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s) ", d.position, d.relPos, "tp_end"));
                }
            }
        }
        testMarkersSt = markersSb.toString().trim();
        TextUnitUtil.setParts(tc, list.toArray(new TextPart[list.size()]));
        return testMarkersSt;
    }

    public static String testMarkers() {
        return testMarkersSt;
    }

    private static void setParts(TextContainer tc, TextPart ... parts) {
        tc.clear();
        for (TextPart part : parts) {
            TextUnitUtil.append(tc, part);
        }
        if (tc.get(0).isSegment() != parts[0].isSegment()) {
            tc.changePart(0);
        }
    }

    private static void append(TextContainer tc, TextPart part) {
        tc.append(part, tc.isEmpty());
    }

    public static String toText(TextFragment tf) {
        List<Code> codes = tf.getCodes();
        String text = tf.getCodedText();
        if (codes == null || codes.size() == 0) {
            return text.toString();
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(String.format("[%s]", code.data));
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static String toText(String text, List<Code> codes) {
        if (codes == null || codes.size() == 0) {
            return text.toString();
        }
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    int index = TextFragment.toIndex(text.charAt(++i));
                    try {
                        Code code = codes.get(index);
                        tmp.append(String.format("[%s]", code.data));
                    }
                    catch (Exception e) {
                        tmp.append(String.format("[-ERR:UNKNOWN-CODE- %d]", index));
                    }
                    continue block5;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    private static final class Token {
        TokenType type;
        String id;
        Range range;
        Range textRange;

        private Token(TokenType type, Range range, Range textRange, String id, String match) {
            this.type = type;
            this.range = range;
            this.textRange = textRange == null ? range : textRange;
            this.id = id;
        }
    }

    private static enum TokenType {
        SEG,
        TP,
        SEG_START,
        SEG_END,
        TP_START,
        TP_END;

    }

    private static final class Marker {
        private MarkerType type;
        private String id;
        private int position;
        private int relPos;
        private Code context;

        private Marker(MarkerType type, int position, int relPos, Code context) {
            this(type, null, position, relPos, context);
        }

        private Marker(MarkerType type, String id, int position, int relPos, Code context) {
            this.type = type;
            this.id = id;
            this.position = position;
            this.relPos = relPos;
            this.context = context;
        }
    }

    private static enum MarkerType {
        M_SEG_START,
        M_SEG_END,
        M_TP_START,
        M_TP_END;

    }
}

