/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;

public class GenericSkeleton
implements ISkeleton {
    private ArrayList<GenericSkeletonPart> list = new ArrayList();
    private boolean createNew = true;

    public GenericSkeleton() {
    }

    public GenericSkeleton(String data) {
        if (data != null) {
            this.add(data);
        }
    }

    public GenericSkeleton(GenericSkeleton skel) {
        if (skel != null) {
            for (GenericSkeletonPart part : skel.list) {
                this.list.add(part);
            }
        }
    }

    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    public boolean isEmpty(boolean ignoreWhitespaces) {
        if (ignoreWhitespaces) {
            for (GenericSkeletonPart part : this.list) {
                for (int i = 0; i < part.data.length(); ++i) {
                    if (Character.isWhitespace(part.data.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return this.list.size() == 0;
    }

    public void add(String data) {
        if (Util.isEmpty(data)) {
            return;
        }
        GenericSkeletonPart part = new GenericSkeletonPart(data);
        this.list.add(part);
        this.createNew = false;
    }

    public void flushPart() {
        this.createNew = true;
    }

    public void add(char data) {
        GenericSkeletonPart part = new GenericSkeletonPart(data);
        this.list.add(part);
        this.createNew = false;
    }

    public void add(GenericSkeleton skel) {
        if (skel != null) {
            for (GenericSkeletonPart part : skel.list) {
                this.list.add(part);
            }
        }
    }

    public void appendToFirstPart(String data) {
        if (data.length() == 0) {
            return;
        }
        if (this.list.isEmpty()) {
            this.add(data);
        } else {
            this.list.get(0).append(data);
        }
    }

    public void append(String data) {
        if (data.length() == 0) {
            return;
        }
        if (this.createNew || this.list.isEmpty()) {
            this.add(data);
        } else {
            this.list.get(this.list.size() - 1).append(data);
        }
    }

    public void append(char data) {
        if (this.createNew || this.list.isEmpty()) {
            this.add(data);
        } else {
            this.list.get((int)(this.list.size() - 1)).data.append(data);
        }
    }

    public void addContentPlaceholder(ITextUnit textUnit) {
        GenericSkeletonPart part = new GenericSkeletonPart(TextFragment.makeRefMarker("$self$"));
        part.parent = textUnit;
        part.locId = null;
        this.list.add(part);
        this.createNew = true;
    }

    public void addContentPlaceholder(ITextUnit textUnit, LocaleId locId) {
        GenericSkeletonPart part = new GenericSkeletonPart(TextFragment.makeRefMarker("$self$"));
        part.parent = textUnit;
        part.locId = locId;
        this.list.add(part);
        this.createNew = true;
    }

    public void addValuePlaceholder(INameable referent, String propName, LocaleId locId) {
        GenericSkeletonPart part = new GenericSkeletonPart(TextFragment.makeRefMarker("$self$", propName));
        part.locId = locId;
        part.parent = referent;
        this.list.add(part);
        this.createNew = true;
    }

    public void changeSelfReferents(INameable newReferent) {
        String start = "[#$$self$";
        for (GenericSkeletonPart part : this.list) {
            if (part.data == null || !part.data.toString().startsWith(start)) continue;
            part.parent = newReferent;
        }
    }

    public void addReference(IReferenceable referent) {
        GenericSkeletonPart part = new GenericSkeletonPart(TextFragment.makeRefMarker(((IResource)((Object)referent)).getId()));
        part.locId = null;
        part.parent = null;
        this.list.add(part);
        this.createNew = true;
    }

    public void attachParent(INameable parent) {
        if (this.createNew || this.list.isEmpty()) {
            GenericSkeletonPart part = new GenericSkeletonPart("");
            this.list.add(part);
            this.createNew = false;
        }
        this.list.get((int)(this.list.size() - 1)).parent = parent;
    }

    public List<GenericSkeletonPart> getParts() {
        return this.list;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (GenericSkeletonPart part : this.list) {
            b.append(part.toString());
        }
        return b.toString();
    }

    public GenericSkeletonPart getLastPart() {
        if (this.list.size() == 0) {
            return null;
        }
        return this.list.get(this.list.size() - 1);
    }
}

