/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String APPID = "appId";
    private String appId;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.appId = this.buffer.getEncodedString(APPID, this.appId);
    }

    @Override
    public void reset() {
        this.appId = "";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setEncodedString(APPID, this.appId);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(APPID, "Microsoft Bing AppID (See http://www.bing.com/developers/appids.aspx)", "The AppID to identify the application/user");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft MT Connector Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(APPID));
        tip.setPassword(true);
        return desc;
    }
}

