/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.pensieve;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.pensieve.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.TmSeekerFactory;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;

public class PensieveTMConnector
extends BaseConnector
implements ITMQuery {
    private int maxHits = 25;
    private int threshold = 95;
    private List<QueryResult> results;
    private int current = -1;
    private Parameters params = new Parameters();
    private ITmSeeker seeker;
    private Metadata attrs = new Metadata();
    private String rootDir;
    private JSONParser parser;
    private String basePart;
    private String origin;

    @Override
    public String getName() {
        return "Pensieve TM";
    }

    @Override
    public String getSettingsDisplay() {
        if (this.params.getUseServer()) {
            return "Server: " + (Util.isEmpty(this.params.getHost()) ? "<To be specified>" : this.params.getHost());
        }
        return "Database: " + (Util.isEmpty(this.params.getDbDirectory()) ? "<To be specified>" : this.params.getDbDirectory());
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max < 1 ? 1 : max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void close() {
        if (this.seeker != null) {
            this.seeker.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
        if (this.params.getUseServer()) {
            this.parser = new JSONParser();
            this.origin = null;
        } else {
            if (this.seeker != null) {
                this.seeker.close();
            }
            this.origin = Util.fillRootDirectoryVariable(this.params.getDbDirectory(), this.rootDir);
            this.seeker = TmSeekerFactory.createFileBasedTmSeeker(this.origin);
            this.origin = Util.getFilename(this.origin, true);
        }
    }

    @Override
    public int query(String plainText) {
        this.results = new ArrayList<QueryResult>();
        this.current = -1;
        if (this.params.getUseServer()) {
            return this.queryServer(new TextFragment(plainText));
        }
        return this.queryDirectory(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment text) {
        this.results = new ArrayList<QueryResult>();
        this.current = -1;
        if (this.params.getUseServer()) {
            return this.queryServer(text);
        }
        return this.queryDirectory(text);
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    private int queryDirectory(TextFragment text) {
        List<TmHit> list = this.threshold >= 100 ? this.seeker.searchExact(text, this.attrs) : this.seeker.searchFuzzy(text, this.threshold, this.maxHits, this.attrs);
        for (TmHit hit : list) {
            Float f = Float.valueOf(hit.getScore());
            QueryResult qr = new QueryResult();
            qr.weight = this.getWeight();
            qr.score = f.intValue();
            qr.source = hit.getTu().getSource().getContent();
            qr.target = hit.getTu().getTarget().getContent();
            qr.matchType = hit.getMatchType();
            qr.origin = this.origin;
            this.results.add(qr);
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    private int queryServer(TextFragment fragment) {
        try {
            JSONArray array;
            if (!fragment.hasText(false)) {
                return 0;
            }
            String qtext = fragment.toText();
            URL url = new URL(this.basePart + String.format("?q=%s", URLEncoder.encode(qtext, "UTF-8")));
            URLConnection conn = url.openConnection();
            JSONArray list = array = (JSONArray)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            for (Map map : list) {
                QueryResult result = new QueryResult();
                result.weight = this.getWeight();
                result.source = new TextFragment((String)map.get("source"));
                result.target = new TextFragment((String)map.get("target"));
                result.score = ((Double)map.get("score")).intValue();
                result.origin = this.origin;
                this.results.add(result);
            }
            if (!Util.isEmpty(list)) {
                this.current = 0;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server." + e.getMessage(), e);
        }
        return this.current == 0 ? this.results.size() : 0;
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("resname".equals(name)) {
            this.attrs.put(MetadataType.ID, value);
        } else if ("restype".equals(name)) {
            this.attrs.put(MetadataType.TYPE, value);
        } else if ("GroupName".equals(name)) {
            this.attrs.put(MetadataType.GROUP_NAME, value);
        } else if ("FileName".equals(name)) {
            this.attrs.put(MetadataType.FILE_NAME, value);
        }
    }

    @Override
    public void clearAttributes() {
        this.attrs.clear();
    }

    @Override
    public void removeAttribute(String name) {
        if ("resname".equals(name)) {
            this.attrs.remove((Object)MetadataType.ID);
        } else if ("restype".equals(name)) {
            this.attrs.remove((Object)MetadataType.TYPE);
        } else if ("GroupName".equals(name)) {
            this.attrs.remove((Object)MetadataType.GROUP_NAME);
        } else if ("FileName".equals(name)) {
            this.attrs.remove((Object)MetadataType.FILE_NAME);
        }
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        if (this.params.getUseServer()) {
            String host = this.params.getHost();
            if (host.endsWith("/") || host.endsWith("\\")) {
                host = host.substring(0, host.length() - 1);
            }
            this.basePart = String.format("%s/search/%s/%s/", host, this.srcLoc.toBCP47(), this.trgLoc.toBCP47());
            this.origin = host;
        }
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }
}

