/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.promt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.promt.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProMTConnector
extends BaseConnector
implements IQuery {
    private static final String PTS8_SERVICE = "pts8/services/ptservice.asmx/";
    private static final String GETPTSERVICEDATASET = "GetPTServiceDataSet";
    private static final String PTSXLIFF_SERVICE = "ptsxliff/PTSXLIFFTranslator.asmx/";
    private static final String TRANSLATEFORMATTEDTEXT = "TranslateFormattedText";
    private static final Pattern RESULTPATTERN = Pattern.compile("<string(.*?)>(.*?)</string>");
    private Locale srcJavaLoc;
    private Locale trgJavaLoc;
    private QueryResult result;
    private int current = -1;
    private Parameters params = new Parameters();
    private URL serviceURL;
    private String dirId;
    private HashMap<String, String> dirIdentifiers;
    private QueryUtil qutil = new QueryUtil();
    private DocumentBuilder docBuilder;

    public ProMTConnector() {
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        try {
            this.docBuilder = Fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating document builder.", e);
        }
    }

    @Override
    public String getName() {
        return "ProMT";
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("Server: %s", this.params.getHost());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.current > -1) {
            this.current = -1;
            return this.result;
        }
        return null;
    }

    private String getHost() {
        String tmp = !Util.isEmpty(this.params.getUsername()) ? "http://" + this.params.getHost() : "http://" + this.params.getHost();
        if (!tmp.endsWith("/") && tmp.endsWith("\\")) {
            return tmp + "/";
        }
        return tmp;
    }

    @Override
    public void open() {
        if (!Util.isEmpty(this.params.getUsername())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ProMTConnector.this.params.getUsername(), ProMTConnector.this.params.getPassword().toCharArray());
                }
            });
        }
        this.initializePairsFromServer();
        try {
            this.serviceURL = new URL(this.getHost() + PTSXLIFF_SERVICE + TRANSLATEFORMATTEDTEXT);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Cannot open the connection to '%s'", this.getHost() + PTSXLIFF_SERVICE), e);
        }
    }

    @Override
    public int query(String text) {
        if (Util.isEmpty(text)) {
            return 0;
        }
        return this.queryUsingPOST(null, text);
    }

    @Override
    public int query(TextFragment frag) {
        if (!frag.hasText(false)) {
            return 0;
        }
        return this.queryUsingPOST(frag, null);
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    private int queryUsingPOST(TextFragment frag, String plainText) {
        this.current = -1;
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        String text = frag != null ? this.qutil.toXLIFF(frag) : plainText;
        if (this.dirId == null) {
            return 0;
        }
        try {
            String buffer;
            URLConnection conn = this.serviceURL.openConnection();
            String data = String.format("DirId=%s&TplId=%s&strText=%s&FileType=text/xliff", this.dirId, "General", URLEncoder.encode(text, "UTF-8"));
            conn.setDoOutput(true);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            StringBuilder tmp = new StringBuilder();
            while ((buffer = rd.readLine()) != null) {
                tmp.append(buffer);
            }
            Matcher m = RESULTPATTERN.matcher(tmp.toString());
            if (m.find() && !Util.isEmpty(buffer = m.group(2))) {
                this.result = new QueryResult();
                this.result.weight = this.getWeight();
                if (frag != null) {
                    this.result.source = frag;
                    this.result.target = this.qutil.fromXLIFF(this.prepareXLIFF(buffer), frag);
                } else {
                    this.result.source = new TextFragment(text);
                    this.result.target = this.qutil.fromXLIFF(this.prepareXLIFF(buffer), frag);
                }
                this.result.score = 95;
                this.result.origin = this.getName();
                this.result.matchType = MatchType.MT;
                this.current = 0;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error during the query.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error during the query.", e);
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {}
        }
        return this.current + 1;
    }

    private Element prepareXLIFF(String data) {
        try {
            data = data.replace("&apos;", "'");
            data = data.replace("&lt;", "<");
            data = data.replace("&gt;", ">");
            data = data.replace("&quot;", "\"");
            data = data.replace("&amp;", "&");
            Document doc = this.docBuilder.parse(new InputSource(new StringReader("<s>" + data + "</s>")));
            return doc.getDocumentElement();
        }
        catch (SAXException e) {
            throw new RuntimeException("Error when parsing result.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when parsing result.", e);
        }
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    private void setDirectionId() {
        this.dirId = null;
        if (this.dirIdentifiers == null) {
            return;
        }
        if (this.srcJavaLoc != null && this.trgJavaLoc != null) {
            String pair = this.srcJavaLoc.getDisplayLanguage(Locale.ENGLISH) + "-" + this.trgJavaLoc.getDisplayLanguage(Locale.ENGLISH);
            this.dirId = this.dirIdentifiers.get(pair);
        }
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        this.srcJavaLoc = sourceLocale.toJavaLocale();
        this.trgJavaLoc = targetLocale.toJavaLocale();
        this.setDirectionId();
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        return locale.getLanguage();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        params = (Parameters)params;
    }

    private void initializePairsFromServer() {
        this.dirId = null;
        this.dirIdentifiers = new HashMap();
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String buffer;
            URL url = new URL(this.getHost() + PTS8_SERVICE + GETPTSERVICEDATASET);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write("");
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            StringBuilder tmp = new StringBuilder();
            while ((buffer = rd.readLine()) != null) {
                tmp.append(buffer);
            }
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            Fact.setNamespaceAware(true);
            DocumentBuilder docBuilder = Fact.newDocumentBuilder();
            docBuilder.setEntityResolver(new DefaultEntityResolver());
            Document doc = docBuilder.parse(new InputSource(new StringReader(tmp.toString())));
            NodeList nodes = doc.getElementsByTagName("Directions");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem = (Element)nodes.item(i);
                NodeList dirs = elem.getChildNodes();
                String name = null;
                String id = null;
                for (int j = 0; j < dirs.getLength(); ++j) {
                    Node node = dirs.item(j);
                    if ("id".equals(node.getLocalName())) {
                        id = Util.getTextContent(node);
                        continue;
                    }
                    if (!"Name".equals(node.getLocalName())) continue;
                    name = Util.getTextContent(node);
                }
                if (Util.isEmpty(id) || Util.isEmpty(name)) continue;
                this.dirIdentifiers.put(name, id);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error during the initialization.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error during the initialization.", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error during the initialization.", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error during the initialization.", e);
        }
        finally {
            this.setDirectionId();
            try {
                if (wr != null) {
                    wr.close();
                }
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }
}

