/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup;

import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;

public class AbstractMarkupEventBuilder
extends EventBuilder {
    private static final String WHITESPACE_REGEX = "[ \t\r\n\f\u200b]+";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \t\r\n\f\u200b]+");
    private boolean useCodeFinder = false;
    private InlineCodeFinder codeFinder = new InlineCodeFinder();

    public AbstractMarkupEventBuilder(String rootId, boolean subFilter) {
        super(rootId, subFilter);
    }

    public void initializeCodeFinder(boolean useCodeFinder, String rules) {
        this.useCodeFinder = useCodeFinder;
        if (useCodeFinder) {
            this.codeFinder.fromString(rules);
            this.codeFinder.compile();
        }
    }

    @Override
    protected ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        TextFragment text = textUnit.getSource().getFirstContent();
        text.setCodedText(this.normalizeHtmlText(text.getCodedText(), false, textUnit.preserveWhitespaces()));
        if (this.useCodeFinder) {
            this.codeFinder.process(text);
            List<Code> codes = text.getCodes();
            for (Code code : codes) {
                if (!code.getType().equals("regxph")) continue;
                code.setData(Util.escapeToXML(code.getData(), 0, false, null));
            }
        }
        return textUnit;
    }

    public String normalizeHtmlText(String text, boolean insideAttribute, boolean preserveWhitespace) {
        String decodedValue = text;
        if (!preserveWhitespace) {
            decodedValue = this.collapseWhitespace(decodedValue);
            decodedValue = decodedValue.trim();
        }
        decodedValue = Util.normalizeNewlines(decodedValue);
        return decodedValue;
    }

    private String collapseWhitespace(String text) {
        return WHITESPACE_PATTERN.matcher(text).replaceAll(" ");
    }
}

