/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.LinkedHashMap;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UnicodeBOMWriter;
import net.sf.okapi.common.resource.RawDocument;

class StreamedSourceCopy {
    StreamedSourceCopy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawDocument htmlTidiedRewrite(RawDocument input, boolean documentEncoding, String encoding, boolean hasBOM) throws IOException {
        LocaleId locale = input.getSourceLocale();
        URI tempUri = File.createTempFile("_modifiedHtml", ".sourceTemp").toURI();
        Writer writer = null;
        try {
            if (input.getEncoding() == "null") {
                input.setEncoding(encoding);
            }
            StreamedSource streamedSource = new StreamedSource(input.getReader());
            writer = hasBOM ? new UnicodeBOMWriter(new FileOutputStream(new File(tempUri.getPath())), encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(new File(tempUri.getPath())), encoding);
            int lastSegmentEnd = 0;
            for (Segment segment : streamedSource) {
                Tag tag;
                if (segment.getEnd() <= lastSegmentEnd) continue;
                lastSegmentEnd = segment.getEnd();
                if (segment instanceof Tag && (tag = (Tag)segment) instanceof StartTag) {
                    StartTag st = (StartTag)tag;
                    if (StreamedSourceCopy.tagHasUnquotedAttribute(st)) {
                        LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
                        writer.write(StartTag.generateHTML(st.getName(), st.getAttributes().populateMap(attributesMap, false), st.isSyntacticalEmptyElementTag()));
                        continue;
                    }
                    writer.write(st.toString());
                    continue;
                }
                writer.write(segment.toString());
            }
            RawDocument rawDocument = new RawDocument(tempUri, encoding, locale);
            return rawDocument;
        }
        finally {
            input.close();
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static boolean tagHasUnquotedAttribute(StartTag tag) {
        if (tag.getAttributes() != null && !tag.getAttributes().isEmpty() && tag.getTagType() != StartTagType.XML_DECLARATION && tag.getTagType() != StartTagType.DOCTYPE_DECLARATION && tag.getTagType() != StartTagType.XML_PROCESSING_INSTRUCTION) {
            for (Attribute att : tag.getAttributes()) {
                if (att.getQuoteChar() != ' ') continue;
                return true;
            }
        }
        return false;
    }
}

