/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.php;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.LocalizationDirectives;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.php.Parameters;

@UsingParameters(value=Parameters.class)
public class PHPContentFilter
implements IFilter {
    private static final int STRTYPE_SINGLEQUOTED = 0;
    private static final int STRTYPE_DOUBLEQUOTED = 1;
    private static final int STRTYPE_HEREDOC = 2;
    private static final int STRTYPE_NOWDOC = 3;
    private static final int STRTYPE_MIXED = 4;
    private Parameters params = new Parameters();
    private String lineBreak;
    private String inputText;
    private int tuId;
    private LinkedList<Event> queue;
    private boolean hasNext;
    private int current;
    private int firstSkelStart;
    private int skelStart;
    private int stringStart;
    private int stringEnd;
    private TextFragment srcFrag;
    private ITextUnit textUnit;
    private GenericSkeleton srcSkel;
    private int resType;
    private HTMLCharacterEntities cerList = new HTMLCharacterEntities();
    private EncoderManager encoderManager;
    private LocalizationDirectives locDir = new LocalizationDirectives();

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        this.hasNext = false;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-php", this.getClass().getName(), "PHP Content Default", "Default PHP Content configuration.", null, ".php;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-php", "net.sf.okapi.common.encoder.PHPContentEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getDisplayName() {
        return "PHP Content Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-php";
    }

    @Override
    public String getName() {
        return "okf_phpcontent";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        Event event;
        if (!this.hasNext) {
            return null;
        }
        if (this.queue.size() == 0) {
            this.parse();
        }
        if ((event = this.queue.poll()).getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return event;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.locDir.reset();
        this.locDir.setOptions(this.params.getUseDirectives(), this.params.getExtractOutsideDirectives());
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        String encoding = input.getEncoding();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", encoding), e);
        }
        this.lineBreak = detector.getNewlineType().toString();
        boolean hasUTF8BOM = detector.hasUtf8Bom();
        String docName = null;
        if (input.getInputURI() != null) {
            docName = input.getInputURI().getPath();
        }
        StringBuilder tmp = new StringBuilder();
        char[] buf = new char[2048];
        int count = 0;
        try {
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading the input.", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing the input.", e);
                }
            }
        }
        this.inputText = tmp.toString().replace(this.lineBreak, "\n");
        this.current = -1;
        this.tuId = 0;
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
        }
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument("sd");
        startDoc.setName(docName);
        startDoc.setEncoding(encoding, hasUTF8BOM);
        startDoc.setLocale(input.getSourceLocale());
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterParameters(this.getParameters());
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType("application/x-php");
        startDoc.setMimeType("application/x-php");
        startDoc.setMultilingual(false);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        this.hasNext = true;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void parse() {
        int prevState = 0;
        int state = 0;
        StringBuilder buf = null;
        StringBuilder possibleEndKey = null;
        String endKey = null;
        int blockType = 2;
        char ch = '\u0000';
        char tch = '\u0000';
        this.resetStorage();
        this.skelStart = this.current < 0 ? 0 : this.current;
        this.firstSkelStart = this.skelStart;
        this.stringEnd = -1;
        block30: while (true) {
            if (this.current + 1 >= this.inputText.length()) {
                this.processTextUnit();
                Ending ending = new Ending("ed");
                if (this.skelStart < this.inputText.length()) {
                    GenericSkeleton skl = new GenericSkeleton(this.inputText.substring(this.skelStart).replace("\n", this.lineBreak));
                    ending.setSkeleton(skl);
                }
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                return;
            }
            if (state == 0 && !Character.isWhitespace(ch)) {
                tch = ch;
            }
            ch = this.inputText.charAt(++this.current);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '/': {
                            prevState = state;
                            state = 1;
                            continue block30;
                        }
                        case '\\': {
                            prevState = state;
                            state = 4;
                            continue block30;
                        }
                        case '<': {
                            if (this.inputText.length() <= this.current + 2 || this.inputText.charAt(this.current + 1) != '<' || this.inputText.charAt(this.current + 1) != '<') continue block30;
                            this.current += 2;
                            buf = new StringBuilder();
                            state = 6;
                            continue block30;
                        }
                        case '\'': {
                            prevState = state;
                            state = 9;
                            this.stringStart = this.current;
                            buf = new StringBuilder();
                            continue block30;
                        }
                        case '\"': {
                            prevState = state;
                            state = 10;
                            this.stringStart = this.current;
                            buf = new StringBuilder();
                            continue block30;
                        }
                        case ',': 
                        case ';': 
                        case '=': {
                            if (!this.processTextUnit()) continue block30;
                            return;
                        }
                    }
                    continue block30;
                }
                case 1: {
                    if (ch == '/') {
                        state = 2;
                        buf = new StringBuilder();
                        continue block30;
                    }
                    if (ch == '*') {
                        state = 3;
                        buf = new StringBuilder();
                        continue block30;
                    }
                    state = prevState;
                    --this.current;
                    continue block30;
                }
                case 2: {
                    if (ch == '\n') {
                        this.locDir.process(buf.toString());
                        state = prevState;
                        continue block30;
                    }
                    buf.append(ch);
                    continue block30;
                }
                case 3: {
                    if (ch == '*') {
                        state = 5;
                        continue block30;
                    }
                    buf.append(ch);
                    continue block30;
                }
                case 4: {
                    state = prevState;
                    continue block30;
                }
                case 5: {
                    if (ch == '/') {
                        this.locDir.process(buf.toString());
                        state = prevState;
                        continue block30;
                    }
                    state = 3;
                    buf.append('*');
                    --this.current;
                    continue block30;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        if (buf.toString().startsWith("'")) {
                            blockType = 3;
                            endKey = Util.trimEnd(Util.trimStart(buf.toString(), "'"), "'");
                        } else if (buf.toString().startsWith("\"")) {
                            blockType = 2;
                            endKey = Util.trimEnd(Util.trimStart(buf.toString(), "\""), "\"");
                        } else {
                            blockType = 2;
                            endKey = buf.toString();
                        }
                        state = 7;
                        this.stringStart = this.current;
                        buf = new StringBuilder();
                        continue block30;
                    }
                    buf.append(ch);
                    continue block30;
                }
                case 7: {
                    if (ch == '\n') {
                        this.stringEnd = this.current;
                        possibleEndKey = new StringBuilder();
                        state = 8;
                        continue block30;
                    }
                    buf.append(ch);
                    continue block30;
                }
                case 8: {
                    switch (ch) {
                        case '\n': {
                            if (possibleEndKey.length() > 0) {
                                this.addString(buf, blockType, tch);
                                state = prevState;
                                continue block30;
                            }
                            buf.append("\n");
                            this.stringEnd = this.current;
                            continue block30;
                        }
                        case ';': {
                            if (possibleEndKey.length() <= 0) break;
                            this.addString(buf, blockType, tch);
                            state = prevState;
                            continue block30;
                        }
                    }
                    possibleEndKey.append(ch);
                    if (endKey.startsWith(possibleEndKey.toString())) continue block30;
                    state = 7;
                    buf.append("\n" + possibleEndKey);
                    continue block30;
                }
                case 9: {
                    switch (ch) {
                        case '\'': {
                            this.stringEnd = this.current;
                            this.addString(buf, 0, tch);
                            state = prevState;
                            continue block30;
                        }
                        case '\\': {
                            if (this.inputText.length() > this.current + 1) {
                                buf.append('\\');
                                buf.append(this.inputText.charAt(++this.current));
                                continue block30;
                            }
                            throw new OkapiIllegalFilterOperationException("Unexpected end.");
                        }
                        case '&': {
                            int ucode = this.getEntity();
                            if (ucode == -1) break;
                            buf.append((char)ucode);
                            continue block30;
                        }
                    }
                    buf.append(ch);
                    continue block30;
                }
                case 10: {
                    if (ch == '\"') {
                        this.stringEnd = this.current;
                        this.addString(buf, 1, tch);
                        state = prevState;
                        continue block30;
                    }
                    if (ch == '\\') {
                        if (this.inputText.length() > this.current + 1) {
                            buf.append('\\');
                            buf.append(this.inputText.charAt(++this.current));
                            continue block30;
                        }
                        throw new OkapiIllegalFilterOperationException("Unexpected end.");
                    }
                    buf.append(ch);
                    continue block30;
                }
            }
        }
    }

    private int getEntity() {
        int res;
        int n = this.inputText.indexOf(59, this.current);
        if (n == -1) {
            return -1;
        }
        String tmp = this.inputText.substring(this.current + 1, n);
        if (tmp.length() < 1) {
            return -1;
        }
        if (tmp.charAt(0) == '#') {
            if (tmp.length() < 2) {
                return -1;
            }
            try {
                if (tmp.charAt(1) == 'x') {
                    res = Integer.parseInt(tmp.substring(2), 16);
                }
                res = Integer.parseInt(tmp.substring(1));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        } else {
            if (Character.isWhitespace(tmp.charAt(0))) {
                return -1;
            }
            this.cerList.ensureInitialization(false);
            res = this.cerList.lookupName(tmp);
            if (res == -1) {
                return -1;
            }
        }
        this.current = n;
        return res;
    }

    private void addString(StringBuilder buffer, int type, char lastTokenChar) {
        if (lastTokenChar == '[') {
            return;
        }
        if (buffer.length() == 0) {
            return;
        }
        if (this.stringStart > this.skelStart) {
            if (this.srcFrag.isEmpty()) {
                this.srcSkel.add(this.inputText.substring(this.skelStart, this.stringStart + 1).replace("\n", this.lineBreak));
            } else {
                this.srcFrag.append(TextFragment.TagType.PLACEHOLDER, "code", this.inputText.substring(this.skelStart, this.stringStart + 1).replace("\n", this.lineBreak));
            }
        }
        TextFragment tf = new TextFragment(buffer.toString());
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().process(tf);
        }
        if (!tf.hasText(true) && this.srcFrag.isEmpty()) {
            this.srcSkel.add(this.inputText.substring(this.stringStart, this.stringEnd + 1).replace("\n", this.lineBreak));
        }
        this.srcFrag.append(tf);
        if (this.resType == -1) {
            this.resType = type;
        } else if (this.resType != type) {
            this.resType = 4;
        }
        this.skelStart = this.stringEnd;
    }

    private boolean processTextUnit() {
        boolean extract = this.srcFrag.hasText(false);
        if (extract) {
            if (this.locDir.isWithinScope()) {
                if (!this.locDir.isLocalizable(true)) {
                    extract = false;
                }
            } else if (!this.locDir.localizeOutside()) {
                extract = false;
            }
        }
        if (!extract) {
            this.resetStorage();
            this.skelStart = this.firstSkelStart;
            return false;
        }
        this.textUnit = new TextUnit(String.valueOf(++this.tuId));
        switch (this.resType) {
            case 1: {
                this.textUnit.setType("x-doublequoted");
                break;
            }
            case 0: {
                this.textUnit.setType("x-singlequoted");
                break;
            }
            case 2: {
                this.textUnit.setType("x-heredoc");
                break;
            }
            case 3: {
                this.textUnit.setType("x-nowdoc");
                break;
            }
            case 4: {
                this.textUnit.setType("x-mixed");
                this.textUnit.setProperty(new Property("note", "This entry is a concatenation of different types of strings: beware when moving codes or variables."));
            }
        }
        this.srcSkel.addContentPlaceholder(this.textUnit);
        this.textUnit.setMimeType("application/x-php");
        this.textUnit.getSource().getFirstContent().append(this.srcFrag);
        if (!this.srcSkel.isEmpty()) {
            this.textUnit.setSkeleton(this.srcSkel);
        }
        if (this.skelStart < this.current) {
            this.srcSkel.add(this.inputText.substring(this.skelStart, this.current).replace("\n", this.lineBreak));
        }
        this.queue.add(new Event(EventType.TEXT_UNIT, this.textUnit));
        this.skelStart = this.current;
        return true;
    }

    private void resetStorage() {
        this.resType = -1;
        this.srcFrag = new TextFragment();
        this.srcSkel = new GenericSkeleton();
    }
}

