/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.base;

import java.util.logging.Level;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.SkeletonUtil;
import net.sf.okapi.filters.plaintext.base.Parameters;
import net.sf.okapi.lib.extra.filters.AbstractLineFilter;
import net.sf.okapi.lib.extra.filters.TextProcessingResult;

public class BasePlainTextFilter
extends AbstractLineFilter {
    public static final String FILTER_NAME = "okf_plaintext";
    public static final String FILTER_MIME = "text/plain";
    public static final String FILTER_CONFIG = "okf_plaintext";
    public static final String FILTER_CONFIG_TRIM_TRAIL = "okf_plaintext_trim_trail";
    public static final String FILTER_CONFIG_TRIM_ALL = "okf_plaintext_trim_all";
    private Parameters params;
    private InlineCodeFinder codeFinder = new InlineCodeFinder();

    public BasePlainTextFilter() {
        this.setName("okf_plaintext");
        this.setDisplayName("Plain Text Filter (BETA)");
        this.setMimeType(FILTER_MIME);
        this.setMultilingual(false);
        this.addConfiguration(true, "okf_plaintext", "Plain Text", "Plain text files.", null);
        this.addConfiguration(false, FILTER_CONFIG_TRIM_TRAIL, "Plain Text (Trim Trail)", "Text files; trailing spaces and tabs removed from extracted lines.", "okf_plaintext_trim_trail.fprm");
        this.addConfiguration(false, FILTER_CONFIG_TRIM_ALL, "Plain Text (Trim All)", "Text files; leading and trailing spaces and tabs removed from extracted lines.", "okf_plaintext_trim_all.fprm");
        this.setParameters(new Parameters());
    }

    @Override
    protected void component_init() {
        this.params = this.getParameters(Parameters.class);
        super.component_init();
        if (this.params.useCodeFinder && this.codeFinder != null) {
            this.codeFinder.fromString(this.params.codeFinderRules);
            this.codeFinder.compile();
        }
    }

    protected final TextProcessingResult sendAsSource(ITextUnit textUnit) {
        return this.sendAsSource(textUnit, true);
    }

    protected final TextProcessingResult sendAsSource(ITextUnit textUnit, boolean rejectEmpty) {
        if (textUnit == null) {
            return TextProcessingResult.REJECTED;
        }
        TextUnitUtil.forceSkeleton(textUnit);
        if (!this.processTU(textUnit)) {
            return TextProcessingResult.REJECTED;
        }
        if (rejectEmpty && !TextUnitUtil.hasSource(textUnit)) {
            return TextProcessingResult.REJECTED;
        }
        this.sendEvent(EventType.TEXT_UNIT, textUnit);
        return TextProcessingResult.ACCEPTED;
    }

    protected final TextProcessingResult sendAsSource(TextContainer textContainer) {
        if (textContainer == null) {
            return TextProcessingResult.REJECTED;
        }
        return this.sendAsSource(TextUnitUtil.buildTU(null, "", textContainer, null, LocaleId.EMPTY, ""));
    }

    protected final TextProcessingResult sendAsTarget(ITextUnit target, ITextUnit source, LocaleId language) {
        if (target == null) {
            return TextProcessingResult.REJECTED;
        }
        if (source == null) {
            return TextProcessingResult.REJECTED;
        }
        if (language == null) {
            return TextProcessingResult.REJECTED;
        }
        GenericSkeleton skel = this.getActiveSkeleton();
        if (skel == null) {
            return TextProcessingResult.REJECTED;
        }
        GenericSkeleton targetSkel = TextUnitUtil.forceSkeleton(target);
        if (targetSkel == null) {
            return TextProcessingResult.REJECTED;
        }
        if (!this.processTU(target)) {
            return TextProcessingResult.REJECTED;
        }
        source.setTarget(language, target.getSource());
        int index = SkeletonUtil.findTuRefInSkeleton(targetSkel);
        if (index != -1) {
            GenericSkeleton tempSkel = new GenericSkeleton();
            tempSkel.addContentPlaceholder(source, language);
            SkeletonUtil.replaceSkeletonPart(targetSkel, index, tempSkel);
        }
        skel.add(targetSkel);
        return TextProcessingResult.ACCEPTED;
    }

    protected final TextProcessingResult sendAsSkeleton(ITextUnit textUnit) {
        GenericSkeleton parentSkeleton = this.getActiveSkeleton();
        if (parentSkeleton == null) {
            return TextProcessingResult.REJECTED;
        }
        parentSkeleton.add(TextUnitUtil.convertToSkeleton(textUnit));
        return TextProcessingResult.ACCEPTED;
    }

    protected final TextProcessingResult sendAsSkeleton(GenericSkeleton skelPart) {
        if (skelPart == null) {
            return TextProcessingResult.REJECTED;
        }
        GenericSkeleton activeSkel = this.getActiveSkeleton();
        if (activeSkel == null) {
            return TextProcessingResult.REJECTED;
        }
        activeSkel.add(skelPart);
        return TextProcessingResult.ACCEPTED;
    }

    protected final TextProcessingResult sendAsSkeleton(String skelPart) {
        if (skelPart == null) {
            return TextProcessingResult.REJECTED;
        }
        GenericSkeleton activeSkel = this.getActiveSkeleton();
        if (activeSkel == null) {
            return TextProcessingResult.REJECTED;
        }
        activeSkel.add(skelPart);
        return TextProcessingResult.ACCEPTED;
    }

    protected boolean processTU(ITextUnit textUnit) {
        if (textUnit == null) {
            return false;
        }
        TextContainer source = textUnit.getSource();
        if (source == null) {
            return false;
        }
        if (!this.checkTU(source)) {
            return false;
        }
        if (source.isEmpty()) {
            return false;
        }
        if (this.params.unescapeSource) {
            this._unescape(source.getFirstContent());
        }
        TextUnitUtil.trimTU(textUnit, this.params.trimLeading, this.params.trimTrailing);
        textUnit.setMimeType(this.getMimeType());
        textUnit.setPreserveWhitespaces(this.params.preserveWS);
        if (!this.params.preserveWS) {
            source.unwrap(true, true);
        }
        if (this.params.useCodeFinder && this.codeFinder != null) {
            this.codeFinder.process(source.getFirstContent());
        }
        return true;
    }

    protected boolean checkTU(TextContainer tuSource) {
        return true;
    }

    @Override
    protected TextProcessingResult component_exec(TextContainer lineContainer) {
        return this.sendAsSource(lineContainer);
    }

    private void _unescape(TextFragment textFrag) {
        String INVALID_UESCAPE = "Invalid Unicode escape sequence '%s'";
        if (textFrag == null) {
            return;
        }
        String text = textFrag.getCodedText();
        if (Util.isEmpty(text)) {
            return;
        }
        if (text.indexOf(92) == -1) {
            return;
        }
        StringBuilder tmpText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\\') {
                switch (Util.getCharAt(text, i + 1)) {
                    case 'u': {
                        if (i + 5 < text.length()) {
                            try {
                                int nTmp = Integer.parseInt(text.substring(i + 2, i + 6), 16);
                                tmpText.append((char)nTmp);
                            }
                            catch (Exception e) {
                                this.logMessage(Level.WARNING, String.format("Invalid Unicode escape sequence '%s'", text.substring(i + 2, i + 6)));
                            }
                            i += 5;
                            break;
                        }
                        this.logMessage(Level.WARNING, String.format("Invalid Unicode escape sequence '%s'", text.substring(i + 2)));
                        break;
                    }
                    case '\\': {
                        tmpText.append("\\\\");
                        ++i;
                        break;
                    }
                    case 'n': {
                        tmpText.append("\n");
                        ++i;
                        break;
                    }
                    case 't': {
                        tmpText.append("\t");
                        ++i;
                        break;
                    }
                }
                continue;
            }
            tmpText.append(text.charAt(i));
        }
        textFrag.setCodedText(tmpText.toString());
    }

    @Override
    protected void component_done() {
    }
}

