/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.rainbowkit.IManifestEditor;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.filters.rainbowkit.Parameters;
import net.sf.okapi.filters.rtf.RTFFilter;
import net.sf.okapi.filters.xini.XINIFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.transifex.TransifexClient;

@UsingParameters(value=Parameters.class)
public class RainbowKitFilter
implements IFilter {
    public static final String RAINBOWKIT_MIME_TYPE = "application/x-rainbowkit";
    private static final Logger LOGGER = Logger.getLogger(RainbowKitFilter.class.getName());
    private Parameters params = new Parameters();
    private boolean canceled;
    private boolean hasNext;
    private LinkedList<Event> queue;
    private Manifest manifest;
    private MergingInfo info;
    private Iterator<Integer> iter;
    private IFilter filter;
    private RTFFilter rtfFilter;
    private boolean hasMoreDoc;
    private TransifexClient cli;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
        if (this.rtfFilter != null) {
            this.rtfFilter.close();
            this.rtfFilter = null;
        }
    }

    @Override
    public String getName() {
        return "okf_rainbowkit";
    }

    @Override
    public String getDisplayName() {
        return "Rainbow Translation Kit Filter";
    }

    @Override
    public String getMimeType() {
        return RAINBOWKIT_MIME_TYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), RAINBOWKIT_MIME_TYPE, this.getClass().getName(), "Rainbow Translation Kit", "Configuration for Rainbow translation kit.", null, ".rkm;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.filter != null) {
            return this.filter.getEncoderManager();
        }
        return null;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty()) {
                this.nextEventInDocument(false);
                if (!this.hasMoreDoc) {
                    this.hasNext = false;
                    this.queue.add(Event.NOOP_EVENT);
                }
            }
            return this.queue.poll();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading the package.", e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.canceled = false;
        this.manifest = new Manifest();
        if (input.getInputURI() == null) {
            throw new OkapiIOException("This filter requires URI-based raw documents only.");
        }
        this.manifest.load(new File(input.getInputURI()));
        if (this.params.getOpenManifest()) {
            String className = "net.sf.okapi.filters.rainbowkit.ui.ManifestDialog";
            try {
                IManifestEditor dlg = (IManifestEditor)Class.forName(className).newInstance();
                if (!dlg.edit(null, this.manifest, true)) {
                    this.canceled = true;
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.severe(String.format("Cannot create the editor (%s)\n" + e.getMessage(), className));
            }
        }
        this.hasMoreDoc = true;
        this.queue = new LinkedList();
        this.hasNext = true;
        this.iter = this.manifest.getItems().keySet().iterator();
        this.nextDocument();
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        if (this.filter != null) {
            return this.filter.createSkeletonWriter();
        }
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        if (this.filter != null) {
            return this.filter.createFilterWriter();
        }
        return null;
    }

    private void nextDocument() {
        while (this.iter.hasNext()) {
            int id = this.iter.next();
            this.info = this.manifest.getItem(id);
            if (!this.info.getSelected()) continue;
            this.startDocument();
            return;
        }
        this.hasMoreDoc = false;
    }

    private void startDocument() {
        File file = null;
        String extension = null;
        if (this.info.getExtractionType().equals("xliff")) {
            this.filter = new XLIFFFilter();
            extension = ".xlf";
        } else if (this.info.getExtractionType().equals("omegat")) {
            this.filter = new XLIFFFilter();
            extension = ".xlf";
        } else if (this.info.getExtractionType().equals("po")) {
            this.filter = new POFilter();
            extension = ".po";
        } else {
            if (this.info.getExtractionType().equals("rtf")) {
                this.postprocessRTF(false);
                this.queue.add(Event.NOOP_EVENT);
                return;
            }
            if (this.info.getExtractionType().equals("xliff+rtf")) {
                file = this.postprocessRTF(true);
                this.filter = new XLIFFFilter();
                extension = "";
            } else if (this.info.getExtractionType().equals("transifex")) {
                file = this.downloadFromTransifex(this.info);
                this.filter = new POFilter();
            } else if (this.info.getExtractionType().equals("ontram")) {
                file = new File(this.manifest.getTargetDirectory() + "contents.xini");
                this.filter = new XINIFilter(this.info.getRelativeInputPath());
            } else {
                if (this.info.getExtractionType().equals("none")) {
                    String inputPath = this.manifest.getOriginalDirectory() + this.info.getRelativeInputPath();
                    String outputPath = this.manifest.getMergeDirectory() + this.info.getRelativeInputPath();
                    Util.copyFile(inputPath, outputPath, false);
                    this.queue.add(Event.NOOP_EVENT);
                    return;
                }
                throw new OkapiIOException("Unsupported extraction type: " + this.info.getExtractionType());
            }
        }
        if (file == null) {
            file = new File(this.manifest.getTargetDirectory() + this.info.getRelativeInputPath() + extension);
        }
        RawDocument rd = new RawDocument(file.toURI(), this.info.getInputEncoding(), this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        this.filter.open(rd);
        this.nextEventInDocument(true);
    }

    private void nextEventInDocument(boolean attach) {
        if (this.filter == null) {
            this.nextDocument();
            return;
        }
        if (this.filter.hasNext()) {
            if (attach) {
                Event event = this.filter.next();
                StartDocument sd = event.getStartDocument();
                sd.setAnnotation(this.info);
                sd.setAnnotation(this.manifest);
                this.queue.add(event);
            } else {
                Event e = this.filter.next();
                this.queue.add(e);
            }
        } else {
            this.filter.close();
            this.nextDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File postprocessRTF(boolean forXLIFFRTF) {
        File outputFile = null;
        OutputStreamWriter writer = null;
        try {
            if (this.rtfFilter == null) {
                this.rtfFilter = new RTFFilter();
            }
            String lineBreak = "\r\n";
            File file = new File(this.manifest.getTargetDirectory() + this.info.getRelativeInputPath() + (forXLIFFRTF ? ".xlf" : "") + ".rtf");
            this.rtfFilter.open(new RawDocument(file.toURI(), "windows-1252", this.manifest.getTargetLocale()));
            String outputPath = forXLIFFRTF ? this.manifest.getTargetDirectory() + this.info.getRelativeInputPath() + ".xlf" : this.manifest.getMergeDirectory() + this.info.getRelativeTargetPath();
            outputFile = new File(outputPath);
            Util.createDirectories(outputPath);
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputPath)), this.info.getTargetEncoding());
            Util.writeBOMIfNeeded(writer, false, this.info.getTargetEncoding());
            StringBuilder buf = new StringBuilder();
            while (this.rtfFilter.getTextUntil(buf, -1, 0) == 0) {
                writer.write(buf.toString());
                writer.write(lineBreak);
            }
        }
        catch (Exception e) {
            Throwable e2 = e.getCause();
            LOGGER.severe("RTF Conversion error. " + (e2 != null ? e2.getMessage() : e.getMessage()));
        }
        finally {
            if (this.rtfFilter != null) {
                this.rtfFilter.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.severe("RTF Conversion error when closing file. " + e.getMessage());
                }
            }
        }
        return outputFile;
    }

    private File downloadFromTransifex(MergingInfo info) {
        if (Util.isEmpty(info.getResourceId())) {
            LOGGER.severe(String.format("The file '%s' does not have an associated Transifex resource id.", info.getRelativeInputPath()));
            return null;
        }
        if (this.cli == null) {
            net.sf.okapi.lib.transifex.Parameters prm = new net.sf.okapi.lib.transifex.Parameters();
            prm.fromString(this.manifest.getCreatorParameters());
            this.cli = new TransifexClient(prm.getServer());
            this.cli.setProject(prm.getProjectId());
            this.cli.setCredentials(prm.getUser(), prm.getPassword());
        }
        String outputPath = this.manifest.getTargetDirectory() + info.getRelativeInputPath() + ".po";
        String[] res = this.cli.getResource(info.getResourceId(), this.manifest.getTargetLocale(), outputPath);
        if (res[0] == null) {
            LOGGER.severe("Cannot pull the resource from Transifex.\n" + res[1]);
            return null;
        }
        File file = new File(outputPath);
        return file;
    }
}

