/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tmx;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.filters.tmx.TmxTuv;

class TmxTu {
    GenericSkeleton skelBefore = new GenericSkeleton();
    List<Property> propsBefore = new ArrayList<Property>();
    GenericSkeleton skelAfter = new GenericSkeleton();
    private List<TmxTuv> tuvs = new ArrayList<TmxTuv>();
    TmxTuv curTuv;
    boolean reachedTuvSection;
    String lineBreak;
    LocaleId srcLang;
    LocaleId trgLang;

    public TmxTu(LocaleId srcLang, LocaleId trgLang, String lineBreak) {
        this.srcLang = srcLang;
        this.trgLang = trgLang;
        this.lineBreak = lineBreak;
    }

    TmxTuv addTmxTuv(LocaleId lang, TmxFilter.TuvXmlLang trgType) {
        int counter = this.langCount(lang);
        TmxTuv newTmxTuv = new TmxTuv(lang, trgType, ++counter);
        this.tuvs.add(newTmxTuv);
        this.curTuv = newTmxTuv;
        if (!this.reachedTuvSection) {
            this.reachedTuvSection = true;
        }
        return newTmxTuv;
    }

    int langCount(LocaleId lang) {
        int counter = 0;
        for (TmxTuv tmxTuv : this.tuvs) {
            if (!tmxTuv.lang.equals(lang)) continue;
            ++counter;
        }
        return counter;
    }

    int tuvCount() {
        return this.tuvs.size();
    }

    TmxTuv getSourceTuv() {
        for (TmxTuv tmxTuv : this.tuvs) {
            if (tmxTuv.trgType != TmxFilter.TuvXmlLang.SOURCE) continue;
            return tmxTuv;
        }
        return null;
    }

    List<TmxTuv> getDuplicateTuvs() {
        ArrayList<TmxTuv> dups = new ArrayList<TmxTuv>();
        for (TmxTuv tmxTuv : this.tuvs) {
            if (tmxTuv.langCount <= 1) continue;
            dups.add(tmxTuv);
        }
        return dups;
    }

    void appendToSkel(String pskel) {
        if (!this.reachedTuvSection) {
            this.skelBefore.append(pskel);
        } else {
            this.skelAfter.append(pskel);
        }
    }

    void smartAppendToSkel(TmxFilter.TuvXmlLang tuvTrgType, String pskel) {
        if (tuvTrgType == TmxFilter.TuvXmlLang.UNDEFINED) {
            this.appendToSkel(pskel);
        } else {
            this.curTuv.appendToSkel(pskel);
        }
    }

    void addProp(Property prop) {
        Property existingProp = this.getProp(prop.getName());
        if (existingProp != null) {
            existingProp.setValue(existingProp.getValue() + ", " + prop.getValue());
        } else {
            this.propsBefore.add(prop);
        }
    }

    Property getProp(String name) {
        for (Property p : this.propsBefore) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    void parseStartElement(XMLStreamReader reader) {
        this.parseStartElement(reader, null);
    }

    String parseStartElement(XMLStreamReader reader, String elem) {
        int i;
        String propName = "";
        String prefix = reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.skelBefore.append("<" + reader.getLocalName());
        } else {
            this.skelBefore.append("<" + prefix + ":" + reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = reader.getNamespacePrefix(i);
            this.skelBefore.append(String.format(" xmlns%s=\"%s\"", prefix.length() > 0 ? ":" + prefix : "", reader.getNamespaceURI(i)));
        }
        count = reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!reader.isAttributeSpecified(i)) continue;
            prefix = reader.getAttributePrefix(i);
            this.skelBefore.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", reader.getAttributeLocalName(i), reader.getAttributeValue(i)));
            if (elem != null && elem.equals("prop")) {
                if (!reader.getAttributeLocalName(i).equals("type")) continue;
                propName = reader.getAttributeValue(i);
                continue;
            }
            if (elem != null && elem.equals("note")) continue;
            this.propsBefore.add(new Property(reader.getAttributeLocalName(i), reader.getAttributeValue(i), true));
        }
        this.skelBefore.append(">");
        if (elem != null && elem.equals("note")) {
            propName = "note";
        }
        return propName;
    }

    void parseEndElement(XMLStreamReader reader) {
        this.parseEndElement(reader, false);
    }

    void parseEndElement(XMLStreamReader reader, boolean addToSkelBefore) {
        String ns = reader.getPrefix();
        if (ns == null || ns.length() == 0) {
            if (addToSkelBefore) {
                this.skelBefore.append("</" + reader.getLocalName() + ">");
            } else {
                this.skelAfter.append("</" + reader.getLocalName() + ">");
            }
        } else {
            if (addToSkelBefore) {
                this.skelBefore.append("</" + ns + ":" + reader.getLocalName() + ">");
            } else {
                this.skelAfter.append("</" + ns + ":" + reader.getLocalName() + ">");
            }
            this.skelBefore.append("</" + ns + ":" + reader.getLocalName() + ">");
        }
    }

    void enforceTuRules() {
        if (this.tuvCount() < 1) {
            throw new OkapiBadFilterInputException("Each <tu> requires at least one <tuv>");
        }
        if (this.getSourceTuv() == null || this.langCount(this.srcLang) > 1) {
            throw new OkapiBadFilterInputException(String.format("The source language specified is '%s', but no <tuv> in the <tu> are set to this language.", this.srcLang));
        }
    }

    int addPrimaryTextUnitEvent(int tuId, boolean processAllTargets, LinkedList<Event> queue) {
        Property tuidProp;
        this.enforceTuRules();
        TextUnit tu = new TextUnit(String.valueOf(++tuId));
        GenericSkeleton tuSkel = new GenericSkeleton();
        tuSkel.add(this.skelBefore);
        for (Property prop : this.propsBefore) {
            tu.setProperty(prop);
        }
        for (TmxTuv tuv : this.tuvs) {
            if (tuv.langCount != 1 && (tuv.trgType != TmxFilter.TuvXmlLang.OTHER || processAllTargets)) continue;
            tuSkel.add(tuv.skelBefore);
            if (tuv.trgType == TmxFilter.TuvXmlLang.SOURCE) {
                TmxTuv srcTuv = this.getSourceTuv();
                tu.setSource(srcTuv.tc.clone());
                tuSkel.addContentPlaceholder(tu, null);
            } else if (tuv.trgType != TmxFilter.TuvXmlLang.OTHER || processAllTargets) {
                tu.setTarget(tuv.lang, tuv.tc);
                tuSkel.addContentPlaceholder(tu, tuv.lang);
            }
            tuSkel.add(tuv.skelAfter);
        }
        if (this.langCount(this.trgLang) == 0) {
            tuSkel.append("<tuv xml:lang=\"" + this.trgLang + "\"><seg>");
            tuSkel.addContentPlaceholder(tu, this.trgLang);
            tuSkel.append("</seg></tuv>" + this.lineBreak);
        }
        tuSkel.add(this.skelAfter);
        if (tu.getProperty("tuid") != null) {
            tu.setName(tu.getProperty("tuid").getValue());
        }
        if ((tuidProp = this.getProp("tuid")) != null) {
            tu.setName(tuidProp.getValue());
        }
        tu.setSkeleton(tuSkel);
        tu.setMimeType("application/x-tmx+xml");
        queue.add(new Event(EventType.TEXT_UNIT, tu));
        return tuId;
    }

    int addDuplicateTextUnitEvents(int tuId, boolean processAllTargets, LinkedList<Event> queue) {
        TmxTuv srcTuv = this.getSourceTuv();
        if (srcTuv == null) {
            throw new OkapiBadFilterInputException("Each <tu> requires at least one source <tuv>");
        }
        List<TmxTuv> dups = this.getDuplicateTuvs();
        for (TmxTuv dupTuv : dups) {
            if (dupTuv.trgType == TmxFilter.TuvXmlLang.OTHER && !processAllTargets) continue;
            TextUnit dupTu = new TextUnit(String.valueOf(++tuId));
            dupTu.setSource(srcTuv.tc.clone());
            dupTu.setTarget(dupTuv.lang, dupTuv.tc);
            GenericSkeleton dupTuSkel = new GenericSkeleton();
            dupTuSkel.add(this.skelBefore);
            dupTuSkel.add(srcTuv.skelBefore);
            dupTuSkel.addContentPlaceholder(dupTu, null);
            dupTuSkel.add(srcTuv.skelAfter);
            dupTuSkel.add(dupTuv.skelBefore);
            dupTuSkel.addContentPlaceholder(dupTu, dupTuv.lang);
            dupTuSkel.add(dupTuv.skelAfter);
            dupTuSkel.add(this.skelAfter);
            Property tuidProp = this.getProp("tuid");
            if (tuidProp != null) {
                dupTu.setName(tuidProp.getValue());
            }
            dupTu.setSkeleton(dupTuSkel);
            dupTu.setMimeType("application/x-tmx+xml");
            queue.add(new Event(EventType.TEXT_UNIT, dupTu));
        }
        return tuId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----TmxTu-----\n");
        sb.append("Skeleton Before: " + this.skelBefore + "\n");
        for (Property p : this.propsBefore) {
            sb.append("Property Name: " + p.getName() + "     Property Value: " + p.getValue() + "\n");
        }
        for (TmxTuv tuv : this.tuvs) {
            sb.append(tuv.toString());
        }
        sb.append("Skeleton After: " + this.skelAfter + "\n");
        return sb.toString();
    }
}

