/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.xini.jaxb.Element;
import net.sf.okapi.filters.xini.jaxb.EndPlaceHolder;
import net.sf.okapi.filters.xini.jaxb.Field;
import net.sf.okapi.filters.xini.jaxb.Fields;
import net.sf.okapi.filters.xini.jaxb.Main;
import net.sf.okapi.filters.xini.jaxb.ObjectFactory;
import net.sf.okapi.filters.xini.jaxb.Page;
import net.sf.okapi.filters.xini.jaxb.PlaceHolder;
import net.sf.okapi.filters.xini.jaxb.PlaceHolderType;
import net.sf.okapi.filters.xini.jaxb.Seg;
import net.sf.okapi.filters.xini.jaxb.StartPlaceHolder;
import net.sf.okapi.filters.xini.jaxb.Xini;

public class FilterEventToXiniTransformer {
    private ObjectFactory objectFactory = new ObjectFactory();
    private Marshaller m;
    private JAXBContext jc;
    private Xini xini;
    private Main main;
    private Page currentPage;
    private int currentPageId;
    private int currentElementId;
    private int currentFieldId;

    public void init() {
        try {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.m = this.jc.createMarshaller();
            this.m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"http://www.ontram.com/xsd/xini.xsd");
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        this.currentPageId = 0;
        this.currentElementId = 10;
        this.currentFieldId = 0;
        this.xini = this.objectFactory.createXini();
        this.xini.setSchemaVersion("1.0");
        this.main = this.objectFactory.createMain();
        this.xini.setMain(this.main);
    }

    protected void startPage(String name) {
        this.currentPage = new Page();
        ++this.currentPageId;
        this.currentElementId = 10;
        this.currentFieldId = 0;
        this.currentPage.setPageID(this.currentPageId);
        this.currentPage.setPageName(name);
        this.currentPage.setElements(new Page.Elements());
        this.xini.getMain().getPage().add(this.currentPage);
    }

    public void transformTextUnit(ITextUnit tu) {
        TextContainer textContainer = tu.getSource();
        if (!tu.isTranslatable()) {
            return;
        }
        Element element = this.objectFactory.createElement();
        Element.ElementContent elementContent = this.objectFactory.createElementElementContent();
        Fields fields = this.objectFactory.createFields();
        Field field = this.objectFactory.createField();
        this.currentPage.getElements().getElement().add(element);
        element.setElementContent(elementContent);
        elementContent.setFields(fields);
        fields.getField().add(field);
        element.setElementID(this.currentElementId);
        field.setFieldID(this.currentFieldId);
        field.setExternalID(tu.getId());
        field.setLabel(tu.getName());
        int currentSegmentId = 0;
        StringBuilder emptySegsFlags = new StringBuilder();
        for (Segment okapiSegment : textContainer.getSegments()) {
            TextFragment textFragment = okapiSegment.getContent();
            if (!textFragment.isEmpty()) {
                Seg xiniSegment = this.objectFactory.createSeg();
                xiniSegment.setSegID(currentSegmentId);
                field.getSegAndTrans().add(xiniSegment);
                List<Code> codes = textFragment.getCodes();
                if (codes.size() > 0) {
                    xiniSegment.getContent().addAll(this.transformInlineTags(textFragment.getCodedText(), codes));
                } else {
                    xiniSegment.getContent().add((Serializable)((Object)textFragment.getText()));
                }
                emptySegsFlags.append("0");
            } else {
                emptySegsFlags.append("1");
            }
            ++currentSegmentId;
        }
        field.setEmptySegmentsFlags(emptySegsFlags.toString());
    }

    private ArrayList<Serializable> transformInlineTags(String codedText, List<Code> codes) {
        ArrayList<Serializable> parts = new ArrayList<Serializable>();
        StringBuilder tempString = new StringBuilder();
        block5: for (int charIndex = 0; charIndex < codedText.length(); ++charIndex) {
            char chr = codedText.charAt(charIndex);
            if (!TextFragment.isMarker(chr)) {
                tempString.append(chr);
                continue;
            }
            int codePoint = codedText.codePointAt(charIndex);
            Integer codeIndex = TextFragment.toIndex(codedText.charAt(++charIndex));
            Code code = codes.get(codeIndex);
            boolean codeIsIsolated = false;
            if (tempString.length() > 0) {
                parts.add((Serializable)((Object)tempString.toString()));
            }
            tempString = new StringBuilder();
            switch (codePoint) {
                case 57601: {
                    Integer endMarkerIndex = this.findEndMark(codes, code, codedText, charIndex);
                    String innerCodedText = null;
                    if (endMarkerIndex != null) {
                        innerCodedText = codedText.substring(charIndex + 1, endMarkerIndex - 1);
                        charIndex = endMarkerIndex;
                    } else {
                        codeIsIsolated = true;
                    }
                    parts.add(this.codeToXMLObject(code, codes, innerCodedText, codeIsIsolated));
                    continue block5;
                }
                case 57602: {
                    parts.add(this.codeToXMLObject(code, codes, null, true));
                    continue block5;
                }
                case 57603: {
                    parts.add(this.codeToXMLObject(code, codes, null, true));
                }
            }
        }
        if (tempString.length() > 0) {
            parts.add((Serializable)((Object)tempString.toString()));
        }
        return parts;
    }

    private Integer findEndMark(List<Code> codes, Code code, String codedText, int startCharIndex) {
        for (int charIndex = startCharIndex; charIndex < codedText.length(); ++charIndex) {
            int endCodeIndex;
            Code endCode;
            int codePoint = codedText.codePointAt(charIndex);
            if (codePoint != 57602 || codedText.length() <= charIndex + 1 || (endCode = codes.get(endCodeIndex = TextFragment.toIndex(codedText.charAt(++charIndex)))).getType() != code.getType()) continue;
            return charIndex;
        }
        return null;
    }

    private Serializable codeToXMLObject(Code code, List<Code> codes, String innerCodedText, boolean codeIsIsolated) {
        Object phelement;
        if (!codeIsIsolated || codeIsIsolated && code.getTagType() == TextFragment.TagType.PLACEHOLDER) {
            PlaceHolder ph = new PlaceHolder();
            ph.setID(code.getId());
            ph.setType(PlaceHolderType.PH);
            if (innerCodedText != null && !innerCodedText.isEmpty()) {
                ph.getContent().addAll(this.transformInlineTags(innerCodedText, codes));
            }
            phelement = this.objectFactory.createTextContentPh(ph);
        } else if (code.getTagType() == TextFragment.TagType.OPENING) {
            StartPlaceHolder sph = new StartPlaceHolder();
            sph.setID(code.getId());
            sph.setType(PlaceHolderType.PH);
            phelement = this.objectFactory.createTextContentSph(sph);
        } else {
            EndPlaceHolder eph = new EndPlaceHolder();
            eph.setID(code.getId());
            eph.setType(PlaceHolderType.PH);
            phelement = this.objectFactory.createTextContentEph(eph);
        }
        return phelement;
    }

    public void marshall(OutputStream os) {
        try {
            this.m.marshal((Object)this.xini, os);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

