/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.filters;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.lib.extra.OkapiComponent;

public abstract class AbstractBaseFilter
extends OkapiComponent
implements IFilter {
    private String mimeType;
    private String displayName;
    List<FilterConfiguration> configList = new ArrayList<FilterConfiguration>();
    EncoderManager encoderManager;

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    protected void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    protected boolean addConfiguration(boolean clearAllExisting, String configId, String name, String description, String parametersLocation) {
        if (this.configList == null) {
            return false;
        }
        if (clearAllExisting) {
            this.configList.clear();
        }
        return this.configList.add(new FilterConfiguration(configId, this.getMimeType(), this.getClass().getName(), name, description, parametersLocation));
    }

    protected boolean addConfigurations(List<FilterConfiguration> configs) {
        if (this.configList == null) {
            return false;
        }
        return this.configList.addAll(configs);
    }

    protected FilterConfiguration findConfiguration(String configId) {
        if (Util.isEmpty(this.configList)) {
            return null;
        }
        for (FilterConfiguration config : this.configList) {
            if (config == null || !config.configId.equalsIgnoreCase(configId)) continue;
            return config;
        }
        return null;
    }

    protected boolean removeConfiguration(String configId) {
        return this.configList.remove(this.findConfiguration(configId));
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> res = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration fc : this.configList) {
            res.add(new FilterConfiguration(fc.configId, this.getMimeType(), this.getClass().getName(), fc.name, fc.description, fc.parametersLocation));
        }
        return res;
    }

    public boolean setConfiguration(String configId) {
        return true;
    }
}

