/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.longhornapi.impl.rest;

import java.io.InputStream;
import java.net.URI;
import net.sf.okapi.lib.longhornapi.LonghornFile;
import net.sf.okapi.lib.longhornapi.impl.rest.RESTProject;

public class RESTFile
implements LonghornFile {
    private RESTProject project;
    private Filetype type;
    private String relativePath;

    protected RESTFile() {
    }

    protected RESTFile(RESTProject project, Filetype type, String relativePath) {
        this.project = project;
        this.type = type;
        this.relativePath = relativePath;
    }

    @Override
    public InputStream openStream() {
        try {
            URI remoteFile = null;
            switch (this.type) {
                case input: {
                    remoteFile = new URI(this.project.getProjectURI() + "/inputFiles/" + this.relativePath);
                    break;
                }
                case output: {
                    remoteFile = new URI(this.project.getProjectURI() + "/outputFiles/" + this.relativePath);
                }
            }
            return remoteFile.toURL().openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    public static enum Filetype {
        input,
        output;

    }
}

