/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.longhornapi.impl.rest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.okapi.lib.longhornapi.LonghornFile;
import net.sf.okapi.lib.longhornapi.LonghornProject;
import net.sf.okapi.lib.longhornapi.impl.rest.RESTFile;
import net.sf.okapi.lib.longhornapi.impl.rest.Util;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;

public class RESTProject
implements LonghornProject {
    private URI projUri;

    protected RESTProject() {
    }

    protected RESTProject(URI projUri) {
        this.projUri = projUri;
    }

    protected RESTProject(URI serviceUri, String projId) {
        String newProjUri = serviceUri.toString();
        if (!newProjUri.endsWith("/")) {
            newProjUri = newProjUri + "/";
        }
        newProjUri = newProjUri + projId;
        try {
            this.projUri = new URI(newProjUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getProjectURI() {
        return this.projUri;
    }

    @Override
    public void addBatchConfiguration(File bconf) throws FileNotFoundException {
        Part[] parts = new Part[]{new FilePart("batchConfiguration", bconf.getName(), bconf)};
        try {
            Util.post(this.projUri + "/batchConfiguration", parts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addInputFile(File inputFile, String relativePath) throws FileNotFoundException {
        String uri = this.projUri + "/inputFiles/" + relativePath;
        Part[] inputParts = new Part[]{new FilePart("inputFile", inputFile.getName(), inputFile)};
        try {
            Util.put(uri, inputParts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        try {
            Util.delete(this.projUri.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executePipeline() {
        try {
            Util.post(this.projUri + "/tasks/execute", null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArrayList<LonghornFile> getInputFiles() {
        try {
            ArrayList<String> filenames = Util.getList(this.projUri + "/inputFiles");
            ArrayList<LonghornFile> files = new ArrayList<LonghornFile>();
            for (String filename : filenames) {
                files.add(new RESTFile(this, RESTFile.Filetype.input, filename));
            }
            return files;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArrayList<LonghornFile> getOutputFiles() {
        try {
            ArrayList<String> filenames = Util.getList(this.projUri + "/outputFiles");
            ArrayList<LonghornFile> files = new ArrayList<LonghornFile>();
            for (String filename : filenames) {
                files.add(new RESTFile(this, RESTFile.Filetype.output, filename));
            }
            return files;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addInputFilesFromZip(File zipFile) throws FileNotFoundException {
        Part[] parts = new Part[]{new FilePart("inputFile", zipFile.getName(), zipFile)};
        try {
            Util.post(this.projUri + "/inputFiles.zip", parts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getOutputFilesAsZip() {
        try {
            URI remoteFile = new URI(this.projUri + "/outputFiles.zip");
            return remoteFile.toURL().openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

