/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.omegat;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.filters2.TranslationException;

abstract class AbstractOkapiFilter
implements org.omegat.filters2.IFilter {
    protected IParseCallback parseCallback;
    protected ITranslateCallback translateCallback;
    protected IAlignCallback alignCallback;
    protected String defaultInEncoding = "UTF-8";
    protected String defaultOutEncoding = "UTF-8";
    protected String supportedExtensions;
    private final Pattern patternOpening = Pattern.compile("\\<g(\\d+?)\\>");
    private final Pattern patternClosing = Pattern.compile("\\</g(\\d+?)\\>");
    private final Pattern patternIsolated = Pattern.compile("\\<x(\\d+?)/\\>");
    private final Pattern patternIsolatedB = Pattern.compile("\\<b(\\d+?)/\\>");
    private final Pattern patternIsolatedE = Pattern.compile("\\<e(\\d+?)/\\>");
    private String filterConfigId;
    private FilterConfigurationMapper fcMapper;
    private String name;

    AbstractOkapiFilter() {
    }

    protected void initialize(String name, String filterClassName, String filterConfigId, String supportedExtensions) {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations(filterClassName);
        this.filterConfigId = filterConfigId;
        this.name = name;
        this.supportedExtensions = supportedExtensions;
    }

    @Override
    public void alignFile(File inFile, File outFile, Map<String, String> config, FilterContext context, IAlignCallback callback) throws Exception {
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        return null;
    }

    @Override
    public String getFileFormatName() {
        return this.name;
    }

    @Override
    public String getFuzzyMark() {
        return "fuzzy";
    }

    @Override
    public String getHint() {
        return "";
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        String ext = Util.getExtension(inFile.getAbsolutePath());
        if (Util.isEmpty(ext)) {
            return false;
        }
        return this.supportedExtensions.contains(ext);
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFile(File inFile, Map<String, String> config, FilterContext context, IParseCallback callback) throws Exception {
        this.parseCallback = callback;
        this.translateCallback = null;
        this.alignCallback = null;
        try {
            this.processFile(inFile, null, context);
        }
        finally {
            this.parseCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translateFile(File inFile, File outFile, Map<String, String> config, FilterContext context, ITranslateCallback callback) throws Exception {
        this.parseCallback = null;
        this.translateCallback = callback;
        this.alignCallback = null;
        try {
            this.processFile(inFile, outFile, context);
        }
        finally {
            this.translateCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(File inFile, File outFile, FilterContext context) throws IOException, TranslationException {
        String outEncoding;
        String inEncoding;
        LocaleId srcLoc = LocaleId.ENGLISH;
        if (context.getSourceLang() != null) {
            srcLoc = LocaleId.fromString(context.getSourceLang().getLanguage());
        }
        LocaleId trgLoc = LocaleId.FRENCH;
        if (context.getTargetLang() != null) {
            trgLoc = LocaleId.fromString(context.getTargetLang().getLanguage());
        }
        if ((inEncoding = context.getInEncoding()) == null) {
            inEncoding = this.defaultInEncoding;
        }
        if ((outEncoding = context.getOutEncoding()) == null) {
            outEncoding = this.defaultOutEncoding;
        }
        IFilter filter = null;
        IFilterWriter writer = null;
        try {
            filter = this.fcMapper.createFilter(this.filterConfigId);
            if (filter == null) {
                throw new RuntimeException(String.format("Could not create a filter for the configuration '%s'.", this.filterConfigId));
            }
            RawDocument rd = new RawDocument(inFile.toURI(), inEncoding, srcLoc, trgLoc);
            filter.open(rd);
            if (outFile != null) {
                writer = filter.createFilterWriter();
                writer.setOptions(trgLoc, outEncoding);
                writer.setOutput(outFile.getAbsolutePath());
            }
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.isTextUnit()) {
                    ITextUnit tu = event.getTextUnit();
                    if (!tu.isTranslatable()) continue;
                    boolean isFuzzy = false;
                    TextContainer tc = null;
                    if (tu.hasTarget(trgLoc)) {
                        tc = tu.getTarget(trgLoc);
                        if (tc.hasProperty("approved")) {
                            boolean bl = isFuzzy = !tc.getProperty("approved").getValue().equals("yes");
                        }
                        if (tc.isEmpty()) {
                            tc = null;
                        }
                    }
                    Segment trgSeg = null;
                    ISegments trgSegs = null;
                    if (tc == null) {
                        tc = tu.createTarget(trgLoc, false, 7);
                        for (Segment seg : tc.getSegments()) {
                            seg.text = new TextFragment();
                        }
                    }
                    trgSegs = tc.getSegments();
                    for (Segment srcSeg : tu.getSource().getSegments()) {
                        trgSeg = trgSegs.get(srcSeg.id);
                        if (writer == null) {
                            if (trgSeg == null || trgSeg.text.isEmpty()) {
                                this.parseCallback.addEntry(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text), null, false, null, this);
                                continue;
                            }
                            this.parseCallback.addEntry(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text), this.toOmegat(trgSeg.text), isFuzzy, null, this);
                            continue;
                        }
                        String trans = this.translateCallback.getTranslation(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text));
                        if (!Util.isEmpty(trans)) {
                            if (trgSeg == null) continue;
                            trgSeg.text = srcSeg.text.clone();
                            this.fromOmegat(trans, trgSeg.text);
                            continue;
                        }
                        trgSeg.text = new TextFragment();
                    }
                }
                if (writer == null) continue;
                writer.handleEvent(event);
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String toOmegat(TextFragment tf) {
        if (!tf.hasCode()) {
            return tf.getCodedText();
        }
        StringBuilder tmp = new StringBuilder();
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        for (int i = 0; i < ctext.length(); ++i) {
            if (TextFragment.isMarker(ctext.charAt(i))) {
                int index = TextFragment.toIndex(ctext.charAt(++i));
                Code code = codes.get(index);
                switch (code.getTagType()) {
                    case OPENING: {
                        tmp.append(String.format("<g%d>", code.getId()));
                        break;
                    }
                    case CLOSING: {
                        tmp.append(String.format("</g%d>", code.getId()));
                        break;
                    }
                    case PLACEHOLDER: {
                        if (code.getTagType() == TextFragment.TagType.OPENING) {
                            tmp.append(String.format("<b%d/>", code.getId()));
                            break;
                        }
                        if (code.getTagType() == TextFragment.TagType.CLOSING) {
                            tmp.append(String.format("<e%d/>", code.getId()));
                            break;
                        }
                        tmp.append(String.format("<x%d/>", code.getId()));
                    }
                }
                continue;
            }
            tmp.append(ctext.charAt(i));
        }
        return tmp.toString();
    }

    private void fromOmegat(String text, TextFragment frag) {
        int index;
        int n;
        if (!frag.hasCode() && text.indexOf(60) == -1) {
            frag.setCodedText(text);
            return;
        }
        StringBuilder tmp = new StringBuilder(text);
        int start = 0;
        int diff = 0;
        Matcher m = this.patternOpening.matcher(text);
        while (m.find(start)) {
            n = m.start();
            index = frag.getIndex(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternClosing.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = frag.getIndexForClosing(Integer.valueOf(m.group(1)));
            frag.getCode(index).setId(-1);
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternIsolated.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = frag.getIndex(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternIsolatedB.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = frag.getIndex(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternIsolatedE.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = frag.getIndexForClosing(Integer.valueOf(m.group(1)));
            frag.getCode(index).setId(-1);
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        frag.setCodedText(tmp.toString(), false);
    }
}

