/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.Comparator;
import net.sf.okapi.lib.verification.Issue;

public class IssueComparator
implements Comparator<Issue> {
    public static final int DIR_ASC = 1;
    public static final int DIR_DESC = -1;
    public static final int TYPE_ENABLED = 0;
    public static final int TYPE_SEVERITY = 1;
    public static final int TYPE_TU = 2;
    public static final int TYPE_SEG = 3;
    public static final int TYPE_MESSAGE = 4;
    private int type = 0;
    private int direction = 1;

    public IssueComparator(int type, int direction) {
        this.type = type;
        this.direction = direction;
    }

    @Override
    public int compare(Issue issue1, Issue issue2) {
        switch (this.type) {
            case 0: {
                if (issue1.enabled == issue2.enabled) {
                    return 0;
                }
                if (this.direction == 1) {
                    return issue1.enabled ? 1 : -1;
                }
                return issue1.enabled ? -1 : 1;
            }
            case 1: {
                if (issue1.severity == issue2.severity) {
                    return 0;
                }
                if (this.direction == 1) {
                    return issue1.severity > issue2.severity ? 1 : -1;
                }
                return issue1.severity > issue2.severity ? -1 : 1;
            }
            case 2: {
                String key1 = issue1.docURI.toString() + issue1.tuId;
                String key2 = issue2.docURI.toString() + issue2.tuId;
                if (key1.equals(key2)) {
                    return 0;
                }
                if (this.direction == 1) {
                    return key1.compareTo(key2);
                }
                return key2.compareTo(key1);
            }
            case 3: {
                String key1 = issue1.docURI.toString() + issue1.tuId + (issue1.segId == null ? "" : issue1.segId);
                String key2 = issue2.docURI.toString() + issue2.tuId + (issue2.segId == null ? "" : issue2.segId);
                if (key1.equals(key2)) {
                    return 0;
                }
                if (this.direction == 1) {
                    return key1.compareTo(key2);
                }
                return key2.compareTo(key1);
            }
            case 4: {
                if (issue1.message.equals(issue2.message)) {
                    return 0;
                }
                if (this.direction == 1) {
                    return issue1.message.compareTo(issue2.message);
                }
                return issue2.message.compareTo(issue1.message);
            }
        }
        return 0;
    }
}

