/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import net.sf.okapi.lib.xliff.Code;

public class Fragment {
    public static final int STYLE_XSDTEMP = -1;
    public static final int STYLE_NODATA = 0;
    public static final int STYLE_DATAINSIDE = 1;
    public static final int STYLE_DATAOUTSIDE = 2;
    public static final char MARKER_OPENING = '\ue101';
    public static final char MARKER_CLOSING = '\ue102';
    public static final char MARKER_PLACEHOLDER = '\ue103';
    public static final int CHARBASE = 57616;
    private StringBuilder ctext;
    private ArrayList<Code> codes;

    public static String toXML(String text, boolean attribute) {
        text = text.replace("&", "&amp;");
        text = text.replace("<", "&lt;");
        if (attribute) {
            text = text.replace("\"", "&quot;");
        }
        return text;
    }

    public static char toChar(int index) {
        return (char)(index + 57616);
    }

    public static int toIndex(char index) {
        return index - 57616;
    }

    public static boolean isMarker(char ch) {
        return ch == '\ue101' || ch == '\ue102' || ch == '\ue103';
    }

    public String getString(int style) {
        switch (style) {
            case -1: {
                return this.getStringXSDTemp();
            }
            case 1: {
                return this.getStringDataInside();
            }
        }
        return this.toString();
    }

    private String getStringXSDTemp() {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (this.ctext.charAt(i) == '\ue101') {
                tmp.append(String.format("<inline id=\"%d\"/>", Fragment.toIndex(this.ctext.charAt(++i))));
                continue;
            }
            if (this.ctext.charAt(i) == '\ue102') {
                tmp.append(String.format("<inline id=\"%d\"/>", Fragment.toIndex(this.ctext.charAt(++i))));
                continue;
            }
            if (this.ctext.charAt(i) == '\ue103') {
                tmp.append(String.format("<inline id=\"%d\"/>", Fragment.toIndex(this.ctext.charAt(++i))));
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block5;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block5;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public String getStringDataInside() {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.ctext.length(); ++i) {
            Code code;
            int index;
            char ch = this.ctext.charAt(i);
            if (this.ctext.charAt(i) == '\ue101') {
                index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<sc id=\"%d\">", index));
                tmp.append(Fragment.toXML(code.getNativeData(), false));
                tmp.append("</sc>");
                continue;
            }
            if (this.ctext.charAt(i) == '\ue102') {
                index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<ec id=\"%d\">", index));
                tmp.append(Fragment.toXML(code.getNativeData(), false));
                tmp.append("</ec>");
                continue;
            }
            if (this.ctext.charAt(i) == '\ue103') {
                index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<ic id=\"%d\">", index));
                tmp.append(Fragment.toXML(code.getNativeData(), false));
                tmp.append("</ic>");
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block5;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block5;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (this.ctext.charAt(i) == '\ue101') {
                tmp.append(String.format("<pc id=\"%d\">", Fragment.toIndex(this.ctext.charAt(++i))));
                continue;
            }
            if (this.ctext.charAt(i) == '\ue102') {
                tmp.append("</pc>");
                ++i;
                continue;
            }
            if (this.ctext.charAt(i) == '\ue103') {
                tmp.append(String.format("<ic id=\"%d\"/>", Fragment.toIndex(this.ctext.charAt(++i))));
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block5;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block5;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public Fragment() {
        this.ctext = new StringBuilder();
    }

    public Fragment(String plainText) {
        this.ctext = new StringBuilder(plainText);
    }

    public boolean isEmpty() {
        return this.ctext.length() == 0;
    }

    public void clear() {
        this.ctext.setLength(0);
        this.codes = null;
    }

    public void append(String plainText) {
        this.ctext.append(plainText);
    }

    public void append(char ch) {
        this.ctext.append(ch);
    }

    public Code append(Code.TYPE type, String nativeData) {
        if (this.codes == null) {
            this.codes = new ArrayList();
        }
        Code code = new Code(nativeData);
        this.codes.add(code);
        switch (type) {
            case OPENING: {
                this.ctext.append("\ue101" + Fragment.toChar(this.codes.size() - 1));
                break;
            }
            case CLOSING: {
                this.ctext.append("\ue102" + Fragment.toChar(this.codes.size() - 1));
                break;
            }
            case PLACEHOLDER: {
                this.ctext.append("\ue103" + Fragment.toChar(this.codes.size() - 1));
            }
        }
        return code;
    }
}

