/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.sf.okapi.lib.xliff.Alternate;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.Segment;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.XLIFFWriterException;

public class XLIFFWriter {
    public static final String NS_XLIFF20 = "urn:oasis:names:tc:xliff:document:2.0";
    private PrintWriter writer = null;
    private String lb = System.getProperty("line.separator");
    private boolean isIndented = false;
    private String indent;
    private boolean inFile;
    private int style = 0;

    public void create(File file) {
        try {
            String path = file.getCanonicalPath();
            int n = path.lastIndexOf(92);
            if (n == -1) {
                path.lastIndexOf(47);
            }
            if (n > -1) {
                File dir = new File(path.substring(0, n));
                dir.mkdirs();
            }
            this.create(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"));
        }
        catch (FileNotFoundException e) {
            throw new XLIFFWriterException("Cannote create document.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XLIFFWriterException("Unsupported encoding.", e);
        }
        catch (IOException e) {
            throw new XLIFFWriterException("Cannote create document.", e);
        }
    }

    public void create(Writer output) {
        this.writer = new PrintWriter(output);
        this.indent = "";
        this.inFile = false;
    }

    public void setInlineStyle(int style) {
        switch (style) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.style = style;
                return;
            }
        }
        throw new XLIFFWriterException(String.format("Style %d is not valid.", style));
    }

    public int getInlineStyle() {
        return this.style;
    }

    public void setLineBreak(String lineBreak) {
        this.lb = lineBreak;
    }

    public String getLineBreak() {
        return this.lb;
    }

    public void setIsIndented(boolean isIndented) {
        this.isIndented = isIndented;
    }

    public boolean getIsIndented() {
        return this.isIndented;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void writeUnit(Unit unit) {
        if (!this.inFile) {
            this.writeStartFile();
        }
        this.writer.print(this.indent + String.format("<unit id=\"%s\"", Fragment.toXML(unit.getId(), true)));
        this.writer.print(">" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        int sequence = 0;
        for (Part part : unit) {
            Segment seg = null;
            if (part instanceof Segment) {
                seg = (Segment)part;
            }
            ++sequence;
            if (seg != null) {
                this.writer.print(this.indent + "<segment>" + this.lb);
            } else {
                this.writer.print(this.indent + "<ignorable>" + this.lb);
            }
            if (this.isIndented) {
                this.indent = this.indent + " ";
            }
            this.writeFragment("source", part.getSource(), -1);
            if (part.hasTarget()) {
                this.writeFragment("target", part.getTarget(), part.targetOrder != sequence ? part.targetOrder : 0);
            }
            if (seg != null && seg.getCandidates().size() > 0) {
                this.writer.print(this.indent + "<matches>" + this.lb);
                if (this.isIndented) {
                    this.indent = this.indent + " ";
                }
                for (Alternate alt : seg.getCandidates()) {
                    this.writer.print(this.indent + "<match>" + this.lb);
                    if (this.isIndented) {
                        this.indent = this.indent + " ";
                    }
                    this.writeFragment("source", alt.getSource(), -1);
                    this.writeFragment("target", alt.getTarget(), -1);
                    if (this.isIndented) {
                        this.indent = this.indent.substring(1);
                    }
                    this.writer.print(this.indent + "</match>" + this.lb);
                }
                if (this.isIndented) {
                    this.indent = this.indent.substring(1);
                }
                this.writer.print(this.indent + "</matches>" + this.lb);
            }
            if (this.isIndented) {
                this.indent = this.indent.substring(1);
            }
            if (seg != null) {
                this.writer.print(this.indent + "</segment>" + this.lb);
                continue;
            }
            this.writer.print(this.indent + "</ignorable>" + this.lb);
        }
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</unit>" + this.lb);
    }

    public void writeStartDocument() {
        this.writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.lb);
        this.writer.print("<xliff version=\"2.0\"" + this.lb);
        this.writer.print(" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\"" + this.lb);
        this.writer.print(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + this.lb);
        this.writer.print(" xsi:schemaLocation=\"urn:oasis:names:tc:xliff:document:2.0 xliff_core_2.0.xsd\"" + this.lb);
        this.writer.print(">" + this.lb);
        this.writer.print("<!-- This output is EXPERIMENTAL only. -->" + this.lb);
        this.writer.print("<!-- XLIFF 2.0 is not defined yet. -->" + this.lb);
        this.writer.print("<!-- For feedback or more info, please see the XLIFF TC (http://www.oasis-open.org/committees/xliff) -->" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
    }

    public void writeEndDocument() {
        if (this.inFile) {
            this.writeEndFile();
        }
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print("</xliff>" + this.lb);
    }

    public void writeStartFile() {
        this.writer.print(this.indent + "<file>" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        this.inFile = true;
    }

    public void writeEndFile() {
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</file>" + this.lb);
        this.inFile = false;
    }

    public void writeStartGroup() {
        if (!this.inFile) {
            this.writeStartFile();
        }
        this.writer.print(this.indent + "<group>" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
    }

    public void writeEndGroup() {
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</group>" + this.lb);
    }

    private void writeFragment(String name, Fragment fragment, int order) {
        if (order > 0) {
            this.writer.print(this.indent + String.format("<%s order=\"%d\">", name, order));
        } else {
            this.writer.print(this.indent + "<" + name + ">");
        }
        this.writer.print(fragment.getString(this.style));
        this.writer.print("</" + name + ">" + this.lb);
    }
}

