/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=ExtractionVerificationStepParameters.class)
public class ExtractionVerificationStepParameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String COMPARESKELETON = "compareSkeleton";
    private static final String STEPENABLED = "stepEnabled";
    private static final String ALLEVENTS = "allEvents";
    private static final String LIMIT = "limit";
    private static final String INTERRUPT = "interrupt";
    private boolean compareSkeleton;
    private boolean stepEnabled;
    private boolean allEvents;
    private int limit;
    private boolean interrupt;

    public ExtractionVerificationStepParameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.compareSkeleton = true;
        this.stepEnabled = true;
        this.allEvents = true;
        this.limit = 10;
        this.interrupt = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.compareSkeleton = this.buffer.getBoolean(COMPARESKELETON, this.compareSkeleton);
        this.stepEnabled = this.buffer.getBoolean(STEPENABLED, this.stepEnabled);
        this.allEvents = this.buffer.getBoolean(ALLEVENTS, this.allEvents);
        this.limit = this.buffer.getInteger(LIMIT, this.limit);
        this.interrupt = this.buffer.getBoolean(INTERRUPT, this.interrupt);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(COMPARESKELETON, this.compareSkeleton);
        this.buffer.setBoolean(STEPENABLED, this.stepEnabled);
        this.buffer.setBoolean(ALLEVENTS, this.allEvents);
        this.buffer.setInteger(LIMIT, this.limit);
        this.buffer.setBoolean(INTERRUPT, this.interrupt);
        return this.buffer.toString();
    }

    public boolean getStepEnabled() {
        return this.stepEnabled;
    }

    public void setStepEnabled(boolean stepEnabled) {
        this.stepEnabled = stepEnabled;
    }

    public boolean getCompareSkeleton() {
        return this.compareSkeleton;
    }

    public void setCompareSkeleton(boolean compareSkeleton) {
        this.compareSkeleton = compareSkeleton;
    }

    public boolean getAllEvents() {
        return this.allEvents;
    }

    public void setAllEvents(boolean allEvents) {
        this.allEvents = allEvents;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean getInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(STEPENABLED, "Perform the extraction verification", null);
        desc.add(COMPARESKELETON, "Compare skeleton", null);
        desc.add(ALLEVENTS, "Verify all events (otherwise only text units are verified)", null);
        desc.add(LIMIT, "Maximum number of warnings per document", null);
        desc.add(INTERRUPT, "Interrupt after reaching the maximum number of warnings", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Extraction Verification", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(STEPENABLED));
        desc.addSeparatorPart();
        CheckboxPart cbp2 = desc.addCheckboxPart(paramsDesc.get(ALLEVENTS));
        cbp2.setMasterPart(cbp, true);
        cbp2 = desc.addCheckboxPart(paramsDesc.get(COMPARESKELETON));
        cbp2.setMasterPart(cbp, true);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(LIMIT));
        tip.setMasterPart(cbp, true);
        cbp2 = desc.addCheckboxPart(paramsDesc.get(INTERRUPT));
        cbp2.setMasterPart(cbp, true);
        return desc;
    }
}

