/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.BaseReferenceable;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class ExtractionVerificationUtil {
    private static final Logger LOGGER = Logger.getLogger(ExtractionVerificationUtil.class.getName());
    boolean compareSkeleton;

    public ExtractionVerificationUtil() {
        this.compareSkeleton = true;
    }

    public ExtractionVerificationUtil(boolean compareSkeleton) {
        this.compareSkeleton = compareSkeleton;
    }

    public boolean isCompareSkeleton() {
        return this.compareSkeleton;
    }

    public void setCompareSkeleton(boolean compareSkeleton) {
        this.compareSkeleton = compareSkeleton;
    }

    public boolean compareStartSubDocument(StartSubDocument ssd1, StartSubDocument ssd2) {
        if (this.bothAreNull(ssd1, ssd2)) {
            return true;
        }
        if (this.oneIsNulll(ssd1, ssd2, "compareStartSubDocument", "StartSubDocument") || this.oneIsNulll(ssd1.getParentId(), ssd2.getParentId(), "compareStartSubDocument", "StartSubDocument Parent Id") || this.oneIsNulll(ssd1.getFilterParameters(), ssd2.getFilterParameters(), "compareStartSubDocument", "StartSubDocument Parent Id")) {
            return false;
        }
        if (!this.bothAreNull(ssd1.getParentId(), ssd2.getParentId()) && !ssd1.getParentId().equals(ssd2.getParentId())) {
            LOGGER.warning("compareStartSubDocument warning: StartSubDocument Parent Id difference.");
            return false;
        }
        if (!this.bothAreNull(ssd1.getFilterParameters(), ssd2.getFilterParameters()) && !ssd1.getFilterParameters().equals(ssd2.getFilterParameters())) {
            LOGGER.warning("compareStartSubDocument warning: StartSubDocument FilterParameters difference.");
            return false;
        }
        return this.compareINameables(ssd1, ssd2);
    }

    public boolean compareBaseReferenceable(BaseReferenceable br1, BaseReferenceable br2) {
        if (this.bothAreNull(br1, br2)) {
            return true;
        }
        if (this.oneIsNulll(br1, br2, "compareBaseReferenceable", "BaseReferenceable") || this.oneIsNulll(br1.getParentId(), br2.getParentId(), "compareBaseReferenceable", "BaseReferenceable Parent Id")) {
            return false;
        }
        if (!this.bothAreNull(br1.getParentId(), br2.getParentId()) && !br1.getParentId().equals(br2.getParentId())) {
            LOGGER.warning("compareBaseReferenceable warning: BaseReferenceable Parent Id difference.");
            return false;
        }
        if (!this.compareINameables(br1, br2)) {
            return false;
        }
        return this.compareIReferenceables(br1, br2);
    }

    public boolean compareTextUnits(ITextUnit tu1, ITextUnit tu2) {
        if (this.bothAreNull(tu1, tu2)) {
            return true;
        }
        if (this.oneIsNulll(tu1, tu2, "compareTextUnits", "ITextUnit")) {
            return false;
        }
        if (!this.compareINameables(tu1, tu2)) {
            return false;
        }
        if (!this.compareIReferenceables(tu1, tu2)) {
            return false;
        }
        if (tu1.isEmpty() != tu2.isEmpty()) {
            LOGGER.warning("compareTextUnits warning: ITextUnit isEmtpy difference.");
            return false;
        }
        if (tu1.hasVariantSources() != tu2.hasVariantSources()) {
            LOGGER.warning("compareTextUnits warning: ITextUnit hasVariantSources difference.");
            return false;
        }
        if (!this.compareTextContainers(tu1.getSource(), tu2.getSource())) {
            return false;
        }
        for (LocaleId locId : tu1.getTargetLocales()) {
            if (this.compareTextContainers(tu1.getTarget(locId), tu2.getTarget(locId))) continue;
            return false;
        }
        return true;
    }

    public boolean compareTextContainers(TextContainer tc1, TextContainer tc2) {
        if (this.bothAreNull(tc1, tc2)) {
            return true;
        }
        if (this.oneIsNulll(tc1, tc2, "compareTextContainer", "TextContainer")) {
            return false;
        }
        if (tc1.hasBeenSegmented() != tc2.hasBeenSegmented()) {
            LOGGER.warning("compareTextContainer warning: hasBeenSegmented difference.");
            return false;
        }
        if (!((Object)tc1.getPropertyNames()).equals(tc2.getPropertyNames())) {
            LOGGER.warning("compareTextContainer warning: TextContainer properties difference.");
            return false;
        }
        for (String name : tc1.getPropertyNames()) {
            if (this.compareProperties(tc1.getProperty(name), tc2.getProperty(name))) continue;
            return false;
        }
        if (tc1.count() != tc2.count()) {
            LOGGER.warning("compareTextContainer warning: TextPart count difference.\ntc1=" + tc1.count() + "\ntc2=" + tc2.count());
            return false;
        }
        Iterator<TextPart> it1 = tc1.iterator();
        Iterator<TextPart> it2 = tc2.iterator();
        while (it1.hasNext()) {
            TextPart tp1 = it1.next();
            TextPart tp2 = it2.next();
            if (!tp1.isSegment() == tp2.isSegment()) {
                LOGGER.warning("compareTextContainer warning: TextContainer TextPart <--> Segment difference.");
                return false;
            }
            if (!(tp1.isSegment() ? !this.compareSegments((Segment)tp1, (Segment)tp2) : !this.compareTextParts(tp1, tp2))) continue;
            return false;
        }
        return true;
    }

    public boolean compareSegments(Segment seg1, Segment seg2) {
        if (this.bothAreNull(seg1, seg2)) {
            return true;
        }
        if (this.oneIsNulll(seg1, seg2, "compareSegments", "Segment") || this.oneIsNulll(seg1.getId(), seg2.getId(), "compareSegment", "Segment Id")) {
            return false;
        }
        if (!this.bothAreNull(seg1.getId(), seg2.getId()) && !seg1.getId().equals(seg2.getId())) {
            LOGGER.warning("compareSegment warning: Segment Id difference.");
            return false;
        }
        return this.compareTextFragments(seg1.getContent(), seg2.getContent());
    }

    public boolean compareTextParts(TextPart tp1, TextPart tp2) {
        if (this.bothAreNull(tp1, tp2)) {
            return true;
        }
        if (this.oneIsNulll(tp1, tp2, "compareTextPart", "TextPart")) {
            return false;
        }
        return this.compareTextFragments(tp1.getContent(), tp2.getContent());
    }

    public boolean compareTextFragments(TextFragment tf1, TextFragment tf2) {
        String codeStr2;
        if (this.bothAreNull(tf1, tf2)) {
            return true;
        }
        if (this.oneIsNulll(tf1, tf2, "compareTextFragment", "TextFragment")) {
            return false;
        }
        List<Code> codes1 = tf1.getCodes();
        List<Code> codes2 = tf2.getCodes();
        if (codes1.size() != codes2.size()) {
            LOGGER.warning("compareTextFragment warning: TextFragment code count difference.\ntf1=" + codes1.size() + "\ntf2=" + codes2.size());
            return false;
        }
        if (!tf1.getCodedText().equals(tf2.getCodedText())) {
            LOGGER.warning("compareTextFragment warning: TextFragment coded text difference.\ntext1=\"" + tf1.getCodedText() + "\"\ntext2=\"" + tf2.getCodedText() + "\"");
            return false;
        }
        for (int i = 0; i < codes1.size(); ++i) {
            Code code1 = codes1.get(i);
            Code code2 = codes2.get(i);
            if (code1.getId() != code2.getId()) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code id difference.\ncode1 id=\"" + code1.getId() + "\"\ncode2 id=\"" + code2.getId() + "\"");
                return false;
            }
            if (!code1.getData().equals(code2.getData())) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code data difference.\ncode1 data=\"" + code1.getData() + "\"\ncode2 data=\"" + code2.getData() + "\"");
                return false;
            }
            if (!code1.getOuterData().equals(code2.getOuterData())) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code outer data difference.\ncode1 outerdata=\"" + code1.getOuterData() + "\"\ncode2 outerdata=\"" + code2.getOuterData() + "\"");
                return false;
            }
            if (!code1.getType().equals(code2.getType())) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code type difference.\ncode1 type=\"" + code1.getType() + "\"\ncode2 type=\"" + code2.getType() + "\"");
                return false;
            }
            if (code1.getTagType() != code2.getTagType()) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code TagType difference.");
                return false;
            }
            if (code1.hasReference() != code2.hasReference()) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code hasReference difference.");
                return false;
            }
            if (code1.isCloneable() != code2.isCloneable()) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code isCloenable difference.");
                return false;
            }
            if (code1.isDeleteable() != code2.isDeleteable()) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code isDeleteable difference.");
                return false;
            }
            if (code1.hasAnnotation() != code2.hasAnnotation()) {
                LOGGER.warning("compareTextFragment warning: TextFragment Code hasAnnotation difference.");
                return false;
            }
            if (code1.hasAnnotation() == code2.hasAnnotation()) continue;
            LOGGER.warning("compareTextFragment warning: TextFragment Code hasAnnotation difference.");
            return false;
        }
        String codeStr1 = Code.codesToString(codes1);
        if (!codeStr1.equals(codeStr2 = Code.codesToString(codes2))) {
            LOGGER.warning("compareTextFragment warning: TextFragment Code string difference.\ncode1=\"" + codeStr1 + "\"\ncode2=\"" + codeStr2 + "\"");
            return false;
        }
        return true;
    }

    public boolean compareINameables(INameable n1, INameable n2) {
        if (this.bothAreNull(n1, n2)) {
            return true;
        }
        if (this.oneIsNulll(n1, n2, "compareINameable", "INameable") || this.oneIsNulll(n1.getName(), n2.getName(), "compareINameable", "INameable Name") || this.oneIsNulll(n1.getType(), n2.getType(), "compareINameable", "INameable Type") || this.oneIsNulll(n1.getMimeType(), n2.getMimeType(), "compareINameable", "INameable MimeType")) {
            return false;
        }
        if (!this.bothAreNull(n1.getName(), n2.getName()) && !n1.getName().equals(n2.getName())) {
            LOGGER.warning("compareINameables warning: INameable Name difference.");
            return false;
        }
        if (!this.bothAreNull(n1.getType(), n2.getType()) && !n1.getType().equals(n2.getType())) {
            LOGGER.warning("compareINameables warning: INameable Type difference.");
            return false;
        }
        if (!this.bothAreNull(n1.getMimeType(), n2.getMimeType()) && !n1.getMimeType().equals(n2.getMimeType())) {
            LOGGER.warning("compareINameables warning: INameable MimeType difference.");
            return false;
        }
        if (n1.isTranslatable() != n2.isTranslatable()) {
            LOGGER.warning("compareINameables warning: INameable isTranslatable difference.");
            return false;
        }
        if (n1.preserveWhitespaces() != n2.preserveWhitespaces()) {
            LOGGER.warning("compareINameables warning: INameable isTranslatable difference.");
            return false;
        }
        if (!((Object)n1.getPropertyNames()).equals(n2.getPropertyNames())) {
            LOGGER.warning("compareINameables warning: INameable properties difference.");
            return false;
        }
        for (String name : n1.getPropertyNames()) {
            if (this.compareProperties(n1.getProperty(name), n2.getProperty(name))) continue;
            return false;
        }
        if (!((Object)n1.getSourcePropertyNames()).equals(n2.getSourcePropertyNames())) {
            LOGGER.warning("compareINameables warning: INameable source properties difference.");
            return false;
        }
        for (String name : n1.getSourcePropertyNames()) {
            if (this.compareProperties(n1.getSourceProperty(name), n2.getSourceProperty(name))) continue;
            return false;
        }
        if (!((Object)n1.getTargetLocales()).equals(n2.getTargetLocales())) {
            LOGGER.warning("compareINameables warning: INameable target locales difference.");
            return false;
        }
        for (LocaleId locId : n1.getTargetLocales()) {
            if (!((Object)n1.getTargetPropertyNames(locId)).equals(n2.getTargetPropertyNames(locId))) {
                LOGGER.warning("compareINameables warning: INameable target properties difference.");
                return false;
            }
            for (String name : n1.getTargetPropertyNames(locId)) {
                if (this.compareProperties(n1.getTargetProperty(locId, name), n2.getTargetProperty(locId, name))) continue;
                return false;
            }
        }
        return this.compareIResources(n1, n2);
    }

    public boolean compareIResources(IResource r1, IResource r2) {
        if (this.bothAreNull(r1, r2)) {
            return true;
        }
        if (this.oneIsNulll(r1, r2, "compareIResource", "IResource") || this.oneIsNulll(r1.getId(), r2.getId(), "compareIResource", "IResource Id")) {
            return false;
        }
        if (!this.bothAreNull(r1.getId(), r2.getId()) && !r1.getId().equals(r2.getId())) {
            LOGGER.warning("compareIResource warning: IResource Id difference.");
            return false;
        }
        if (!this.compareSkeleton) {
            return true;
        }
        if (this.bothAreNull(r1.getSkeleton(), r2.getSkeleton())) {
            return true;
        }
        if (this.oneIsNulll(r1.getSkeleton(), r2.getSkeleton(), "compareIResource", "IResource skeleton") || this.oneIsNulll(((Object)r1.getSkeleton()).toString(), ((Object)r2.getSkeleton()).toString(), "compareIResource", "IResource skeleton string")) {
            return false;
        }
        if (!((Object)r1.getSkeleton()).toString().equals(((Object)r2.getSkeleton()).toString())) {
            LOGGER.warning("compareIResource warning: Skeleton content difference.\nskel1=\"" + ((Object)r1.getSkeleton()).toString() + "\"\nskel2=\"" + ((Object)r2.getSkeleton()).toString() + "\"");
            return false;
        }
        return true;
    }

    public boolean compareIReferenceables(IReferenceable r1, IReferenceable r2) {
        if (this.bothAreNull(r1, r2)) {
            return true;
        }
        if (this.oneIsNulll(r1, r2, "compareIReferenceable", "IReferenceable")) {
            return false;
        }
        if (r1.isReferent() != r2.isReferent()) {
            LOGGER.warning("compareIReferenceable warning: IReferenceable isReferent difference.");
            return false;
        }
        if (r1.getReferenceCount() != r2.getReferenceCount()) {
            LOGGER.warning("compareIReferenceable warning: IReferenceable getReferenceCount difference.");
            return false;
        }
        return true;
    }

    public boolean compareProperties(Property p1, Property p2) {
        if (this.bothAreNull(p1, p2)) {
            return true;
        }
        if (this.oneIsNulll(p1, p2, "compareProperty", "Property") || this.oneIsNulll(p1.getName(), p2.getName(), "compareProperty", "Property Name") || this.oneIsNulll(p1.getValue(), p2.getValue(), "compareProperty", "Property Value")) {
            return false;
        }
        if (!this.bothAreNull(p1.getName(), p2.getName()) && !p1.getName().equals(p2.getName())) {
            LOGGER.warning("compareProperty warning: Property name difference.");
            return false;
        }
        if (!this.bothAreNull(p1.getValue(), p2.getValue()) && !p1.getValue().equals(p2.getValue())) {
            LOGGER.warning("compareProperty warning: Property value difference.");
            return false;
        }
        if (p1.isReadOnly() != p2.isReadOnly()) {
            LOGGER.warning("compareProperty warning: isReadOnly difference.");
            return false;
        }
        return true;
    }

    public boolean bothAreNull(Object o1, Object o2) {
        return o1 == null && o2 == null;
    }

    public boolean oneIsNulll(Object o1, Object o2, String function, String type) {
        if (o1 == null && o2 != null) {
            LOGGER.warning(function + " warning: " + type + " 1 is null and " + type + " 2 is not null.");
            return true;
        }
        if (o1 != null && o2 == null) {
            LOGGER.warning(function + " warning: " + type + " 1 is not null and " + type + " 2 is null.");
            return true;
        }
        return false;
    }
}

