/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.removetarget;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.common.removetarget.Parameters;

@UsingParameters(value=Parameters.class)
public class RemoveTargetStep
extends BasePipelineStep {
    private List<String> tuIds;
    private Parameters params = new Parameters();

    @Override
    public String getDescription() {
        return "Remove targets in all or a given set of text units. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Remove Target";
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.tuIds = ListUtil.stringAsList(this.params.getTusForTargetRemoval());
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        String id = event.getResource().getId();
        if (Util.isEmpty(this.tuIds) || this.tuIds.contains(id)) {
            TextUnit tu = (TextUnit)event.getResource();
            for (LocaleId locId : tu.getTargetLocales()) {
                tu.removeTarget(locId);
            }
        }
        return super.handleTextUnit(event);
    }
}

