/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class CorpusFilterWriter
implements IFilterWriter {
    private OutputStreamWriter srcWriter;
    private OutputStream srcOutputStream;
    private String srcOutputPath;
    private File srcTempFile;
    private OutputStreamWriter trgWriter;
    private OutputStream trgOutputStream;
    private String trgOutputPath;
    private File trgTempFile;
    private String baseOutputPath;
    private LocaleId trgLoc;
    private String linebreak = System.getProperty("line.separator");

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.srcWriter == null) {
            return;
        }
        try {
            this.srcWriter.close();
            this.srcWriter = null;
            if (this.srcOutputStream != null) {
                this.srcOutputStream.close();
                this.srcOutputStream = null;
            }
            if (this.srcTempFile != null) {
                Util.copy((InputStream)new FileInputStream(this.srcTempFile), this.srcOutputPath);
            }
            this.trgWriter.close();
            this.trgWriter = null;
            if (this.trgOutputStream != null) {
                this.trgOutputStream.close();
                this.trgOutputStream = null;
            }
            if (this.trgTempFile != null) {
                Util.copy((InputStream)new FileInputStream(this.trgTempFile), this.trgOutputPath);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing the output files.", e);
        }
    }

    @Override
    public String getName() {
        return "CorpusFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.initialize();
                break;
            }
            case START_DOCUMENT: {
                this.handleStartDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.close();
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        this.baseOutputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new OkapiNotImplementedException("The method setOutput(OutputStream) is not supported for this filter-writer.");
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void initialize() {
    }

    private void handleStartDocument(Event event) {
        try {
            this.srcTempFile = null;
            this.trgTempFile = null;
            StartDocument sd = (StartDocument)event.getResource();
            this.srcOutputPath = this.baseOutputPath + "." + sd.getLocale().toBCP47().toLowerCase();
            this.trgOutputPath = this.baseOutputPath + "." + this.trgLoc.toBCP47().toLowerCase();
            boolean useTemp = false;
            File f = new File(this.srcOutputPath);
            if (f.exists()) {
                boolean bl = useTemp = !f.delete();
            }
            if (useTemp) {
                this.srcTempFile = File.createTempFile("gfwTmp", null);
                this.srcOutputStream = new BufferedOutputStream(new FileOutputStream(this.srcTempFile.getAbsolutePath()));
            } else {
                Util.createDirectories(this.srcOutputPath);
                this.srcOutputStream = new BufferedOutputStream(new FileOutputStream(this.srcOutputPath));
            }
            this.srcWriter = new OutputStreamWriter(this.srcOutputStream, "UTF-8");
            useTemp = false;
            f = new File(this.trgOutputPath);
            if (f.exists()) {
                boolean bl = useTemp = !f.delete();
            }
            if (useTemp) {
                this.trgTempFile = File.createTempFile("gfwTmp", null);
                this.trgOutputStream = new BufferedOutputStream(new FileOutputStream(this.trgTempFile.getAbsolutePath()));
            } else {
                Util.createDirectories(this.trgOutputPath);
                this.trgOutputStream = new BufferedOutputStream(new FileOutputStream(this.trgOutputPath));
            }
            this.trgWriter = new OutputStreamWriter(this.trgOutputStream, "UTF-8");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        if (trgCont == null) {
            return;
        }
        if (!srcCont.contentIsOneSegment()) {
            this.writeLine(srcCont.getFirstContent(), trgCont.getFirstContent());
            return;
        }
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcCont.getSegments()) {
            Segment trgSeg = trgSegs.get(srcSeg.id);
            if (trgSeg == null) continue;
            this.writeLine(srcSeg.text, trgSeg.text);
        }
    }

    private void writeLine(TextFragment srcFrag, TextFragment trgFrag) {
        try {
            this.srcWriter.write(this.format(srcFrag));
            this.srcWriter.write(this.linebreak);
            this.trgWriter.write(this.format(trgFrag));
            this.trgWriter.write(this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing line.", e);
        }
    }

    private String format(TextFragment frag) {
        return TextUnitUtil.getText(frag);
    }
}

