/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final String FORMAT_TMX = "tmx";
    public static final String FORMAT_PO = "po";
    public static final String FORMAT_TABLE = "table";
    public static final String FORMAT_PENSIEVE = "pensieve";
    public static final String FORMAT_CORPUS = "corpus";
    public static final int TRG_TARGETOREMPTY = 0;
    public static final int TRG_FORCESOURCE = 1;
    public static final int TRG_FORCEEMPTY = 2;
    private static final String SINGLEOUTPUT = "singleOutput";
    private static final String AUTOEXTENSIONS = "autoExtensions";
    private static final String OUTPUTPATH = "outputPath";
    private static final String TARGETSTYLE = "targetStyle";
    private static final String OUTPUTFORMAT = "outputFormat";
    private static final String FORMATOPTIONS = "formatOptions";
    private static final String USEGENERICCODES = "useGenericCodes";
    private static final String SKIPENTRIESWITHOUTTEXT = "skipEntriesWithoutText";
    private static final String APPROVEDENTRIESONLY = "approvedEntriesOnly";
    private static final String OVERWRITESAMESOURCE = "overwriteSameSource";
    private boolean singleOutput;
    private boolean autoExtensions;
    private String outputPath;
    private int targetStyle;
    private String outputFormat;
    private boolean useGenericCodes;
    private String formatOptions;
    private boolean skipEntriesWithoutText;
    private boolean approvedEntriesOnly;
    private boolean overwriteSameSource;

    public Parameters() {
        this.reset();
    }

    public int getTargetStyle() {
        return this.targetStyle;
    }

    public void setTargetStyle(int targetStyle) {
        this.targetStyle = targetStyle;
    }

    public boolean getSingleOutput() {
        return this.singleOutput;
    }

    public void setSingleOutput(boolean singleOutput) {
        this.singleOutput = singleOutput;
    }

    public boolean getAutoExtensions() {
        return this.autoExtensions;
    }

    public void setAutoExtensions(boolean autoExtensions) {
        this.autoExtensions = autoExtensions;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean getUseGenericCodes() {
        return this.useGenericCodes;
    }

    public void setUseGenericCodes(boolean useGenericCodes) {
        this.useGenericCodes = useGenericCodes;
    }

    public String getFormatOptions() {
        return this.formatOptions;
    }

    public void setFormatOptions(String formatOptions) {
        this.formatOptions = formatOptions;
    }

    public boolean getSkipEntriesWithoutText() {
        return this.skipEntriesWithoutText;
    }

    public void setSkipEntriesWithoutText(boolean skipEntriesWithoutText) {
        this.skipEntriesWithoutText = skipEntriesWithoutText;
    }

    public boolean getApprovedEntriesOnly() {
        return this.approvedEntriesOnly;
    }

    public void setApprovedEntriesOnly(boolean approvedEntriesOnly) {
        this.approvedEntriesOnly = approvedEntriesOnly;
    }

    public boolean getOverwriteSameSource() {
        return this.overwriteSameSource;
    }

    public void setOverwriteSameSource(boolean overwriteSameSource) {
        this.overwriteSameSource = overwriteSameSource;
    }

    @Override
    public void reset() {
        this.singleOutput = true;
        this.autoExtensions = false;
        this.targetStyle = 0;
        this.outputPath = "";
        this.outputFormat = FORMAT_TMX;
        this.formatOptions = null;
        this.useGenericCodes = false;
        this.skipEntriesWithoutText = true;
        this.approvedEntriesOnly = false;
        this.overwriteSameSource = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.singleOutput = this.buffer.getBoolean(SINGLEOUTPUT, this.singleOutput);
        this.autoExtensions = this.buffer.getBoolean(AUTOEXTENSIONS, this.autoExtensions);
        this.targetStyle = this.buffer.getInteger(TARGETSTYLE, this.targetStyle);
        this.outputPath = this.buffer.getString(OUTPUTPATH, this.outputPath);
        this.outputFormat = this.buffer.getString(OUTPUTFORMAT, this.outputFormat);
        this.formatOptions = this.buffer.getGroup(FORMATOPTIONS, this.formatOptions);
        this.useGenericCodes = this.buffer.getBoolean(USEGENERICCODES, this.useGenericCodes);
        this.skipEntriesWithoutText = this.buffer.getBoolean(SKIPENTRIESWITHOUTTEXT, this.skipEntriesWithoutText);
        this.approvedEntriesOnly = this.buffer.getBoolean(APPROVEDENTRIESONLY, this.approvedEntriesOnly);
        this.overwriteSameSource = this.buffer.getBoolean(OVERWRITESAMESOURCE, this.overwriteSameSource);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(SINGLEOUTPUT, this.singleOutput);
        this.buffer.setBoolean(AUTOEXTENSIONS, this.autoExtensions);
        this.buffer.setInteger(TARGETSTYLE, this.targetStyle);
        this.buffer.setString(OUTPUTPATH, this.outputPath);
        this.buffer.setString(OUTPUTFORMAT, this.outputFormat);
        this.buffer.setGroup(FORMATOPTIONS, this.formatOptions);
        this.buffer.setBoolean(USEGENERICCODES, this.useGenericCodes);
        this.buffer.setBoolean(SKIPENTRIESWITHOUTTEXT, this.skipEntriesWithoutText);
        this.buffer.setBoolean(APPROVEDENTRIESONLY, this.approvedEntriesOnly);
        this.buffer.setBoolean(OVERWRITESAMESOURCE, this.overwriteSameSource);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SINGLEOUTPUT, "Create a single output document", null);
        desc.add(AUTOEXTENSIONS, "Output paths are the input paths plus the new format extension", null);
        desc.add(OUTPUTPATH, "Output path", "Full path of the single output document to generate");
        desc.add(OUTPUTFORMAT, "Output format", "Format to generate in output");
        desc.add(USEGENERICCODES, "Output generic inline codes", null);
        desc.add(TARGETSTYLE, "Target content", "Type of content to put in the target");
        desc.add(SKIPENTRIESWITHOUTTEXT, "Do not output entries without text", null);
        desc.add(APPROVEDENTRIESONLY, "Output only approved entries", null);
        desc.add(OVERWRITESAMESOURCE, "Overwrite if source is the same (for Pensieve TM)", null);
        desc.add(FORMATOPTIONS, "Format options", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Format Conversion", true, false);
        String[] choices = new String[]{FORMAT_PO, FORMAT_TMX, FORMAT_TABLE, FORMAT_PENSIEVE, FORMAT_CORPUS};
        String[] choicesLabels = new String[]{"PO File", "TMX Document", "Tab-Delimited Table", "Pensieve TM", "Parallel Corpus Files"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(OUTPUTFORMAT), choices);
        lsp.setChoicesLabels(choicesLabels);
        desc.addCheckboxPart(paramDesc.get(APPROVEDENTRIESONLY));
        desc.addCheckboxPart(paramDesc.get(USEGENERICCODES));
        desc.addCheckboxPart(paramDesc.get(OVERWRITESAMESOURCE));
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(SINGLEOUTPUT));
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Output File", true);
        pip.setMasterPart(cbp1, true);
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(AUTOEXTENSIONS));
        cbp2.setMasterPart(cbp1, false);
        return desc;
    }
}

