/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.Util;

public class TableFilterWriterParameters
extends BaseParameters {
    public static final String INLINE_ORIGINAL = "original";
    public static final String INLINE_TMX = "tmx";
    public static final String INLINE_XLIFF = "xliff";
    public static final String INLINE_XLIFFGX = "xliffgx";
    public static final String INLINE_GENERIC = "generic";
    static final String INLINEFORMAT = "inlineFormat";
    static final String USEDOUBLEQUOTES = "useDoubleQuotes";
    static final String SEPARATOR = "separator";
    private String inlineFormat;
    private boolean useDoubleQuotes;
    private String separator;

    public TableFilterWriterParameters() {
        this.reset();
    }

    public String getInlineFormat() {
        return this.inlineFormat;
    }

    public void setInlineFormat(String inlineFormat) {
        this.inlineFormat = inlineFormat;
    }

    public boolean getUseDoubleQuotes() {
        return this.useDoubleQuotes;
    }

    public void setUseDoubleQuotes(boolean useDoubleQuotes) {
        this.useDoubleQuotes = useDoubleQuotes;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public void reset() {
        this.inlineFormat = INLINE_ORIGINAL;
        this.useDoubleQuotes = false;
        this.separator = "\t";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.inlineFormat = this.buffer.getString(INLINEFORMAT, this.inlineFormat);
        this.useDoubleQuotes = this.buffer.getBoolean(USEDOUBLEQUOTES, this.useDoubleQuotes);
        this.separator = this.buffer.getString(SEPARATOR, this.separator);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(INLINEFORMAT, this.inlineFormat);
        this.buffer.setBoolean(USEDOUBLEQUOTES, this.useDoubleQuotes);
        this.buffer.setString(SEPARATOR, this.separator);
        return this.buffer.toString();
    }

    public void fromArguments(String format, String inlineFormat) {
        if (!Util.isEmpty(format)) {
            if (format.equals("csv")) {
                this.separator = ",";
                this.useDoubleQuotes = true;
            } else if (format.equals("tab")) {
                this.separator = "\t";
                this.useDoubleQuotes = false;
            } else {
                throw new RuntimeException(String.format("Invalid option '%s' in format options.", format));
            }
        }
        if (!Util.isEmpty(inlineFormat)) {
            if (inlineFormat.equals(INLINE_GENERIC) || inlineFormat.equals(INLINE_TMX) || inlineFormat.equals(INLINE_XLIFF) || inlineFormat.equals(INLINE_XLIFFGX) || inlineFormat.equals(INLINE_ORIGINAL)) {
                this.inlineFormat = inlineFormat;
            } else {
                throw new RuntimeException(String.format("Invalid option '%s' in codes options.", inlineFormat));
            }
        }
    }
}

