/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.gttbatchtranslation;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String EMAIL = "email";
    private static final String PASSWORD = "password";
    private static final String TMXPATH = "tmxPath";
    private static final String WAITCLASS = "waitClass";
    private static final String MARKASMT = "markAsMT";
    private static final String OPENGTTPAGES = "openGttPages";
    private String email;
    private String password;
    private String tmxPath;
    private String waitClass;
    private boolean markAsMT;
    private boolean openGttPages;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.email = this.buffer.getString(EMAIL, this.email);
        this.password = this.buffer.getEncodedString(PASSWORD, this.password);
        this.tmxPath = this.buffer.getString(TMXPATH, this.tmxPath);
        this.waitClass = this.buffer.getString(WAITCLASS, this.waitClass);
        this.markAsMT = this.buffer.getBoolean(MARKASMT, this.markAsMT);
        this.openGttPages = this.buffer.getBoolean(OPENGTTPAGES, this.openGttPages);
    }

    @Override
    public void reset() {
        this.email = "";
        this.password = "";
        this.tmxPath = "${rootDir}/tmFromGTT.tmx";
        this.markAsMT = true;
        this.openGttPages = true;
        this.waitClass = "net.sf.okapi.common.ui.WaitDialog";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(EMAIL, this.email);
        this.buffer.setEncodedString(PASSWORD, this.password);
        this.buffer.setString(TMXPATH, this.tmxPath);
        this.buffer.setString(WAITCLASS, this.waitClass);
        this.buffer.setBoolean(MARKASMT, this.markAsMT);
        this.buffer.setBoolean(OPENGTTPAGES, this.openGttPages);
        return this.buffer.toString();
    }

    public boolean getMarkAsMT() {
        return this.markAsMT;
    }

    public void setMarkAsMT(boolean markAsMT) {
        this.markAsMT = markAsMT;
    }

    public boolean getOpenGttPages() {
        return this.openGttPages;
    }

    public void setOpenGttPages(boolean openGttPages) {
        this.openGttPages = openGttPages;
    }

    public String getTmxPath() {
        return this.tmxPath;
    }

    public void setTmxPath(String tmxPath) {
        this.tmxPath = tmxPath;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getWaitClass() {
        return this.waitClass;
    }

    public void setWaitClass(String waitClass) {
        this.waitClass = waitClass;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(EMAIL, "Email address", "Email address of the Google Translator Toolkit account");
        desc.add(PASSWORD, "Password", "Password of the account");
        desc.add(TMXPATH, "TMX document to create", "Full path of the new TMX document to create");
        desc.add(MARKASMT, "Mark the generated translation as machine translation results", null);
        desc.add(OPENGTTPAGES, "Open the GTT edit pages automatically after upload", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Google Translator Toolkit Settings");
        desc.addTextInputPart(paramsDesc.get(EMAIL));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        SeparatorPart sp = desc.addSeparatorPart();
        sp.setVertical(true);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(MARKASMT));
        cbp.setVertical(true);
        cbp = desc.addCheckboxPart(paramsDesc.get(OPENGTTPAGES));
        cbp.setVertical(true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXPATH), "TMX Path", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setVertical(true);
        pip.setLabelFlushed(false);
        return desc;
    }
}

