/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idaligner;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.idaligner.Parameters;

@UsingParameters(value=Parameters.class)
public class IdBasedAlignerStep
extends BasePipelineStep {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Parameters params = new Parameters();
    private IFilter filter = null;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private RawDocument targetInput = null;
    private TMXWriter tmx;
    private Map<String, ITextUnit> targetTextUnitMap;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @Override
    public String getDescription() {
        return "Align text units in two id-based files (e.g. Java properties). Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Id-Based Aligner";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (this.tmx == null && this.params.getGenerateTMX()) {
            this.tmx = new TMXWriter(this.params.getTmxOutputPath());
            this.tmx.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), null, "paragraph", null, null);
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.tmx != null) {
            this.tmx.writeEndDocument();
            this.tmx.close();
            this.tmx = null;
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput != null) {
            this.targetTextUnitMap = new HashMap<String, ITextUnit>();
            this.getTargetTextUnits();
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.filter != null) {
            this.filter.close();
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        ITextUnit sourceTu = sourceEvent.getTextUnit();
        if (!sourceTu.isTranslatable() || sourceTu.isEmpty()) {
            return sourceEvent;
        }
        ITextUnit alignedTextUnit = sourceTu.clone();
        TextContainer targetTC = sourceTu.getSource();
        if (this.targetInput != null) {
            TextFragment atf = TextUnitUtil.adjustTargetCodes(sourceTu.getSource().getUnSegmentedContentCopy(), targetTC.getUnSegmentedContentCopy(), true, false, null, sourceTu);
            targetTC.setContent(atf);
            if (this.targetTextUnitMap.containsKey(sourceTu.getName())) {
                alignedTextUnit.setTarget(this.targetLocale, targetTC);
            } else {
                this.logger.warning("String is missing from the target: " + sourceTu.getName());
                if (this.params.getReplaceWithSource()) {
                    alignedTextUnit.setTarget(this.targetLocale, sourceTu.getSource());
                }
            }
        }
        if (!this.params.getGenerateTMX()) {
            return new Event(EventType.TEXT_UNIT, alignedTextUnit);
        }
        this.tmx.writeTUFull(alignedTextUnit);
        return sourceEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTargetTextUnits() {
        try {
            this.filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);
            this.filter.open(this.targetInput);
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                if (event.getEventType() != EventType.TEXT_UNIT) continue;
                this.targetTextUnitMap.put(event.getTextUnit().getName(), event.getTextUnit());
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
        }
    }
}

