/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.common;

import java.io.File;
import java.io.OutputStream;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.IPackageWriter;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;

public abstract class BasePackageWriter
implements IPackageWriter {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected Parameters params;
    protected Manifest manifest;
    protected int docId;
    protected String extractionType;
    protected ISkeletonWriter skelWriter;
    protected TMXWriter tmxWriterApproved;
    protected String tmxPathApproved;
    protected TMXWriter tmxWriterUnApproved;
    protected String tmxPathUnApproved;
    protected TMXWriter tmxWriterAlternates;
    protected String tmxPathAlternates;
    protected TMXWriter tmxWriterLeverage;
    protected String tmxPathLeverage;
    protected boolean copiedTargetsLikeApproved = false;

    public BasePackageWriter(String extractionType) {
        this.extractionType = extractionType;
        this.manifest = new Manifest();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setBatchInformation(String packageRoot, LocaleId srcLoc, LocaleId trgLoc, String inputRoot, String packageId, String projectId, String creatorParams) {
        this.manifest.setInformation(packageRoot, srcLoc, trgLoc, inputRoot, packageId, projectId, creatorParams);
    }

    @Override
    public String getMainOutputPath() {
        return this.manifest.getPath();
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.processStartBatch();
                break;
            }
            case END_BATCH: {
                this.processEndBatch();
                break;
            }
            case START_BATCH_ITEM: {
                this.processStartBatchItem();
                break;
            }
            case RAW_DOCUMENT: {
                this.processRawDocument(event);
                break;
            }
            case END_BATCH_ITEM: {
                this.processEndBatchItem();
                break;
            }
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument(event);
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: {
                this.processEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        throw new UnsupportedOperationException("Use setDocumentInformation instead.");
    }

    @Override
    public void setOutput(String path) {
        throw new UnsupportedOperationException("Use setDocumentInformation instead.");
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new UnsupportedOperationException("Output to stream not supported for now");
    }

    protected void processStartBatch() {
        this.docId = 0;
        this.initializeTMXWriters();
    }

    protected void setTMXInfo(boolean generate, String pathApproved, String pathUnApproved, String pathAlternates, String pathLeverage) {
        if (!generate) {
            this.tmxPathApproved = null;
            this.tmxPathUnApproved = null;
            this.tmxPathAlternates = null;
            this.tmxPathLeverage = null;
            return;
        }
        if (pathApproved == null) {
            if (this.tmxPathApproved == null) {
                this.tmxPathApproved = this.manifest.getTmDirectory() + "approved.tmx";
            }
        } else {
            this.tmxPathApproved = pathApproved;
        }
        if (pathUnApproved == null) {
            if (this.tmxPathUnApproved == null) {
                this.tmxPathUnApproved = this.manifest.getTmDirectory() + "unapproved.tmx";
            }
        } else {
            this.tmxPathUnApproved = pathUnApproved;
        }
        if (pathAlternates == null) {
            if (this.tmxPathAlternates == null) {
                this.tmxPathAlternates = this.manifest.getTmDirectory() + "alternates.tmx";
            }
        } else {
            this.tmxPathAlternates = pathAlternates;
        }
        if (pathLeverage == null) {
            if (this.tmxPathLeverage == null) {
                this.tmxPathLeverage = this.manifest.getTmDirectory() + "leverage.tmx";
            }
        } else {
            this.tmxPathLeverage = pathLeverage;
        }
    }

    protected void initializeTMXWriters() {
        if (this.tmxPathApproved != null) {
            this.tmxWriterApproved = new TMXWriter(this.tmxPathApproved);
            this.tmxWriterApproved.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
        if (this.tmxPathUnApproved != null) {
            this.tmxWriterUnApproved = new TMXWriter(this.tmxPathUnApproved);
            this.tmxWriterUnApproved.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
        if (this.tmxPathAlternates != null) {
            this.tmxWriterAlternates = new TMXWriter(this.tmxPathAlternates);
            this.tmxWriterAlternates.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
        if (this.tmxPathLeverage != null) {
            this.tmxWriterLeverage = new TMXWriter(this.tmxPathLeverage);
            this.tmxWriterLeverage.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
    }

    protected void processEndBatch() {
        File file;
        if (this.params.getOutputManifest()) {
            this.manifest.Save();
        }
        if (this.tmxWriterApproved != null) {
            this.tmxWriterApproved.writeEndDocument();
            this.tmxWriterApproved.close();
            if (this.tmxWriterApproved.getItemCount() == 0) {
                file = new File(this.tmxPathApproved);
                file.delete();
            }
        }
        if (this.tmxWriterUnApproved != null) {
            this.tmxWriterUnApproved.writeEndDocument();
            this.tmxWriterUnApproved.close();
            if (this.tmxWriterUnApproved.getItemCount() == 0) {
                file = new File(this.tmxPathUnApproved);
                file.delete();
            }
        }
        if (this.tmxWriterAlternates != null) {
            this.tmxWriterAlternates.writeEndDocument();
            this.tmxWriterAlternates.close();
            if (this.tmxWriterAlternates.getItemCount() == 0) {
                file = new File(this.tmxPathAlternates);
                file.delete();
            }
        }
        if (this.tmxWriterLeverage != null) {
            this.tmxWriterLeverage.writeEndDocument();
            this.tmxWriterLeverage.close();
            if (this.tmxWriterLeverage.getItemCount() == 0) {
                file = new File(this.tmxPathLeverage);
                file.delete();
            }
        }
    }

    protected void processStartBatchItem() {
    }

    protected void processEndBatchItem() {
    }

    protected void processRawDocument(Event event) {
        String ori = this.manifest.getOriginalDirectory();
        if (Util.isEmpty(ori)) {
            return;
        }
        MergingInfo info = this.manifest.getItem(this.docId);
        String inputPath = this.manifest.getInputRoot() + info.getRelativeInputPath();
        String outputPath = ori + info.getRelativeInputPath();
        Util.copyFile(inputPath, outputPath, false);
    }

    @Override
    public void setDocumentInformation(String relativeInputPath, String filterConfigId, String filterParameters, String inputEncoding, String relativeTargetPath, String targetEncoding, ISkeletonWriter skelWriter) {
        if (Util.isEmpty(filterConfigId)) {
            this.manifest.addDocument(++this.docId, "none", relativeInputPath, "", filterParameters, inputEncoding, relativeTargetPath, targetEncoding);
        } else {
            this.skelWriter = skelWriter;
            String[] res = FilterConfigurationMapper.splitFilterFromConfiguration(filterConfigId);
            this.manifest.addDocument(++this.docId, this.extractionType, relativeInputPath, res[0], filterParameters, inputEncoding, relativeTargetPath, targetEncoding);
        }
    }

    protected void processStartDocument(Event event) {
        String ori = this.manifest.getOriginalDirectory();
        if (Util.isEmpty(ori)) {
            return;
        }
        MergingInfo info = this.manifest.getItem(this.docId);
        String inputPath = this.manifest.getInputRoot() + info.getRelativeInputPath();
        String outputPath = ori + info.getRelativeInputPath();
        Util.copyFile(inputPath, outputPath, false);
    }

    protected void processEndDocument(Event event) {
    }

    protected void processStartSubDocument(Event event) {
    }

    protected void processEndSubDocument(Event event) {
    }

    protected void processStartGroup(Event event) {
    }

    protected void processEndGroup(Event event) {
    }

    protected void processDocumentPart(Event event) {
    }

    protected abstract void processTextUnit(Event var1);

    protected void writeTMXEntries(ITextUnit tu) {
        LocaleId trgLoc = this.manifest.getTargetLocale();
        TextContainer tc = tu.getTarget(trgLoc);
        if (tc == null) {
            return;
        }
        if (!tu.getSource().hasText(false)) {
            return;
        }
        boolean done = false;
        if (!tc.isEmpty()) {
            if (tu.hasTargetProperty(trgLoc, "approved") && tu.getTargetProperty(trgLoc, "approved").getValue().equals("yes") && this.tmxWriterApproved != null) {
                this.tmxWriterApproved.writeItem(tu, null);
                done = true;
            }
            if (!done && tu.getSource().compareTo(tc, true) != 0 && this.tmxWriterUnApproved != null) {
                this.tmxWriterUnApproved.writeItem(tu, null);
                done = true;
            }
        }
        ISegments srcSegs = tu.getSource().getSegments();
        for (Segment seg : tc.getSegments()) {
            Segment srcSeg = srcSegs.get(seg.id);
            if (srcSeg == null) continue;
            this.writeAltTranslations(seg.getAnnotation(AltTranslationsAnnotation.class), srcSeg.text);
        }
        TextFragment srcOriginal = tu.getSource().contentIsOneSegment() ? tu.getSource().getFirstContent() : tu.getSource().getUnSegmentedContentCopy();
        this.writeAltTranslations(tc.getAnnotation(AltTranslationsAnnotation.class), srcOriginal);
    }

    private void writeAltTranslations(AltTranslationsAnnotation ann, TextFragment srcOriginal) {
        if (ann == null) {
            return;
        }
        for (AltTranslation alt : ann) {
            if (alt.getFromOriginal()) {
                if (this.tmxWriterAlternates == null) continue;
                this.tmxWriterAlternates.writeAlternate(alt, srcOriginal);
                continue;
            }
            if (this.tmxWriterLeverage == null) continue;
            this.tmxWriterLeverage.writeAlternate(alt, srcOriginal);
        }
    }
}

