/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    static final String PRESERVESEGMENTATION = "preserveSegmentation";
    private boolean preserveSegmentation;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.preserveSegmentation = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.preserveSegmentation = this.buffer.getBoolean(PRESERVESEGMENTATION, this.preserveSegmentation);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(PRESERVESEGMENTATION, this.preserveSegmentation);
        return this.buffer.toString();
    }

    public boolean getPreserveSegmentation() {
        return this.preserveSegmentation;
    }

    public void setPreserveSegmentation(boolean preserveSegmentation) {
        this.preserveSegmentation = preserveSegmentation;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PRESERVESEGMENTATION, "Preserve the segmentation for the next steps", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Rainbow Translation Kit Merging", true, false);
        desc.addCheckboxPart(paramDesc.get(PRESERVESEGMENTATION));
        return desc;
    }
}

