/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.rtf;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.ILayerProvider;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.steps.rainbowkit.rtf.LayerProvider;

public class RTFLayerWriter {
    private ILayerProvider layer;
    private PrintWriter writer;
    private ISkeletonWriter skelWriter;
    private String path;
    private LocaleId targetLocale;
    private String targetEncoding;

    public RTFLayerWriter(ISkeletonWriter skelWriter, String path, LocaleId targetLocale, String targetEncoding) {
        this.skelWriter = skelWriter;
        this.path = path;
        this.targetEncoding = targetEncoding;
        this.targetLocale = targetLocale;
    }

    public void writeEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.writeStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.writeEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                this.writer.write(this.skelWriter.processStartSubDocument((StartSubDocument)event.getResource()));
                break;
            }
            case END_SUBDOCUMENT: {
                this.writer.write(this.skelWriter.processEndSubDocument(event.getEnding()));
                break;
            }
            case START_GROUP: {
                this.writer.write(this.skelWriter.processStartGroup(event.getStartGroup()));
                break;
            }
            case END_GROUP: {
                this.writer.write(this.skelWriter.processEndGroup(event.getEnding()));
                break;
            }
            case DOCUMENT_PART: {
                this.writer.write(this.skelWriter.processDocumentPart(event.getDocumentPart()));
                break;
            }
            case TEXT_UNIT: {
                this.writer.write(this.skelWriter.processTextUnit(event.getTextUnit()));
            }
        }
    }

    private void writeStartDocument(Event event) {
        this.layer = new LayerProvider();
        this.layer.setOptions(null, this.targetEncoding, null);
        if (this.skelWriter == null) {
            throw new InvalidParameterException("You cannot use the RTF writer with no skeleton writer.\nThe filter you are trying to use may be incompatible with an RTF output.");
        }
        if (this.skelWriter instanceof GenericSkeletonWriter) {
            ((GenericSkeletonWriter)this.skelWriter).setReferentCopies(2);
        }
        StartDocument sd = event.getStartDocument();
        try {
            Util.createDirectories(this.path);
            this.writer = new PrintWriter(this.path, this.targetEncoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiIOException("Error creating RTF writer.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiIOException("Error creating RTF writer.", e);
        }
        this.writer.write("{\\rtf1\\ansi\\ansicpg1252\\uc1\\deff1 \n{\\fonttbl \n{\\f1 \\fmodern\\fcharset0\\fprq1 Courier New;}\n{\\f2 \\fswiss\\fcharset0\\fprq2 Arial;}\n{\\f3 \\froman\\fcharset0\\fprq2 Times New Roman;}}\n{\\colortbl \\red0\\green0\\blue0;\\red0\\green0\\blue0;\\red0\\green0\\blue255;\\red0\\green255\\blue255;\\red0\\green255\\blue0;\\red255\\green0\\blue255;\\red255\\green0\\blue0;\\red255\\green255\\blue0;\\red255\\green255\\blue255;\\red0\\green0\\blue128;\\red0\\green128\\blue128;\\red0\\green128\\blue0;\\red128\\green0\\blue128;\\red128\\green0\\blue0;\\red128\\green128\\blue0;\\red128\\green128\\blue128;\\red192\\green192\\blue192;}\n{\\stylesheet \n{\\s0 \\sb80\\slmult1\\widctlpar\\fs20\\f1 \\snext0 Normal;}\n{\\cs1 \\additive \\v\\cf12\\sub\\f1 tw4winMark;}\n{\\cs2 \\additive \\cf4\\fs40\\f1 tw4winError;}\n{\\cs3 \\additive \\f1\\cf11 tw4winPopup;}\n{\\cs4 \\additive \\f1\\cf10 tw4winJump;}\n{\\cs5 \\additive \\cf15\\f1\\lang1024\\noproof tw4winExternal;}\n{\\cs6 \\additive \\cf6\\f1\\lang1024\\noproof tw4winInternal;}\n{\\cs7 \\additive \\cf2 tw4winTerm;}\n{\\cs8 \\additive \\cf13\\f1\\lang1024\\noproof DO_NOT_TRANSLATE;}\n{\\cs9 \\additive Default Paragraph Font;}{\\cs15 \\additive \\v\\f1\\cf12\\sub tw4winMark;}}\n\\paperw11907\\paperh16840\\viewkind4\\viewscale100\\pard\\plain\\s0\\sb80\\slmult1\\widctlpar\\fs20\\f1 \n{\\cs5\\f1\\cf15\\lang1024 ");
        this.writer.write(this.skelWriter.processStartDocument(this.targetLocale, this.targetEncoding, this.layer, sd.getFilterWriter().getEncoderManager(), sd));
    }

    private void writeEndDocument(Event event) {
        this.writer.write(this.skelWriter.processEndDocument(event.getEnding()));
        this.writer.write("}}\n");
        this.writer.close();
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }
}

