/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.xliff.Alternate;
import net.sf.okapi.lib.xliff.Code;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.XLIFFWriter;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Options;

public class XLIFF2PackageWriter
extends BasePackageWriter {
    private static final Logger LOGGER = Logger.getLogger(XLIFF2PackageWriter.class.getName());
    private XLIFFWriter writer;

    public XLIFF2PackageWriter() {
        super("xliff2");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, false);
        this.setTMXInfo(false, null, null, null, null);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        MergingInfo item = this.manifest.getItem(this.docId);
        String path = this.manifest.getSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        XLIFF2Options options = new XLIFF2Options();
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            options.fromString(this.params.getWriterOptions());
        }
        this.writer.setInlineStyle(options.getInlineStyle());
        this.writer.create(new File(path));
        this.writer.setIsIndented(true);
        this.writer.writeStartDocument();
    }

    @Override
    protected void processEndDocument(Event event) {
        this.writer.writeEndDocument();
        this.writer.close();
        this.writer = null;
        super.processEndDocument(event);
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.writer.writeStartFile();
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.writeEndFile();
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.writeStartGroup();
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.writeEndGroup();
    }

    @Override
    protected void processTextUnit(Event event) {
        Unit unit = this.toXLIFF2Unit(event.getTextUnit());
        this.writer.writeUnit(unit);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    private Unit toXLIFF2Unit(ITextUnit tu) {
        Unit unit = new Unit(tu.getId());
        TextContainer srcTc = tu.getSource();
        TextContainer trgTc = null;
        if (tu.hasTarget(this.manifest.getTargetLocale()) && (trgTc = tu.getTarget(this.manifest.getTargetLocale())).getSegments().count() != srcTc.getSegments().count()) {
            LOGGER.warning(String.format("Text unit id='%s' has different number of segments in source and target.\nThis entry will be output un-segmented.", tu.getId()));
            srcTc = tu.getSource().clone();
            srcTc.joinAll();
            trgTc = tu.getTarget(this.manifest.getTargetLocale()).clone();
            trgTc.joinAll();
        }
        for (int i = 0; i < srcTc.count(); ++i) {
            TextPart part = srcTc.get(i);
            if (part.isSegment()) {
                AltTranslationsAnnotation ann;
                Segment srcSeg = (Segment)part;
                net.sf.okapi.lib.xliff.Segment xSeg = new net.sf.okapi.lib.xliff.Segment();
                unit.add(xSeg);
                xSeg.setSource(this.toXLIFF2Fragment(srcSeg.text));
                xSeg.setId(srcSeg.getId());
                if (trgTc == null) continue;
                Segment trgSeg = trgTc.getSegments().get(xSeg.getId());
                if (trgSeg != null) {
                    xSeg.setTarget(this.toXLIFF2Fragment(trgSeg.text));
                    if (i >= trgTc.count() || !trgTc.get(i).equals(trgSeg)) {
                        xSeg.setTargetOrder(i);
                    }
                }
                if ((ann = trgSeg.getAnnotation(AltTranslationsAnnotation.class)) == null) continue;
                for (AltTranslation alt : ann) {
                    this.copyData(alt, srcSeg.text, xSeg);
                }
                continue;
            }
            Part xPart = new Part();
            unit.add(xPart);
            xPart.setSource(this.toXLIFF2Fragment(part.text));
            if (trgTc == null) continue;
        }
        return unit;
    }

    private void copyData(AltTranslation alt, TextFragment oriSource, net.sf.okapi.lib.xliff.Segment xSeg) {
        Fragment src = null;
        Fragment trg = null;
        src = alt.getSource().isEmpty() ? this.toXLIFF2Fragment(oriSource) : this.toXLIFF2Fragment(alt.getSource().getFirstContent());
        trg = this.toXLIFF2Fragment(alt.getTarget().getFirstContent());
        xSeg.addCandidate(new Alternate(src, trg));
    }

    private Fragment toXLIFF2Fragment(TextFragment tf) {
        if (!tf.hasCode()) {
            return new Fragment(tf.getCodedText());
        }
        Fragment frag = new Fragment();
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        for (int i = 0; i < ctext.length(); ++i) {
            if (TextFragment.isMarker(ctext.charAt(i))) {
                int index = TextFragment.toIndex(ctext.charAt(++i));
                Code code = codes.get(index);
                switch (code.getTagType()) {
                    case OPENING: {
                        frag.append(Code.TYPE.OPENING, code.getData());
                        break;
                    }
                    case CLOSING: {
                        frag.append(Code.TYPE.CLOSING, code.getData());
                        break;
                    }
                    case PLACEHOLDER: {
                        frag.append(Code.TYPE.PLACEHOLDER, code.getData());
                    }
                }
                continue;
            }
            frag.append(ctext.charAt(i));
        }
        return frag;
    }
}

