/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.Options;

public class XLIFFPackageWriter
extends BasePackageWriter {
    protected XLIFFWriter writer;
    private boolean preSegmented = false;
    private boolean forOmegat = false;

    public XLIFFPackageWriter() {
        super("xliff");
    }

    public boolean getPreSegmented() {
        return this.preSegmented;
    }

    public void setForOmegat(boolean forOmegat) {
        this.forOmegat = forOmegat;
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, false);
        this.setTMXInfo(true, null, null, null, null);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        this.writer.setOptions(this.manifest.getTargetLocale(), "UTF-8");
        MergingInfo item = this.manifest.getItem(this.docId);
        String path = this.manifest.getSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        this.writer.setOutput(path);
        Options options = new Options();
        if (this.forOmegat) {
            options.setCopySource(true);
            options.setPlaceholderMode(true);
            options.setIncludeAltTrans(false);
            this.writer.setUseSourceForTranslated(true);
        } else if (!Util.isEmpty(this.params.getWriterOptions())) {
            options.fromString(this.params.getWriterOptions());
        }
        this.writer.setPlaceholderMode(options.getPlaceholderMode());
        this.writer.setCopySource(options.getCopySource());
        this.writer.setIncludeAltTrans(options.getIncludeAltTrans());
        this.writer.setSetApprovedAsNoTranslate(options.getSetApprovedAsNoTranslate());
        this.writer.setIncludeNoTranslate(options.getIncludeNoTranslate());
        StartDocument sd = event.getStartDocument();
        this.writer.create(path, null, this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), sd.getMimeType(), item.getRelativeInputPath(), null);
    }

    @Override
    protected void processEndDocument(Event event) {
        this.writer.handleEvent(event);
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        super.processEndDocument(event);
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        event = this.writer.handleEvent(event);
        this.writeTMXEntries(event.getTextUnit());
        if (!this.preSegmented) {
            this.preSegmented = event.getTextUnit().getSource().hasBeenSegmented();
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

