/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=XliffSplitterParameters.class)
public class XliffSplitterParameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final String TRANSLATIONTYPE = "translation_type";
    public static final String TRANSLATIONSTATUS = "translation_status";
    private static final String BIGFILE = "bigFile";
    private static final String FILEMARKER = "fileMarker";
    private static final String UPDATESDLTRANSLATIONSTATUS = "updateSDLTranslationStatus";
    private static final String TRANSLATIONTYPEVALUE = "translationTypeValue";
    private static final String TRANSLATIONSTATUSVALUE = "translationStatusValue";
    private boolean bigFile;
    private String fileMarker;
    private boolean updateSDLTranslationStatus;
    private String translationTypeValue;
    private String translationStatusValue;

    public XliffSplitterParameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.bigFile = false;
        this.fileMarker = "_PART";
        this.updateSDLTranslationStatus = false;
        this.translationTypeValue = "manual_translation";
        this.translationStatusValue = "finished";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.bigFile = this.buffer.getBoolean(BIGFILE, this.bigFile);
        this.fileMarker = this.buffer.getString(FILEMARKER, this.fileMarker);
        this.updateSDLTranslationStatus = this.buffer.getBoolean(UPDATESDLTRANSLATIONSTATUS, this.updateSDLTranslationStatus);
        this.translationTypeValue = this.buffer.getString(TRANSLATIONTYPEVALUE, this.translationTypeValue);
        this.translationStatusValue = this.buffer.getString(TRANSLATIONSTATUSVALUE, this.translationStatusValue);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(BIGFILE, this.bigFile);
        this.buffer.setString(FILEMARKER, this.fileMarker);
        this.buffer.setBoolean(UPDATESDLTRANSLATIONSTATUS, this.updateSDLTranslationStatus);
        this.buffer.setString(TRANSLATIONTYPEVALUE, this.translationTypeValue);
        this.buffer.setString(TRANSLATIONSTATUSVALUE, this.translationStatusValue);
        return this.buffer.toString();
    }

    public boolean isBigFile() {
        return this.bigFile;
    }

    public void setBigFile(boolean bigFile) {
        this.bigFile = bigFile;
    }

    public String getFileMarker() {
        return this.fileMarker;
    }

    public void setFileMarker(String fileMarker) {
        this.fileMarker = fileMarker;
    }

    public boolean isUpdateSDLTranslationStatus() {
        return this.updateSDLTranslationStatus;
    }

    public void setUpdateSDLTranslationStatus(boolean updateSDLTranslationStatus) {
        this.updateSDLTranslationStatus = updateSDLTranslationStatus;
    }

    public String getTranslationTypeValue() {
        return this.translationTypeValue;
    }

    public void setTranslationTypeValue(String translationTypeValue) {
        this.translationTypeValue = translationTypeValue;
    }

    public String getTranslationStatusValue() {
        return this.translationStatusValue;
    }

    public void setTranslationStatusValue(String translationStatusValue) {
        this.translationStatusValue = translationStatusValue;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(BIGFILE, "Process big file", null);
        desc.add(FILEMARKER, "File marker", null);
        desc.add(UPDATESDLTRANSLATIONSTATUS, "Update the <iws:status> translation status (WorldServer-specific)", null);
        desc.add(TRANSLATIONTYPEVALUE, String.format("Value for '%s'", TRANSLATIONTYPE), String.format("Value to set for the %s attribute.", TRANSLATIONTYPE));
        desc.add(TRANSLATIONSTATUSVALUE, String.format("Value for '%s'", TRANSLATIONSTATUS), String.format("Value to set for the %s attribute.", TRANSLATIONSTATUS));
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Splitter", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(BIGFILE));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(FILEMARKER));
        tip.setVertical(false);
        tip.setMasterPart(cbp, true);
        desc.addSeparatorPart();
        cbp = desc.addCheckboxPart(paramsDesc.get(UPDATESDLTRANSLATIONSTATUS));
        tip = desc.addTextInputPart(paramsDesc.get(TRANSLATIONTYPEVALUE));
        tip.setVertical(false);
        tip.setMasterPart(cbp, true);
        tip = desc.addTextInputPart(paramsDesc.get(TRANSLATIONSTATUSVALUE));
        tip.setVertical(false);
        tip.setMasterPart(cbp, true);
        return desc;
    }
}

