/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.RegexUtil;
import org.junit.Assert;
import org.junit.Test;

public class RegexUtilTest {
    @Test
    public void testReplaceAll() {
        Assert.assertEquals((Object)"e{1@^}ddddd{2@^5}+", (Object)RegexUtil.replaceAll("e{1,}ddddd{2,5}+", "\\{.*?(,).*?\\}", 1, "@^"));
    }

    @Test
    public void testCountMatches() {
        Assert.assertEquals((long)3L, (long)RegexUtil.countMatches("1 text 2 text 1 text 1 text 2", "1"));
        Assert.assertEquals((long)2L, (long)RegexUtil.countMatches("1 text 2 text 1 text 1 text 2", "2"));
    }

    @Test
    public void testCountQualifiers() {
        Assert.assertEquals((long)3L, (long)RegexUtil.countLeadingQualifiers("\"text, \"text\", text,\"text\"\"\"", "\""));
        Assert.assertEquals((long)4L, (long)RegexUtil.countTrailingQualifiers("\"text, \"text\", text,\"text\"\"\"", "\""));
        Assert.assertEquals((long)3L, (long)RegexUtil.countLeadingQualifiers("\"\u0432\u0430\u0432\u044b, \"\u044b\u0432\u044b\u0432\u0430\u044b\u0432\u0432\u0430\", \u044b\u0432\u0430\u0430\u0430,\"\u044b\u0444\u044b\u0432\u044b\"\"\"", "\""));
        Assert.assertEquals((long)4L, (long)RegexUtil.countTrailingQualifiers("\"\u0432\u0430\u0432\u044b, \"\u044b\u0432\u044b\u0432\u0430\u044b\u0432\u0432\u0430\", \u044b\u0432\u0430\u0430\u0430,\"\u044b\u0444\u044b\u0432\u044b\"\"\"", "\""));
    }
}

