/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.XMLWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XMLWriterTest {
    XMLWriter writer;
    StringWriter sWriter;

    @Before
    public void setUp() {
        this.sWriter = new StringWriter();
        this.writer = new XMLWriter(this.sWriter);
    }

    @Test
    public void constructorWithPath() throws IOException {
        String filename = "target/test-classes/some/dir/to/be/created/some.xml";
        this.writer = new XMLWriter("target/test-classes/some/dir/to/be/created/some.xml");
        File f = new File("target/test-classes/some/dir/to/be/created/some.xml");
        Assert.assertTrue((String)"A file should have been created along with the directory structure", (boolean)f.exists());
        this.writer.writeStartDocument();
        this.writer.close();
        String xml = TestUtil.getFileAsString(f);
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)xml.trim());
        Assert.assertTrue((String)("Could not delete file " + f.getPath()), (boolean)f.delete());
    }

    @Test
    public void constructorWithWriter() {
        Assert.assertEquals((String)"writer's contents", (Object)"", (Object)this.sWriter.toString());
    }

    @Test
    public void writeStartDocument() {
        this.writer.writeStartDocument();
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)this.sWriter.toString().trim());
    }

    @Test
    public void writeEndDocumentNoStartTag() {
        this.writer.writeStartDocument();
        this.writer.writeEndDocument();
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)this.sWriter.toString().trim());
    }

    @Test
    public void writeStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("joe");
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><joe", (Object)xml);
    }

    @Test
    public void writeStartElementWithPreviousStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("jack");
        this.writer.writeStartElement("diane");
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><jack><diane", (Object)xml);
    }

    @Test
    public void writeEndElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("jack");
        this.writer.writeEndElement();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><jack></jack>", (Object)xml);
    }

    @Test(expected=EmptyStackException.class)
    public void writeEndElementNoStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeEndElement();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)xml);
    }

    @Test
    public void writeEndElementLineBreakStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("mary");
        this.writer.writeEndElementLineBreak();
        String xml = this.sWriter.toString();
        Pattern p = Pattern.compile("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>[\\n\\r]+<mary></mary>[\\r\\n]+", 8);
        Matcher m = p.matcher(xml);
        Assert.assertTrue((String)"New lines were not written", (boolean)m.matches());
    }

    @Test(expected=EmptyStackException.class)
    public void writeEndElementLineBreakNoStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeEndElementLineBreak();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals((String)"writer's contents", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)xml);
    }

    @Test
    public void writeLeadingSpaces() {
        this.writer.writeStartElement("w:t");
        this.writer.writeAttributeString("xml:space", "preserve");
        this.writer.writeString(" (");
        this.writer.writeEndElement();
        Assert.assertEquals((Object)"<w:t xml:space=\"preserve\"> (</w:t>", (Object)this.sWriter.toString());
    }
}

